/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.popup.PopupBuilder;
import net.minecraft.client.gui.popup.PopupScreen;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.packet.CustomPayloadPacket;

public class WandMobPickerScreen
extends Screen {
    private String mobId;
    private boolean shouldClose = false;
    private final ItemStack wand;

    public WandMobPickerScreen(String mobId, ItemStack itemStack) {
        this.mobId = mobId;
        this.wand = itemStack;
    }

    @Override
    public void init() {
        ArrayList<String> monsters = new ArrayList<String>();
        for (Class<? extends Entity> clazz : EntityDispatcher.classToKeyMap.keySet()) {
            if (!Mob.class.isAssignableFrom(clazz) || Modifier.isAbstract(clazz.getModifiers())) continue;
            monsters.add(EntityDispatcher.classToKeyMap.get(clazz));
        }
        Collections.sort(monsters);
        ArrayList<String> prettyMonsters = new ArrayList<String>();
        for (String monster : monsters) {
            StringBuilder sb = new StringBuilder();
            for (char c : monster.toCharArray()) {
                if (Character.isUpperCase(c)) {
                    sb.append(' ');
                }
                sb.append(c);
            }
            prettyMonsters.add(sb.toString());
        }
        PopupScreen popup = new PopupBuilder(this, 150).withLabel("gui.pick_monster.label.title").withList("list", 140, prettyMonsters.toArray(new String[0]), null, -1, true).closeOnEsc(0).closeOnClickOut(0).withOnCloseListener((statusCode, results) -> {
            if (statusCode == 1) {
                this.mobId = (String)monsters.get((Integer)results.get("list"));
                if (!this.mc.theWorld.isClientSide) {
                    this.wand.getData().putString("monster", this.mobId);
                } else {
                    this.mc.getSendQueue().addToSendQueue(new CustomPayloadPacket("BTA|WandMonster", this.mobId.getBytes(StandardCharsets.UTF_8)));
                }
            }
            this.shouldClose = true;
        }).build();
        this.mc.displayScreen(popup);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.shouldClose) {
            this.mc.displayScreen(null);
        }
    }

    public String getMobId() {
        return this.mobId;
    }
}

