/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook.crafting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ItemElement;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.client.gui.guidebook.GuidebookPage;
import net.minecraft.client.gui.guidebook.GuidebookScreen;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.gui.guidebook.GuidebookSections;
import net.minecraft.client.gui.guidebook.GuidebookSlot;
import net.minecraft.client.gui.guidebook.PageManager;
import net.minecraft.client.gui.guidebook.RecipePage;
import net.minecraft.client.gui.guidebook.crafting.displays.LabelDisplayAdapter;
import net.minecraft.client.gui.guidebook.crafting.displays.LabelDyeDisplayAdapter;
import net.minecraft.client.gui.guidebook.crafting.displays.MapDuplicationDisplayAdapter;
import net.minecraft.client.gui.guidebook.crafting.displays.RecipeDisplayAdapter;
import net.minecraft.client.gui.guidebook.crafting.displays.RepairableDisplayAdapter;
import net.minecraft.client.gui.guidebook.crafting.displays.ScrapDisplayAdapter;
import net.minecraft.client.gui.guidebook.crafting.displays.ShapedDisplayAdapter;
import net.minecraft.client.gui.guidebook.crafting.displays.ShapelessDisplayAdapter;
import net.minecraft.client.gui.guidebook.crafting.displays.ToolDisplayAdapter;
import net.minecraft.client.gui.guidebook.crafting.displays.UndyeDisplayAdapter;
import net.minecraft.client.gui.guidebook.search.SearchPage;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.TextureManager;
import net.minecraft.core.achievement.Achievements;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCrafting;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingShaped;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingShapeless;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingWithTool;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryLabel;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryLabelDye;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryMapDuplication;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryRepairable;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryScrap;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryUndyeing;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.player.inventory.slot.Slot;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class CraftingPage
extends RecipePage<RecipeEntryCrafting<?, ?>> {
    public static final int RECIPES_PER_PAGE = 3;
    public List<GuidebookSlot> slots;
    public Map<RecipeEntryCrafting<?, ?>, List<GuidebookSlot>> map;
    public static Map<Class<? extends RecipeEntryCrafting<?, ?>>, RecipeDisplayAdapter<?>> recipeToDisplayAdapterMap = new HashMap();
    private final TooltipElement tooltipElement;
    private final ItemElement itemElement;
    private static final Minecraft mc;
    private static Player player;
    private static long ticks;

    public CraftingPage(GuidebookSection section, List<RecipeEntryCrafting<?, ?>> recipes) {
        super(section);
        this.recipes = recipes;
        this.slots = new ArrayList<GuidebookSlot>();
        this.map = new HashMap();
        player = CraftingPage.mc.thePlayer;
        player.addStat(Achievements.OPEN_GUIDEBOOK, 1);
        this.tooltipElement = new TooltipElement(mc);
        this.itemElement = new ItemElement(mc);
        int recipeAmount = 0;
        int xOffset = 32;
        int yOffset = 12;
        for (RecipeEntryCrafting<?, ?> recipe : recipes) {
            if (!recipeToDisplayAdapterMap.containsKey(recipe.getClass())) continue;
            RecipeDisplayAdapter<?> adapter = recipeToDisplayAdapterMap.get(recipe.getClass());
            List<GuidebookSlot> recipeSlots = adapter.getSlots(recipe, recipeAmount, xOffset, yOffset);
            this.map.put(recipe, recipeSlots);
            this.slots.addAll(recipeSlots);
            yOffset += 10;
            ++recipeAmount;
        }
    }

    @Override
    public void onTick() {
        ++ticks;
        for (GuidebookSlot slot : this.slots) {
            if (ticks <= 20L) continue;
            slot.showRandomItem();
            if (this.slots.get(this.slots.size() - 1) != slot) continue;
            ticks = 0L;
        }
    }

    @Override
    protected void renderForeground(TextureManager re, Font fr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.recipes.isEmpty()) {
            this.drawStringCenteredNoShadow(fr, "No recipes found :(", x + 79, y + 110, -8355712);
        }
        GuidebookSlot mouseOverSlot = null;
        for (GuidebookSlot slot : this.slots) {
            if (slot.item != null && !slot.isOutput) {
                slot.item.stackSize = 1;
            }
            this.drawSlot(x + slot.x - 1, y + slot.y - 1, -1);
            if (this.getIsMouseOverSlot(slot, x, y, mouseX, mouseY)) {
                mouseOverSlot = slot;
            }
            this.itemElement.render(slot.getItem(), x + slot.x, y + slot.y, mouseOverSlot == slot, slot);
        }
    }

    public boolean getIsMouseOverSlot(Slot slot, int x, int y, int mouseX, int mouseY) {
        return mouseX >= x + slot.x - 1 && mouseX < x + slot.x + 16 + 1 && mouseY >= y + slot.y - 1 && mouseY < y + slot.y + 16 + 1;
    }

    @Override
    public boolean keyTyped(char c, int key, int x, int y, int mouseX, int mouseY) {
        super.keyTyped(c, key, x, y, mouseX, mouseY);
        if (CraftingPage.mc.gameSettings.keyShowRecipe.isKeyboardKey(key)) {
            GuidebookSlot hoveringSlot = null;
            for (GuidebookSlot slot : this.slots) {
                if (!this.getIsMouseOverSlot(slot, x, y, mouseX, mouseY)) continue;
                hoveringSlot = slot;
            }
            if (hoveringSlot != null && hoveringSlot.hasItem()) {
                String query = "r:" + hoveringSlot.getItem().getDisplayName() + "!";
                PageManager.searchQuery = SearchQuery.resolve(query);
                SearchPage.searchField.setText(query);
                GuidebookScreen.getPageManager().updatePages();
                GuidebookScreen.getPageManager().setCurrentPage(GuidebookScreen.getPageManager().getSectionIndex(GuidebookSections.CRAFTING), true);
                return true;
            }
        } else if (CraftingPage.mc.gameSettings.keyShowUsage.isKeyboardKey(key)) {
            GuidebookSlot hoveringSlot = null;
            for (GuidebookSlot slot : this.slots) {
                if (!this.getIsMouseOverSlot(slot, x, y, mouseX, mouseY)) continue;
                hoveringSlot = slot;
            }
            if (hoveringSlot != null && hoveringSlot.hasItem()) {
                String query = "u:" + hoveringSlot.getItem().getDisplayName() + "!";
                PageManager.searchQuery = SearchQuery.resolve(query);
                SearchPage.searchField.setText(query);
                GuidebookScreen.getPageManager().updatePages();
                GuidebookScreen.getPageManager().setCurrentPage(GuidebookScreen.getPageManager().getSectionIndex(GuidebookSections.CRAFTING), true);
                return true;
            }
        }
        return false;
    }

    @Override
    public void render(TextureManager re, Font fr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        super.render(re, fr, x, y, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void renderBackground(TextureManager re, int x, int y) {
        super.renderBackground(re, x, y);
        re.bindTexture(re.loadTexture("/assets/minecraft/textures/gui/container/guidebook/guidebook.png"));
        for (int i = 1; i <= this.recipes.size(); ++i) {
            RecipeEntryCrafting recipe = (RecipeEntryCrafting)this.recipes.get(i - 1);
            List<GuidebookSlot> list = this.map.get(recipe);
            this.drawTexturedModalRect(x + list.get((int)(list.size() - 1)).x - 25, y + list.get((int)(list.size() - 1)).y, 234, 0, 22, 15);
        }
    }

    @Override
    protected void renderOverlay(TextureManager re, Font fr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        super.renderOverlay(re, fr, x, y, mouseX, mouseY, partialTicks);
        GuidebookSlot mouseOverSlot = null;
        for (GuidebookSlot slot : this.slots) {
            boolean showDescription;
            if (this.getIsMouseOverSlot(slot, x, y, mouseX, mouseY)) {
                mouseOverSlot = slot;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (mouseOverSlot == null || !mouseOverSlot.hasItem()) continue;
            boolean bl = showDescription = Keyboard.isKeyDown((int)Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown((int)Keyboard.KEY_RCONTROL) || (Boolean)CraftingPage.mc.gameSettings.alwaysShowDescriptions.value != false;
            String str = this.tooltipElement.getTooltipText(mouseOverSlot.getItem(), showDescription, mouseOverSlot);
            if (str.isEmpty()) continue;
            this.tooltipElement.render(str, mouseX, mouseY, 8, -8);
        }
    }

    public static boolean guidebookSupportsRecipe(RecipeEntryBase<?, ?, ?> recipe) {
        return recipeToDisplayAdapterMap.containsKey(recipe.getClass());
    }

    static {
        recipeToDisplayAdapterMap.put(RecipeEntryCraftingShaped.class, new ShapedDisplayAdapter());
        recipeToDisplayAdapterMap.put(RecipeEntryCraftingShapeless.class, new ShapelessDisplayAdapter());
        recipeToDisplayAdapterMap.put(RecipeEntryCraftingWithTool.class, new ToolDisplayAdapter());
        recipeToDisplayAdapterMap.put(RecipeEntryRepairable.class, new RepairableDisplayAdapter());
        recipeToDisplayAdapterMap.put(RecipeEntryScrap.class, new ScrapDisplayAdapter());
        recipeToDisplayAdapterMap.put(RecipeEntryLabel.class, new LabelDisplayAdapter());
        recipeToDisplayAdapterMap.put(RecipeEntryLabelDye.class, new LabelDyeDisplayAdapter());
        recipeToDisplayAdapterMap.put(RecipeEntryMapDuplication.class, new MapDuplicationDisplayAdapter());
        recipeToDisplayAdapterMap.put(RecipeEntryUndyeing.class, new UndyeDisplayAdapter());
        mc = Minecraft.getMinecraft(GuidebookPage.class);
        ticks = 0L;
    }
}

