/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories.entries.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.modelviewer.ModelViewerScreen;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntry;
import net.minecraft.client.gui.modelviewer.elements.ListenerSliderElement;
import net.minecraft.client.gui.modelviewer.elements.TextCycleElement;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.ItemEntity;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class EntityItemEntry
extends EntityEntry<ItemEntity> {
    @Override
    public void onTick(ItemEntity itemEntity) {
        ++itemEntity.age;
    }

    @Override
    public List<ButtonElement> getEntryButtons(Minecraft mc, Screen parentScreen, final ItemEntity itemEntity) {
        ArrayList<ButtonElement> buttonList = new ArrayList<ButtonElement>();
        itemEntity.item = Blocks.STONE.getDefaultStack();
        TextCycleElement<Integer> itemIdCycle = new TextCycleElement<Integer>(parentScreen, mc.font, -120, 0, 120, 20, Integer.valueOf(1)){

            @Override
            public Integer cycleElement(Integer current, int offset) {
                return ModelViewerScreen.cycleItemId(current, offset);
            }

            @Override
            public Integer getElementFromString(String s) {
                try {
                    int id = Integer.parseInt(s);
                    return MathHelper.clamp(id, 0, Item.itemsList.length);
                }
                catch (Exception exception) {
                    return itemEntity.item.itemID;
                }
            }

            @Override
            public String getNameFromElement(Integer element) {
                return String.valueOf(element);
            }
        };
        itemIdCycle.textField.setPrefaceText("ID: ");
        itemIdCycle.textField.setPlaceholder("Item ID");
        TextCycleElement<Integer> metaCycle = new TextCycleElement<Integer>(parentScreen, mc.font, -120, itemIdCycle.yPosition + 21, 120, 20, Integer.valueOf(0)){

            @Override
            public Integer cycleElement(Integer current, int offset) {
                return current + offset & 0x3FFF;
            }

            @Override
            public Integer getElementFromString(String s) {
                try {
                    int id = Integer.parseInt(s);
                    return MathHelper.clamp(id, 0, 16383);
                }
                catch (Exception exception) {
                    return itemEntity.item.getMetadata();
                }
            }

            @Override
            public String getNameFromElement(Integer element) {
                return String.valueOf(element);
            }
        };
        metaCycle.textField.setPrefaceText("Meta: ");
        metaCycle.textField.setPlaceholder("Meta");
        ListenerSliderElement sizeSlider = new ListenerSliderElement(-1, -120, metaCycle.yPosition + 21, 120, 20, I18n.getInstance().translateKeyAndFormat("model.category.entity.item.slider.size", 1), 0.015625f);
        itemIdCycle.setOnValueChanged(() -> {
            itemEntity.item = new ItemStack((Integer)itemIdCycle.getCurrentElement(), (int)(sizeSlider.sliderValue * 64.0f), (int)((Integer)metaCycle.getCurrentElement()));
        });
        metaCycle.setOnValueChanged(() -> {
            itemEntity.item = new ItemStack((Integer)itemIdCycle.getCurrentElement(), (int)(sizeSlider.sliderValue * 64.0f), (int)((Integer)metaCycle.getCurrentElement()));
        });
        sizeSlider.setOnValueChanged(() -> {
            itemEntity.item.stackSize = (int)(sizeSlider.sliderValue * 64.0f);
            sizeSlider.displayString = I18n.getInstance().translateKeyAndFormat("model.category.entity.item.slider.size", itemEntity.item.stackSize);
        });
        buttonList.add(itemIdCycle);
        buttonList.add(metaCycle);
        buttonList.add(sizeSlider);
        return buttonList;
    }

    @Override
    public ItemEntity getEntityInstance(Minecraft mc, World world) {
        return new ItemEntity(world);
    }

    @Override
    public void onOpen() {
    }

    @Override
    public void onClose() {
    }
}

