/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.net.handler;

import com.b100.utils.StringUtils;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.particle.TakeAnimationParticle;
import net.minecraft.client.entity.player.LocalPlayer;
import net.minecraft.client.entity.player.RemotePlayer;
import net.minecraft.client.gui.ConnectFailedScreen;
import net.minecraft.client.gui.DownloadTerrainScreen;
import net.minecraft.client.gui.PauseScreen;
import net.minecraft.client.gui.chat.ChatSuggestionsElement;
import net.minecraft.client.gui.guidebook.GuidebookScreen;
import net.minecraft.client.gui.guidebook.PageManager;
import net.minecraft.client.gui.guidebook.search.SearchPage;
import net.minecraft.client.player.controller.PlayerControllerMP;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.block.entity.BlastFurnaceBlockEntity;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.entity.DispenserBlockEntity;
import net.minecraft.core.block.entity.FlagBlockEntity;
import net.minecraft.core.block.entity.FurnaceBlockEntity;
import net.minecraft.core.block.entity.MobSpawnerBlockEntity;
import net.minecraft.core.block.entity.TrommelBlockEntity;
import net.minecraft.core.data.DataLoader;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.RecipeRegistry;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.ItemEntity;
import net.minecraft.core.entity.LightningEntity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.PaintingEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.projectile.Projectile;
import net.minecraft.core.enums.ArtType;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.item.MapItem;
import net.minecraft.core.net.NetworkManager;
import net.minecraft.core.net.PlayerProfile;
import net.minecraft.core.net.entity.NetEntityHandler;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.AESSendKeyPacket;
import net.minecraft.core.net.packet.AddEntityPacket;
import net.minecraft.core.net.packet.AddItemEntityPacket;
import net.minecraft.core.net.packet.AddMobPacket;
import net.minecraft.core.net.packet.AddPaintingPacket;
import net.minecraft.core.net.packet.AddParticlePacket;
import net.minecraft.core.net.packet.AddPlayerPacket;
import net.minecraft.core.net.packet.AnimatePacket;
import net.minecraft.core.net.packet.BedMessagePacket;
import net.minecraft.core.net.packet.BlockEntityDataPacket;
import net.minecraft.core.net.packet.BlockEventPacket;
import net.minecraft.core.net.packet.BlockRegionUpdatePacket;
import net.minecraft.core.net.packet.BlockUpdatePacket;
import net.minecraft.core.net.packet.ChatPacket;
import net.minecraft.core.net.packet.ChunkBlocksUpdatePacket;
import net.minecraft.core.net.packet.ChunkVisibilityPacket;
import net.minecraft.core.net.packet.CommandManagerPacket;
import net.minecraft.core.net.packet.ContainerAckPacket;
import net.minecraft.core.net.packet.ContainerClosePacket;
import net.minecraft.core.net.packet.ContainerOpenPacket;
import net.minecraft.core.net.packet.ContainerSetContentPacket;
import net.minecraft.core.net.packet.ContainerSetDataPacket;
import net.minecraft.core.net.packet.ContainerSetSlotPacket;
import net.minecraft.core.net.packet.CustomPayloadPacket;
import net.minecraft.core.net.packet.DisconnectPacket;
import net.minecraft.core.net.packet.EnitityEventPacket;
import net.minecraft.core.net.packet.EntityNicknamePacket;
import net.minecraft.core.net.packet.EntityTagDataPacket;
import net.minecraft.core.net.packet.ExplosionPacket;
import net.minecraft.core.net.packet.FlagOpenPacket;
import net.minecraft.core.net.packet.GameRulePacket;
import net.minecraft.core.net.packet.LoginPacket;
import net.minecraft.core.net.packet.MapDataPacket;
import net.minecraft.core.net.packet.MoveEntityPacket;
import net.minecraft.core.net.packet.MovePlayerPacket;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PhotoModePacket;
import net.minecraft.core.net.packet.PlaySoundEffectDirectPacket;
import net.minecraft.core.net.packet.PlaySoundEffectPacket;
import net.minecraft.core.net.packet.PlayerGamemodePacket;
import net.minecraft.core.net.packet.PlayerListPacket;
import net.minecraft.core.net.packet.PreLoginPacket;
import net.minecraft.core.net.packet.RecipeSyncPacket;
import net.minecraft.core.net.packet.RemoveEntityPacket;
import net.minecraft.core.net.packet.RespawnPacket;
import net.minecraft.core.net.packet.SetCarriedItemPacket;
import net.minecraft.core.net.packet.SetEntityDataPacket;
import net.minecraft.core.net.packet.SetEntityMotionPacket;
import net.minecraft.core.net.packet.SetEquippedItemPacket;
import net.minecraft.core.net.packet.SetHealthPacket;
import net.minecraft.core.net.packet.SetHeldObjectPacket;
import net.minecraft.core.net.packet.SetHotbarOffsetPacket;
import net.minecraft.core.net.packet.SetMobSpawnerPacket;
import net.minecraft.core.net.packet.SetRidingPacket;
import net.minecraft.core.net.packet.SetSpawnPositionPacket;
import net.minecraft.core.net.packet.SetTimePacket;
import net.minecraft.core.net.packet.SleepPacket;
import net.minecraft.core.net.packet.StatisticPacket;
import net.minecraft.core.net.packet.SyncIDsPacket;
import net.minecraft.core.net.packet.TakeItemEntityPacket;
import net.minecraft.core.net.packet.TeleportEntityPacket;
import net.minecraft.core.net.packet.UpdatePlayerProfilePacket;
import net.minecraft.core.net.packet.WeatherEffectPacket;
import net.minecraft.core.net.packet.WeatherStatusPacket;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.player.inventory.container.SimpleContainer;
import net.minecraft.core.player.inventory.menu.AbstractContainerMenu;
import net.minecraft.core.sound.SoundTypes;
import net.minecraft.core.util.helper.AES;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.RSA;
import net.minecraft.core.world.Explosion;
import net.minecraft.core.world.ExplosionCannonball;
import net.minecraft.core.world.ICarriable;
import net.minecraft.core.world.IVehicle;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.core.world.data.SynchedEntityData;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.saveddata.SavedDataStorage;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.weather.Weathers;
import org.slf4j.Logger;

public class ClientPacketHandler
extends PacketHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private boolean disconnected = false;
    private final NetworkManager netManager;
    public String message;
    private final Minecraft mc;
    private WorldClient worldClient;
    private boolean started = false;
    public SavedDataStorage savedDataStorage;
    public List<PlayerProfile> players;
    public HashMap<String, String> playerList = new HashMap();
    Random rand;

    public ClientPacketHandler(Minecraft minecraft, String host, int port) throws UnknownHostException, IOException {
        this.savedDataStorage = new SavedDataStorage(null);
        this.rand = new Random();
        this.mc = minecraft;
        Socket socket = new Socket(InetAddress.getByName(host), port);
        this.netManager = new NetworkManager(socket, "Client", this);
        this.players = new ArrayList<PlayerProfile>();
    }

    public void tick() {
        if (!this.disconnected) {
            this.netManager.processReadPackets();
        }
        this.netManager.wakeThreads();
    }

    public int findPlayerInList(PlayerProfile playerProfile) {
        for (int i = 0; i < this.players.size(); ++i) {
            if (!this.players.get((int)i).playerName.equals(playerProfile.playerName)) continue;
            return i;
        }
        return -1;
    }

    public void addPlayer(PlayerProfile playerProfile) {
        this.players.add(playerProfile);
    }

    public PlayerProfile getPlayer(String username) {
        for (PlayerProfile player : this.players) {
            if (!player.playerName.equals(username)) continue;
            return player;
        }
        return null;
    }

    public void removePlayer(int index) {
        this.players.remove(index);
    }

    @Override
    public void handleLogin(LoginPacket loginPacket) {
        this.mc.playerController = new PlayerControllerMP(this.mc, this);
        this.mc.statsCounter.add(StatList.joinMultiplayerStat, 1);
        this.worldClient = new WorldClient(this.mc, this, loginPacket.worldSeed, loginPacket.dimensionId, loginPacket.worldTypeId);
        this.worldClient.isClientSide = true;
        this.mc.changeWorld(this.worldClient);
        this.mc.thePlayer.dimension = loginPacket.dimensionId;
        this.mc.displayScreen(new DownloadTerrainScreen(this));
        this.mc.thePlayer.id = loginPacket.playerEntityIdAndProtocolVersion;
        NetworkManager.PACKET_DELAY = loginPacket.packetDelay;
        Registries.RECIPES = new RecipeRegistry();
    }

    @Override
    public void handlePickupSpawn(AddItemEntityPacket itemEntityPacket) {
        double x = (double)itemEntityPacket.xPosition / 32.0;
        double y = (double)itemEntityPacket.yPosition / 32.0;
        double z = (double)itemEntityPacket.zPosition / 32.0;
        ItemEntity itemEntity = new ItemEntity(this.worldClient, x, y, z, new ItemStack(itemEntityPacket.itemID, itemEntityPacket.count, itemEntityPacket.itemDamage, itemEntityPacket.tag));
        itemEntity.xd = (double)itemEntityPacket.xd / 128.0;
        itemEntity.yd = (double)itemEntityPacket.yd / 128.0;
        itemEntity.zd = (double)itemEntityPacket.zd / 128.0;
        itemEntity.serverPosX = itemEntityPacket.xPosition;
        itemEntity.serverPosY = itemEntityPacket.yPosition;
        itemEntity.serverPosZ = itemEntityPacket.zPosition;
        this.worldClient.addEntityToWorld(itemEntityPacket.entityId, itemEntity);
    }

    @Override
    public void handleVehicleSpawn(AddEntityPacket packet23) {
        if (!NetEntityHandler.hasType(packet23.type)) {
            return;
        }
        double xPosition = (double)packet23.xPosition / 32.0;
        double yPosition = (double)packet23.yPosition / 32.0;
        double zPosition = (double)packet23.zPosition / 32.0;
        Entity owner = packet23.ownerId >= 0 ? this.getEntityByID(packet23.ownerId) : null;
        Entity newEntity = NetEntityHandler.getTypeEntry(packet23.type).getEntity(this.worldClient, xPosition, yPosition, zPosition, packet23.metaData, packet23.hasVelocity, (double)packet23.xVelocity / 8000.0, (double)packet23.yVelocity / 8000.0, (double)packet23.zVelocity / 8000.0, owner);
        if (newEntity != null) {
            newEntity.serverPosX = packet23.xPosition;
            newEntity.serverPosY = packet23.yPosition;
            newEntity.serverPosZ = packet23.zPosition;
            newEntity.yRot = packet23.yaw;
            newEntity.xRot = packet23.pitch;
            newEntity.id = packet23.entityId;
            this.worldClient.addEntityToWorld(packet23.entityId, newEntity);
            if (owner instanceof Mob && newEntity instanceof Projectile) {
                ((Projectile)newEntity).owner = (Mob)owner;
            }
            if (packet23.hasVelocity) {
                newEntity.lerpMotion((double)packet23.xVelocity / 8000.0, (double)packet23.yVelocity / 8000.0, (double)packet23.zVelocity / 8000.0);
            }
        }
    }

    @Override
    public void handleWeather(WeatherEffectPacket weatherEffectPacket) {
        double x = (double)weatherEffectPacket.x / 32.0;
        double y = (double)weatherEffectPacket.y / 32.0;
        double z = (double)weatherEffectPacket.z / 32.0;
        LightningEntity weatherEntity = null;
        if (weatherEffectPacket.effectId == 1) {
            weatherEntity = new LightningEntity(this.worldClient, x, y, z);
        }
        if (weatherEntity != null) {
            weatherEntity.serverPosX = weatherEffectPacket.x;
            weatherEntity.serverPosY = weatherEffectPacket.y;
            weatherEntity.serverPosZ = weatherEffectPacket.z;
            weatherEntity.yRot = 0.0f;
            weatherEntity.xRot = 0.0f;
            weatherEntity.id = weatherEffectPacket.id;
            this.worldClient.addWeatherEffect(weatherEntity);
        }
    }

    @Override
    public void handleWeatherStatus(WeatherStatusPacket packet) {
        if (this.worldClient.dimension.id != packet.dimId) {
            return;
        }
        Weather currentWeather = packet.id == -1 ? null : Weathers.WEATHERS[packet.id];
        Weather newWeather = packet.newId == -1 ? null : Weathers.WEATHERS[packet.newId];
        this.worldClient.weatherManager.overrideWeather(currentWeather, newWeather, packet.duration, packet.intensity, packet.power);
    }

    @Override
    public void handleEntityPainting(AddPaintingPacket packet) {
        Entity entity = this.worldClient.getEntityFromId(packet.entityId);
        if (entity instanceof PaintingEntity) {
            PaintingEntity painting = (PaintingEntity)entity;
            painting.blockX = packet.xPosition;
            painting.blockY = packet.yPosition;
            painting.blockZ = packet.zPosition;
            if (ArtType.map.containsKey(packet.key)) {
                painting.art = ArtType.map.get(packet.key);
            }
            painting.setDirection(packet.direction);
            if (packet.itemID > 0) {
                painting.setStack(new ItemStack(packet.itemID, 1, packet.meta));
            }
        } else {
            PaintingEntity entitypainting = new PaintingEntity(this.worldClient, packet.xPosition, packet.yPosition, packet.zPosition, packet.direction, packet.key);
            this.worldClient.addEntityToWorld(packet.entityId, entitypainting);
            if (packet.itemID > 0) {
                entitypainting.setStack(new ItemStack(packet.itemID, 1, packet.meta));
            }
        }
    }

    @Override
    public void handleEntityVelocity(SetEntityMotionPacket setEntityvelocity) {
        Entity entity = this.getEntityByID(setEntityvelocity.entityId);
        if (entity == null) {
            return;
        }
        entity.lerpMotion((double)setEntityvelocity.motionX / 8000.0, (double)setEntityvelocity.motionY / 8000.0, (double)setEntityvelocity.motionZ / 8000.0);
    }

    @Override
    public void handleEntityMetadata(SetEntityDataPacket entityDataPacket) {
        Entity entity = this.getEntityByID(entityDataPacket.entityId);
        if (entity != null && entityDataPacket.getUnpackedData() != null) {
            entity.getEntityData().assignValues(entityDataPacket.getUnpackedData());
        }
    }

    @Override
    public void handleNamedEntitySpawn(AddPlayerPacket playerPacket) {
        double d = (double)playerPacket.xPosition / 32.0;
        double d1 = (double)playerPacket.yPosition / 32.0;
        double d2 = (double)playerPacket.zPosition / 32.0;
        float f = (float)(playerPacket.rotation * 360) / 256.0f;
        float f1 = (float)(playerPacket.pitch * 360) / 256.0f;
        RemotePlayer remotePlayer = new RemotePlayer(this.mc.theWorld, playerPacket.name, playerPacket.uuid);
        remotePlayer.serverPosX = playerPacket.xPosition;
        remotePlayer.xo = remotePlayer.serverPosX;
        remotePlayer.serverPosY = playerPacket.yPosition;
        remotePlayer.yo = remotePlayer.serverPosY;
        remotePlayer.serverPosZ = playerPacket.zPosition;
        remotePlayer.zo = remotePlayer.serverPosZ;
        int i = playerPacket.currentItem;
        remotePlayer.inventory.mainInventory[remotePlayer.inventory.getCurrentItemIndex()] = i == 0 ? null : new ItemStack(i, 1, 0);
        remotePlayer.absMoveTo(d, d1, d2, f, f1);
        this.worldClient.addEntityToWorld(playerPacket.entityId, remotePlayer);
        remotePlayer.nickname = StringUtils.substring(playerPacket.nickname, 0, 32);
        remotePlayer.chatColor = playerPacket.chatColor;
        remotePlayer.setHeldObject(playerPacket.heldObjectTag == null ? null : ICarriable.createAndLoadCarriable(remotePlayer, playerPacket.heldObjectTag));
    }

    @Override
    public void handleEntityTeleport(TeleportEntityPacket packet34EntityteleportEntityPacket) {
        Entity entity = this.getEntityByID(packet34EntityteleportEntityPacket.id);
        if (entity == null) {
            return;
        }
        entity.serverPosX = packet34EntityteleportEntityPacket.x;
        entity.serverPosY = packet34EntityteleportEntityPacket.y;
        entity.serverPosZ = packet34EntityteleportEntityPacket.z;
        double d = (double)entity.serverPosX / 32.0;
        double d1 = (double)entity.serverPosY / 32.0 + 0.015625;
        double d2 = (double)entity.serverPosZ / 32.0;
        float f = (float)(packet34EntityteleportEntityPacket.yaw * 360) / 256.0f;
        float f1 = (float)(packet34EntityteleportEntityPacket.pitch * 360) / 256.0f;
        entity.lerpTo(d, d1, d2, f, f1, 3);
    }

    @Override
    public void handleEntity(MoveEntityPacket moveEntityPacket) {
        Entity entity = this.getEntityByID(moveEntityPacket.id);
        if (entity == null) {
            return;
        }
        entity.serverPosX += moveEntityPacket.x;
        entity.serverPosY += moveEntityPacket.y;
        entity.serverPosZ += moveEntityPacket.z;
        double d = (double)entity.serverPosX / 32.0;
        double d1 = (double)entity.serverPosY / 32.0;
        double d2 = (double)entity.serverPosZ / 32.0;
        float f = moveEntityPacket.rotating ? (float)(moveEntityPacket.yaw * 360) / 256.0f : entity.yRot;
        float f1 = moveEntityPacket.rotating ? (float)(moveEntityPacket.pitch * 360) / 256.0f : entity.xRot;
        entity.lerpTo(d, d1, d2, f, f1, 3);
    }

    @Override
    public void handleEntityTagData(EntityTagDataPacket packet) {
        Entity entity = this.getEntityByID(packet.entityId);
        if (entity != null) {
            entity.readAdditionalSaveData(packet.tag);
        }
    }

    @Override
    public void handleSetMobSpawner(SetMobSpawnerPacket setMobSpawnerPacket) {
        BlockEntity tileentity;
        if (this.mc.theWorld.isBlockLoaded(setMobSpawnerPacket.xPosition, setMobSpawnerPacket.yPosition, setMobSpawnerPacket.zPosition) && (tileentity = this.mc.theWorld.getBlockEntity(setMobSpawnerPacket.xPosition, setMobSpawnerPacket.yPosition, setMobSpawnerPacket.zPosition)) instanceof MobSpawnerBlockEntity) {
            MobSpawnerBlockEntity tileEntityMobSpawner = (MobSpawnerBlockEntity)tileentity;
            tileEntityMobSpawner.setMobId(setMobSpawnerPacket.spawnType);
            tileEntityMobSpawner.setChanged();
        }
    }

    @Override
    public void handleSetHotbarOffset(SetHotbarOffsetPacket setHotbarOffsetPacket) {
        this.mc.thePlayer.inventory.setHotbarOffset(setHotbarOffsetPacket.hotbarOffset, true);
    }

    @Override
    public void handleDestroyEntity(RemoveEntityPacket packet29DestroyentityPacket) {
        this.worldClient.removeEntityFromWorld(packet29DestroyentityPacket.entityId);
    }

    @Override
    public void handleFlying(MovePlayerPacket movePlayerPacket) {
        LocalPlayer entityplayersp = this.mc.thePlayer;
        double d = entityplayersp.x;
        double d1 = entityplayersp.y;
        double d2 = entityplayersp.z;
        float f = entityplayersp.yRot;
        float f1 = entityplayersp.xRot;
        if (movePlayerPacket.hasPosition) {
            d = movePlayerPacket.x;
            d1 = movePlayerPacket.y;
            d2 = movePlayerPacket.z;
        }
        if (movePlayerPacket.hasRotation) {
            f = movePlayerPacket.yaw;
            f1 = movePlayerPacket.pitch;
        }
        entityplayersp.ySlideOffset = 0.0f;
        entityplayersp.zd = 0.0;
        entityplayersp.yd = 0.0;
        entityplayersp.xd = 0.0;
        entityplayersp.absMoveTo(d, d1, d2, f, f1);
        movePlayerPacket.x = entityplayersp.x;
        movePlayerPacket.y = entityplayersp.bb.minY;
        movePlayerPacket.z = entityplayersp.z;
        movePlayerPacket.yView = entityplayersp.y;
        this.netManager.addToSendQueue(movePlayerPacket);
        if (!this.started) {
            this.mc.thePlayer.xo = this.mc.thePlayer.x;
            this.mc.thePlayer.yo = this.mc.thePlayer.y;
            this.mc.thePlayer.zo = this.mc.thePlayer.z;
            this.started = true;
            this.mc.displayScreen(null);
        }
    }

    @Override
    public void handlePreChunk(ChunkVisibilityPacket packet50PrechunkVisibilityPacket) {
        this.worldClient.doPreChunk(packet50PrechunkVisibilityPacket.xPosition, packet50PrechunkVisibilityPacket.yPosition, packet50PrechunkVisibilityPacket.mode);
    }

    @Override
    public void handleMultiBlockChange(ChunkBlocksUpdatePacket packet) {
        int xBase = packet.xChunk * 16;
        int zBase = packet.zChunk * 16;
        for (int k = 0; k < packet.size; ++k) {
            int coord = packet.coordinateArray[k];
            int type = packet.typeArray[k] & 0x3FFF;
            byte data = packet.metadataArray[k];
            int x = coord >> 0 & 0xF;
            int y = coord >> 8 & 0xFF;
            int z = coord >> 4 & 0xF;
            this.worldClient.setBlockAndMetadataWithNotify(x + xBase, y, z + zBase, type, data);
            this.worldClient.func_711_c(x + xBase, y, z + zBase, x + xBase, y, z + zBase);
            this.worldClient.markBlocksDirty(x + xBase, y, z + zBase, x + xBase, y, z + zBase);
        }
    }

    @Override
    public void handleMapChunk(BlockRegionUpdatePacket packet) {
        this.worldClient.func_711_c(packet.xPosition, packet.yPosition, packet.zPosition, packet.xPosition + packet.xSize - 1, packet.yPosition + packet.ySize - 1, packet.zPosition + packet.zSize - 1);
        this.worldClient.setChunkData(packet.xPosition, packet.yPosition, packet.zPosition, packet.xSize, packet.ySize, packet.zSize, packet.chunk);
    }

    @Override
    public void handleBlockChange(BlockUpdatePacket blockchange) {
        this.worldClient.blockChange(blockchange.xPosition, blockchange.yPosition, blockchange.zPosition, blockchange.type, blockchange.metadata);
    }

    @Override
    public void handleKickDisconnect(DisconnectPacket packet255KickdisconnectPacket) {
        this.netManager.networkShutdown("disconnect.kicked", new Object[0]);
        this.disconnected = true;
        this.mc.changeWorld(null);
        this.mc.displayScreen(new ConnectFailedScreen("disconnect.disconnected", "disconnect.genericReason", new Object[]{packet255KickdisconnectPacket.reason}));
    }

    @Override
    public void handleErrorMessage(String s, Object[] errorLines) {
        if (!this.disconnected) {
            this.disconnected = true;
            try {
                this.mc.changeWorld(null);
            }
            catch (Exception e) {
                LOGGER.error("Exception when leaving world!", e);
            }
            try {
                this.mc.displayScreen(null);
            }
            catch (Exception e) {
                LOGGER.error("Exception when leaving GUI!", e);
            }
            this.mc.displayScreen(new ConnectFailedScreen("disconnect.lost", s, errorLines));
        }
    }

    public void func_28117_a(Packet packet) {
        if (!this.disconnected) {
            this.netManager.addToSendQueue(packet);
            this.netManager.serverShutdown();
        }
    }

    public void addToSendQueue(Packet packet) {
        if (!this.disconnected) {
            this.netManager.addToSendQueue(packet);
        }
    }

    @Override
    public void handleCollect(TakeItemEntityPacket takeItemEntityPacket) {
        Entity item = this.getEntityByID(takeItemEntityPacket.collectedEntityId);
        Entity collector = this.getEntityByID(takeItemEntityPacket.collectorEntityId);
        if (collector == null) {
            collector = this.mc.thePlayer;
        }
        if (item != null) {
            this.worldClient.playSoundAtEntity(null, item, "random.pop", 0.2f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            this.mc.particleEngine.add(new TakeAnimationParticle(this.mc.theWorld, item, collector, -0.5f));
            this.worldClient.removeEntityFromWorld(takeItemEntityPacket.collectedEntityId);
        }
    }

    @Override
    public void handleChat(ChatPacket packet) {
        String message;
        if (packet.encrypted) {
            try {
                message = AES.decrypt(packet.message, AES.clientKeyChain);
            }
            catch (Exception e) {
                throw new RuntimeException("This crash is caused by outdated Java, please update to 8u161 or newer! If your Java version is out of date due to a technical requirement, please add the JCE Unlimited Strength Jurisdiction Policy Files to your installation. https://www.oracle.com/java/technologies/javase-jce-all-downloads.html", e);
            }
        } else {
            message = packet.message;
        }
        int type = packet.type;
        if (type == 1) {
            this.mc.ingameHud.heldItemTooltipElement.setString(message);
        } else {
            this.mc.ingameHud.addChatMessage(message);
        }
    }

    public void handlePlayerJoin(ChatPacket chatPacket) {
        this.mc.ingameHud.addChatMessage(chatPacket.message);
    }

    public void handlePlayerLeave(ChatPacket chatPacket) {
        this.mc.ingameHud.addChatMessage(chatPacket.message);
    }

    @Override
    public void handleAnimation(AnimatePacket animatePacket) {
        Entity entity = this.getEntityByID(animatePacket.entityId);
        if (entity == null) {
            return;
        }
        if (animatePacket.animate == 1) {
            Player entityplayer = (Player)entity;
            entityplayer.swingItem();
        } else if (animatePacket.animate == 2) {
            entity.animateHurt();
        } else if (animatePacket.animate == 3) {
            Player player = (Player)entity;
            player.wakeUpPlayer(false, false);
        } else if (animatePacket.animate == 4) {
            Player player = (Player)entity;
            player.animate4();
        }
    }

    @Override
    public void handleSleep(SleepPacket sleepPacket) {
        Entity entity = this.getEntityByID(sleepPacket.entityID);
        if (entity == null) {
            return;
        }
        if (sleepPacket.field_22046_e == 0) {
            Player entityplayer = (Player)entity;
            entityplayer.sleepInBedAt(sleepPacket.x, sleepPacket.y, sleepPacket.z);
        }
    }

    @Override
    public void handleHandshake(PreLoginPacket preLoginPacket) {
        block8: {
            if (preLoginPacket.username.equals("-")) {
                try {
                    RSA.RSAKeyChain = RSA.generateKeyPair();
                    this.addToSendQueue(new LoginPacket(this.mc.session.username, this.mc.session.uuid, 29184, RSA.getPublicKey(RSA.RSAKeyChain.getPublic())));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                URL url = new URL("http://session.minecraft.net/game/joinserver.jsp?user=" + this.mc.session.username + "&sessionId=" + this.mc.session.sessionId + "&serverId=" + preLoginPacket.username);
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(url.openStream()));
                String s = bufferedreader.readLine();
                bufferedreader.close();
                if (s.equalsIgnoreCase("ok")) {
                    try {
                        RSA.RSAKeyChain = RSA.generateKeyPair();
                        this.addToSendQueue(new LoginPacket(this.mc.session.username, this.mc.session.uuid, 29184, RSA.getPublicKey(RSA.RSAKeyChain.getPublic())));
                        break block8;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Exception while creating LoginPacket!", e);
                    }
                }
                this.netManager.networkShutdown("disconnect.loginFailedInfo", new Object[]{s});
            }
            catch (Exception exception) {
                LOGGER.error("Login Exception!", exception);
                this.netManager.networkShutdown("disconnect.genericReason", new Object[]{"Internal client error: " + exception});
            }
        }
    }

    @Override
    public void handleSendKey(AESSendKeyPacket AESSendKeyPacket2) {
        try {
            AES.clientKeyChain = AES.getKey(RSA.decrypt(AESSendKeyPacket2.KEY, RSA.RSAKeyChain.getPrivate()));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get AES key!", e);
        }
    }

    @Override
    public void handlePlayerList(PlayerListPacket playerListPacket) {
        this.playerList.clear();
        String[] players = playerListPacket.players;
        String[] scores = playerListPacket.scores;
        for (int i = 0; i < players.length; ++i) {
            this.playerList.put(players[i], scores[i]);
        }
    }

    public void disconnect() {
        this.disconnected = true;
        this.netManager.wakeThreads();
        this.netManager.networkShutdown("disconnect.closed", new Object[0]);
    }

    @Override
    public void handleMobSpawn(AddMobPacket addMobspawn) {
        double d = (double)addMobspawn.x / 32.0;
        double d1 = (double)addMobspawn.y / 32.0;
        double d2 = (double)addMobspawn.z / 32.0;
        float f = (float)(addMobspawn.yaw * 360) / 256.0f;
        float f1 = (float)(addMobspawn.pitch * 360) / 256.0f;
        Mob mob = (Mob)EntityDispatcher.createEntity(addMobspawn.type, this.mc.theWorld);
        mob.serverPosX = addMobspawn.x;
        mob.serverPosY = addMobspawn.y;
        mob.serverPosZ = addMobspawn.z;
        mob.id = addMobspawn.id;
        mob.absMoveTo(d, d1, d2, f, f1);
        mob.isMultiplayerEntity = true;
        this.worldClient.addEntityToWorld(addMobspawn.id, mob);
        List<SynchedEntityData.DataItem<?>> list = addMobspawn.getUnpackedData();
        if (list != null) {
            mob.getEntityData().assignValues(list);
        }
        mob.nickname = StringUtils.substring(addMobspawn.nickname, 0, 32);
        mob.chatColor = addMobspawn.chatColor;
    }

    @Override
    public void handleUpdateTime(SetTimePacket timePacket) {
        this.mc.theWorld.setWorldTime(timePacket.time);
    }

    @Override
    public void handleSpawnPosition(SetSpawnPositionPacket setSpawnpositionPacket) {
        this.mc.thePlayer.setPlayerSpawnCoordinate(new ChunkCoordinates(setSpawnpositionPacket.x, setSpawnpositionPacket.y, setSpawnpositionPacket.z));
        this.mc.theWorld.getLevelData().setSpawn(setSpawnpositionPacket.x, setSpawnpositionPacket.y, setSpawnpositionPacket.z);
    }

    @Override
    public void handleAttachEntity(SetRidingPacket packet) {
        Entity passenger = this.getEntityByID(packet.passengerId);
        if (packet.passengerId == this.mc.thePlayer.id) {
            passenger = this.mc.thePlayer;
        }
        IVehicle vehicle = packet.isTileEntity ? (IVehicle)((Object)this.worldClient.getBlockEntity(packet.x, packet.y, packet.z)) : this.getEntityByID(packet.vehicleId);
        if (passenger != null && vehicle != null) {
            passenger.startRiding(vehicle);
        }
    }

    @Override
    public void handleEntityStatus(EnitityEventPacket enitityEventPacket38Entitystatus) {
        Entity entity = this.getEntityByID(enitityEventPacket38Entitystatus.entityId);
        if (entity != null) {
            entity.handleEntityEvent(enitityEventPacket38Entitystatus.entityStatus, enitityEventPacket38Entitystatus.attackedAtYaw);
        }
    }

    protected Entity getEntityByID(int i) {
        if (i == this.mc.thePlayer.id) {
            return this.mc.thePlayer;
        }
        return this.worldClient.getEntityFromId(i);
    }

    @Override
    public void handleUpdateHealth(SetHealthPacket healthPacket) {
        this.mc.thePlayer.setHealth(healthPacket.healthMP);
    }

    @Override
    public void handleUpdatePlayerProfile(UpdatePlayerProfilePacket profilePacket) {
        int index;
        PlayerProfile playerProfile = new PlayerProfile(profilePacket.username, profilePacket.nickname, profilePacket.uuid, profilePacket.score, profilePacket.chatColor, profilePacket.isOperator);
        if (playerProfile.uuid.equals(this.mc.thePlayer.uuid)) {
            this.mc.thePlayer.score = playerProfile.scoreTotal;
        }
        if ((index = this.findPlayerInList(playerProfile)) != -1) {
            if (!profilePacket.isOnline) {
                this.removePlayer(index);
            } else {
                this.players.set(index, playerProfile);
            }
        } else {
            this.addPlayer(playerProfile);
        }
    }

    @Override
    public void handleRespawn(RespawnPacket respawnPacket) {
        if (respawnPacket.respawnDimensionId != this.mc.thePlayer.dimension) {
            this.started = false;
            this.worldClient = new WorldClient(this.mc, this, this.worldClient.getLevelData().getRandomSeed(), respawnPacket.respawnDimensionId, respawnPacket.respawnWorldTypeId);
            this.worldClient.isClientSide = true;
            this.mc.changeWorld(this.worldClient);
            this.mc.thePlayer.dimension = respawnPacket.respawnDimensionId;
            this.mc.displayScreen(new DownloadTerrainScreen(this));
        }
        this.mc.respawn(true, respawnPacket.respawnDimensionId);
    }

    @Override
    public void handleExplosion(ExplosionPacket explosionPacket) {
        Explosion explosion = explosionPacket.isCannonball ? new ExplosionCannonball(this.mc.theWorld, null, explosionPacket.explosionX, explosionPacket.explosionY, explosionPacket.explosionZ, explosionPacket.explosionSize) : new Explosion(this.mc.theWorld, null, explosionPacket.explosionX, explosionPacket.explosionY, explosionPacket.explosionZ, explosionPacket.explosionSize);
        explosion.destroyedBlockPositions = explosionPacket.destroyedBlockPositions;
        explosion.addEffects(true);
    }

    @Override
    public void handleOpenWindow(ContainerOpenPacket containerOpenPacket) {
        if (containerOpenPacket.inventoryType == 0) {
            SimpleContainer simpleContainer = new SimpleContainer(containerOpenPacket.windowTitle, containerOpenPacket.slotsCount);
            this.mc.thePlayer.displayContainerScreen(simpleContainer);
            this.mc.thePlayer.craftingInventory.containerId = containerOpenPacket.windowId;
        } else if (containerOpenPacket.inventoryType == 2) {
            FurnaceBlockEntity furnaceBlockEntity = new FurnaceBlockEntity();
            this.mc.thePlayer.displayFurnaceScreen(furnaceBlockEntity);
            this.mc.thePlayer.craftingInventory.containerId = containerOpenPacket.windowId;
        } else if (containerOpenPacket.inventoryType == 3) {
            DispenserBlockEntity dispenserBlockEntity = new DispenserBlockEntity();
            this.mc.thePlayer.displayDispenserScreen(dispenserBlockEntity);
            this.mc.thePlayer.craftingInventory.containerId = containerOpenPacket.windowId;
        } else if (containerOpenPacket.inventoryType == 4) {
            BlastFurnaceBlockEntity blastFurnaceBlockEntity = new BlastFurnaceBlockEntity();
            this.mc.thePlayer.displayFurnaceScreen(blastFurnaceBlockEntity);
            this.mc.thePlayer.craftingInventory.containerId = containerOpenPacket.windowId;
        } else if (containerOpenPacket.inventoryType == 5) {
            TrommelBlockEntity trommelBlockEntity = new TrommelBlockEntity();
            this.mc.thePlayer.displayTrommelScreen(trommelBlockEntity);
            this.mc.thePlayer.craftingInventory.containerId = containerOpenPacket.windowId;
        } else if (containerOpenPacket.inventoryType == 7) {
            this.mc.thePlayer.displayPaintingPickerScreen();
        } else if (containerOpenPacket.inventoryType == 1) {
            LocalPlayer localPlayer = this.mc.thePlayer;
            this.mc.thePlayer.displayWorkbenchScreen(MathHelper.floor(localPlayer.x), MathHelper.floor(localPlayer.y), MathHelper.floor(localPlayer.z));
            this.mc.thePlayer.craftingInventory.containerId = containerOpenPacket.windowId;
        }
    }

    @Override
    public void handleOpenFlagWindow(FlagOpenPacket flagOpenPacket) {
        BlockEntity blockEntity = this.worldClient.getBlockEntity(flagOpenPacket.x, flagOpenPacket.y, flagOpenPacket.z);
        if (blockEntity instanceof FlagBlockEntity) {
            FlagBlockEntity tileEntityFlag = (FlagBlockEntity)blockEntity;
            this.mc.thePlayer.displayFlagEditorScreen(tileEntityFlag);
            this.mc.thePlayer.craftingInventory.containerId = flagOpenPacket.windowId;
        }
    }

    @Override
    public void handlePhotoMode(PhotoModePacket packet) {
        PauseScreen.photoModeDisabled = packet.disabled;
    }

    @Override
    public void handleSetSlot(ContainerSetSlotPacket containerSetslotPacket) {
        if (containerSetslotPacket.windowId == -1) {
            this.mc.thePlayer.inventory.setHeldItemStack(containerSetslotPacket.myItemStack);
        } else if (containerSetslotPacket.windowId == 0 && containerSetslotPacket.itemSlot >= 36 && containerSetslotPacket.itemSlot < 45) {
            ItemStack itemstack = this.mc.thePlayer.inventorySlots.getSlot(containerSetslotPacket.itemSlot).getItem();
            if (containerSetslotPacket.myItemStack != null && (itemstack == null || itemstack.stackSize < containerSetslotPacket.myItemStack.stackSize)) {
                containerSetslotPacket.myItemStack.animationsToGo = 5;
            }
            this.mc.thePlayer.inventorySlots.setItem(containerSetslotPacket.itemSlot, containerSetslotPacket.myItemStack);
        } else if (containerSetslotPacket.windowId == this.mc.thePlayer.craftingInventory.containerId) {
            this.mc.thePlayer.craftingInventory.setItem(containerSetslotPacket.itemSlot, containerSetslotPacket.myItemStack);
        }
    }

    @Override
    public void handleTransaction(ContainerAckPacket containerAckPacket) {
        AbstractContainerMenu container = null;
        if (containerAckPacket.windowId == 0) {
            container = this.mc.thePlayer.inventorySlots;
        } else if (containerAckPacket.windowId == this.mc.thePlayer.craftingInventory.containerId) {
            container = this.mc.thePlayer.craftingInventory;
        }
        if (container != null) {
            if (containerAckPacket.accepted) {
                container.deleteBackup(containerAckPacket.shortWindowId);
            } else {
                container.rollbackToBackup(containerAckPacket.shortWindowId);
                this.addToSendQueue(new ContainerAckPacket(containerAckPacket.windowId, containerAckPacket.shortWindowId, true));
            }
        }
    }

    @Override
    public void handleWindowItems(ContainerSetContentPacket setContentPacket) {
        if (setContentPacket.windowId == 0) {
            this.mc.thePlayer.inventorySlots.setAll(setContentPacket.stackList);
        } else if (setContentPacket.windowId == this.mc.thePlayer.craftingInventory.containerId) {
            this.mc.thePlayer.craftingInventory.setAll(setContentPacket.stackList);
        }
    }

    @Override
    public void handleUpdateProgressbar(ContainerSetDataPacket setDataPacket) {
        this.handleInvalidPacket(setDataPacket);
        if (this.mc.thePlayer.craftingInventory != null && this.mc.thePlayer.craftingInventory.containerId == setDataPacket.windowId) {
            this.mc.thePlayer.craftingInventory.setData(setDataPacket.progressBar, setDataPacket.progressBarValue);
        }
    }

    @Override
    public void handlePlayerInventory(SetEquippedItemPacket equippedItemPacket) {
        Entity entity = this.getEntityByID(equippedItemPacket.entityID);
        if (entity != null) {
            entity.setEquippedSlot(equippedItemPacket.slot, equippedItemPacket.itemID, equippedItemPacket.itemMeta, equippedItemPacket.itemData);
        }
    }

    @Override
    public void handlePlayerHeldObject(SetHeldObjectPacket setHeldObjectPacket) {
        Entity entity = this.getEntityByID(setHeldObjectPacket.entityID);
        if (entity != null) {
            entity.setHeldObject(setHeldObjectPacket.objectTag == null ? null : ICarriable.createAndLoadCarriable(entity, setHeldObjectPacket.objectTag));
        }
    }

    @Override
    public void handleCloseWindow(ContainerClosePacket containerClosePacket) {
        this.mc.thePlayer.closeScreen();
    }

    @Override
    public void handlePlayNoteBlock(BlockEventPacket packet54PlaynoteblockEventPacket) {
        this.mc.theWorld.triggerEvent(packet54PlaynoteblockEventPacket.xLocation, packet54PlaynoteblockEventPacket.yLocation, packet54PlaynoteblockEventPacket.zLocation, packet54PlaynoteblockEventPacket.instrumentType, packet54PlaynoteblockEventPacket.pitch);
    }

    @Override
    public void handleBed(BedMessagePacket bedMessagePacket) {
        int state = bedMessagePacket.bedState;
        if (state >= 0 && state < BedMessagePacket.BED_MESSAGE_KEYS.length && BedMessagePacket.BED_MESSAGE_KEYS[state] != null) {
            this.mc.thePlayer.sendTranslatedChatMessage(BedMessagePacket.BED_MESSAGE_KEYS[state]);
        }
    }

    @Override
    public void handleMapData(MapDataPacket mapdataPacket) {
        if (mapdataPacket.itemId == Items.MAP.id) {
            MapItem.getOrCreateSavedData(mapdataPacket.meta, mapdataPacket.scale, this.mc.theWorld).setColors(mapdataPacket.mapData);
        } else {
            LOGGER.warn("Unexpected itemId: {}", (Object)mapdataPacket.itemId);
        }
    }

    @Override
    public void handlePlaySoundEffect(PlaySoundEffectPacket playsoundeffectPacket) {
        this.mc.theWorld.playSoundEffect(playsoundeffectPacket.soundID, playsoundeffectPacket.x, playsoundeffectPacket.y, playsoundeffectPacket.z, playsoundeffectPacket.data);
    }

    @Override
    public void handlePlaySoundDirectly(PlaySoundEffectDirectPacket packet) {
        String soundPath = SoundTypes.getSoundById(packet.soundId);
        if (soundPath == null) {
            return;
        }
        this.mc.sndManager.playSoundAt(soundPath, packet.soundType, (float)packet.x, (float)packet.y, (float)packet.z, packet.volume, packet.pitch);
    }

    @Override
    public void handleSpawnParticle(AddParticlePacket addParticlePacket) {
        if (addParticlePacket.isGroup) {
            for (int i = 0; i < addParticlePacket.amount; ++i) {
                this.mc.renderGlobal.addParticle(addParticlePacket.particleKey, addParticlePacket.x + this.rand.nextDouble() * (double)addParticlePacket.randOffX, addParticlePacket.y + this.rand.nextDouble() * (double)addParticlePacket.randOffY, addParticlePacket.z + this.rand.nextDouble() * (double)addParticlePacket.randOffZ, addParticlePacket.motionX + this.rand.nextGaussian() * (double)addParticlePacket.randMotionX, addParticlePacket.motionY + this.rand.nextGaussian() * (double)addParticlePacket.randMotionY, addParticlePacket.motionZ + this.rand.nextGaussian() * (double)addParticlePacket.randMotionZ, addParticlePacket.data, addParticlePacket.maxDistance);
            }
        } else {
            this.mc.renderGlobal.addParticle(addParticlePacket.particleKey, addParticlePacket.x, addParticlePacket.y, addParticlePacket.z, addParticlePacket.motionX, addParticlePacket.motionY, addParticlePacket.motionZ, addParticlePacket.data, addParticlePacket.maxDistance);
        }
    }

    @Override
    public void handleStatistic(StatisticPacket statisticPacket) {
        this.mc.thePlayer.addStat(StatList.getStat(statisticPacket.statID), statisticPacket.valueChange);
    }

    @Override
    public void handleEntityPlayerGamemode(PlayerGamemodePacket packet) {
        Entity entity = this.getEntityByID(packet.entityId);
        if (entity instanceof Player) {
            ((Player)entity).setGamemode(Gamemode.gamemodesList[packet.gamemodeId]);
        }
    }

    @Override
    public void handleEntityNickname(EntityNicknamePacket entityNicknamePacket) {
        Entity entity = this.getEntityByID(entityNicknamePacket.entityId);
        if (entity instanceof Mob) {
            ((Mob)entity).nickname = StringUtils.substring(entityNicknamePacket.nickname, 0, 32);
            ((Mob)entity).chatColor = entityNicknamePacket.chatColor;
        }
    }

    @Override
    public boolean isServerHandler() {
        return false;
    }

    @Override
    public void handleBlockItemSwitch(SetCarriedItemPacket setCarriedItemPacket) {
        this.mc.thePlayer.inventory.setCurrentItemIndex(setCarriedItemPacket.id, true);
    }

    @Override
    public void handleTileEntityData(BlockEntityDataPacket packet) {
        Class<? extends BlockEntity> clazz = BlockEntity.getClassFromID(packet.tag.getString("id"));
        if (clazz == null) {
            return;
        }
        BlockEntity existingBlockEntity = this.worldClient.getBlockEntity(packet.tag.getInteger("x"), packet.tag.getInteger("y"), packet.tag.getInteger("z"));
        if (existingBlockEntity == null || existingBlockEntity.getClass() != clazz) {
            BlockEntity blockEntity = BlockEntity.createAndLoadEntity(packet.tag);
            if (blockEntity != null) {
                this.mc.theWorld.setBlockTileEntity(blockEntity.x, blockEntity.y, blockEntity.z, blockEntity);
            }
        } else {
            existingBlockEntity.readFromNBT(packet.tag);
        }
        this.worldClient.markBlockDirty(packet.tag.getInteger("x"), packet.tag.getInteger("y"), packet.tag.getInteger("z"));
    }

    @Override
    public void handleGameRule(GameRulePacket packet) {
        LevelData levelData = this.mc.theWorld.getLevelData();
        if (packet.getGameRules() != null) {
            levelData.getGameRules().setValues(packet.getGameRules());
        }
    }

    @Override
    public void handleSyncedRecipe(RecipeSyncPacket recipeSyncPacket) {
        if (Registries.RECIPES.getAllSerializableRecipes().isEmpty()) {
            LOGGER.info("Receiving {} recipes from server..", (Object)recipeSyncPacket.maxRecipes);
        }
        DataLoader.loadRecipeFromServer(recipeSyncPacket);
        if ((long)Registries.RECIPES.getAllSerializableRecipes().size() == recipeSyncPacket.maxRecipes) {
            LOGGER.info("All recipes received!");
            Registries.RECIPES.invalidateCaches();
            SearchPage.searchField.setText("_");
            PageManager.searchQuery = SearchQuery.resolve(SearchPage.searchField.getText());
            GuidebookScreen.getPageManager().updatePages();
            SearchPage.searchField.setText("");
            PageManager.searchQuery = SearchQuery.resolve(SearchPage.searchField.getText());
            GuidebookScreen.getPageManager().updatePages();
        }
    }

    @Override
    public void handleIds(SyncIDsPacket packet) {
        SoundTypes.setSoundIds(packet.soundIds);
    }

    @Override
    public void handleCustomPayload(CustomPayloadPacket packet) {
        if ("BTA|RainbowStart".equals(packet.channel)) {
            int rainbowTicks = Byte.toUnsignedInt(packet.data[0]) << 24 | Byte.toUnsignedInt(packet.data[1]) << 16 | Byte.toUnsignedInt(packet.data[2]) << 8 | Byte.toUnsignedInt(packet.data[3]);
            this.worldClient.addRainbow(rainbowTicks);
        }
    }

    @Override
    public void handleCommandManagerPacket(CommandManagerPacket packet) {
        ChatSuggestionsElement.serverSuggestions = packet.suggestions;
    }
}

