/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.net.thread;

import net.minecraft.client.gui.SelectServerScreen;
import net.minecraft.client.net.handler.PingPacketHandler;
import net.minecraft.core.net.ServerAddress;
import net.minecraft.core.net.ServerData;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.PingHandshakePacket;

public class ThreadPingServer
extends Thread {
    private final SelectServerScreen screen;
    private final ServerData server;
    private boolean done = false;
    private PingPacketHandler netHandler = null;

    public ThreadPingServer(SelectServerScreen screen, ServerData server) {
        this.screen = screen;
        this.server = server;
        ServerAddress address = server.getServerAddress();
        this.setName("ThreadPingServer - " + address.getIP() + ":" + address.getPort());
    }

    public ServerData getServer() {
        return this.server;
    }

    public boolean isDone() {
        return this.done;
    }

    public void tickNetClientHandler() {
        if (this.netHandler != null && this.isDone()) {
            this.netHandler.processReadPackets();
        }
    }

    public PacketHandler getNetHandler() {
        return this.netHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ServerAddress address = this.server.getServerAddress();
        String hostName = address.getIP();
        int port = address.getPort();
        try {
            this.netHandler = new PingPacketHandler(this.screen, this.server);
            this.netHandler.addToSendQueue(new PingHandshakePacket(1, 250, "BTAPingHost", 29184, hostName, port));
        }
        catch (Exception exception) {
        }
        finally {
            this.done = true;
        }
    }
}

