/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.GLAllocation;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.block.entity.FlagBlockEntity;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.net.command.TextFormatting;
import org.jetbrains.annotations.NotNull;

public class FlagRenderer {
    public final int CANVAS_WIDTH = 24;
    public final int CANVAS_HEIGHT = 16;
    private final TextureManager textureManager;
    private final List<Integer> freeTextures = new ArrayList<Integer>();
    private final List<FlagTextureEntry> flagTextures = new ArrayList<FlagTextureEntry>();
    private final Map<FlagBlockEntity, FlagTextureEntry> cache = new Hashtable<FlagBlockEntity, FlagTextureEntry>();
    private int tickCount = 0;

    public FlagRenderer(TextureManager textureManager) {
        this.textureManager = textureManager;
    }

    public void tick() {
        ++this.tickCount;
        if (this.tickCount % 100 != 0) {
            return;
        }
        Iterator<Map.Entry<FlagBlockEntity, FlagTextureEntry>> iterator = this.cache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<FlagBlockEntity, FlagTextureEntry> e = iterator.next();
            FlagBlockEntity flagBlockEntity = e.getKey();
            if (!flagBlockEntity.isInvalid()) continue;
            FlagTextureEntry entry = e.getValue();
            assert (entry.appliedFlags.contains(flagBlockEntity));
            entry.appliedFlags.remove(flagBlockEntity);
            if (entry.appliedFlags.isEmpty()) {
                this.flagTextures.remove(entry);
                this.freeTextures.add(entry.texture);
            }
            iterator.remove();
        }
    }

    public void flushCaches() {
        this.freeTextures.forEach(GLAllocation::deleteTexture);
        this.freeTextures.clear();
        this.cache.clear();
        this.flagTextures.clear();
    }

    public int getTexture(FlagBlockEntity flagBlockEntity) {
        return this.getEntryForFlag((FlagBlockEntity)flagBlockEntity).texture;
    }

    @NotNull
    private FlagTextureEntry getEntryForFlag(FlagBlockEntity flag) {
        FlagTextureEntry e;
        if (!flag.isDirty && (e = this.cache.get(flag)) != null) {
            return e;
        }
        FlagTextureEntry returnEntry = null;
        FlagTextureEntry oldEntry = this.cache.remove(flag);
        if (oldEntry != null) {
            oldEntry.appliedFlags.remove(flag);
            if (oldEntry.appliedFlags.isEmpty()) {
                this.flagTextures.remove(oldEntry);
                this.freeTextures.add(oldEntry.texture);
            }
        }
        for (int i = 0; i < this.flagTextures.size(); ++i) {
            FlagTextureEntry flagEntry = this.flagTextures.get(i);
            if (flag.colorHash != flagEntry.colorHash || flag.activeDyes != flagEntry.activeDyes || !Arrays.equals(flag.flagColors, flagEntry.colorData)) continue;
            returnEntry = flagEntry;
            break;
        }
        if (returnEntry == null) {
            int tex = this.freeTextures.isEmpty() ? this.textureManager.createTexture(24, 16) : this.freeTextures.remove(0).intValue();
            returnEntry = new FlagTextureEntry(tex, flag.colorHash, flag.activeDyes, flag.flagColors);
            this.flagTextures.add(returnEntry);
            this.textureManager.updateTextureData(this.flagDataToRGB(flag, flag.flagColors), 24, 16, tex);
        }
        this.cache.put(flag, returnEntry);
        returnEntry.appliedFlags.add(flag);
        flag.isDirty = false;
        return returnEntry;
    }

    private int[] flagDataToRGB(FlagBlockEntity tileEntity, byte[] colorData) {
        int[] data = new int[384];
        for (int i = 0; i < 384; ++i) {
            byte color = colorData[i];
            int col = this.getColorMap(tileEntity, color);
            int alpha = col >> 24 & 0xFF;
            int red = col >> 16 & 0xFF;
            int green = col >> 8 & 0xFF;
            int blue = col >> 0 & 0xFF;
            data[i] = alpha << 24 | red << 16 | green << 8 | blue << 0;
        }
        return data;
    }

    private int getColorMap(FlagBlockEntity tileEntity, int index) {
        ItemStack stack;
        int col = 0xFFFFFF;
        if (index > 0 && index <= 3 && (stack = tileEntity.getItem(35 + index)) != null && stack.getItem() == Items.DYE) {
            col = Colors.allFlagColors[TextFormatting.get((int)(15 - stack.getMetadata())).id].getARGB();
        }
        return col;
    }

    private static class FlagTextureEntry {
        public final int colorHash;
        public final int activeDyes;
        public final byte[] colorData;
        public final int texture;
        public final Set<FlagBlockEntity> appliedFlags = new HashSet<FlagBlockEntity>();

        public FlagTextureEntry(int texture, int colorHash, int activeDyes, byte[] colorData) {
            this.texture = texture;
            this.colorHash = colorHash;
            this.activeDyes = activeDyes;
            this.colorData = colorData;
        }
    }
}

