/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.awt.Color;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.client.GLAllocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.particle.Particle;
import net.minecraft.client.entity.particle.ParticleDispatcher;
import net.minecraft.client.entity.particle.ParticleLambda;
import net.minecraft.client.gui.PhotoModeScreen;
import net.minecraft.client.gui.modelviewer.ModelViewerScreen;
import net.minecraft.client.render.BlockEntityRenderDispatcher;
import net.minecraft.client.render.CameraSorter;
import net.minecraft.client.render.ChunkRendererComparator;
import net.minecraft.client.render.DisplayList;
import net.minecraft.client.render.EntityRenderDispatcher;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.OpenGLHelper;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.LeavesBlockModel;
import net.minecraft.client.render.camera.EntityCamera;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.colorizer.Colorizers;
import net.minecraft.client.render.culling.CameraFrustum;
import net.minecraft.client.render.terrain.ChunkRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.MusicDiscItem;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.BoundingVolume;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.AuroraProvider;
import net.minecraft.core.world.LevelListener;
import net.minecraft.core.world.World;
import net.minecraft.core.world.season.Seasons;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.weather.Weathers;
import org.lwjgl.opengl.ARBOcclusionQuery;
import org.lwjgl.opengl.GL11;

public class RenderGlobal
implements LevelListener {
    public static IconCoordinate[] breakingAnimation = new IconCoordinate[10];
    public static final int RENDER_CHUNK_SIZE = 16;
    public static final int RENDER_LIST_BASE_WIDTH = 72;
    public List<BlockEntity> tileEntities;
    private World worldObj;
    private final TextureManager textureManager;
    private final List<ChunkRenderer> chunkRenderersToUpdate;
    private ChunkRenderer[] sortedChunkRenderers;
    private ChunkRenderer[] chunkRenderers;
    private int renderChunksWide;
    private int renderChunksTall;
    private int renderChunksDeep;
    private int glRenderListBase;
    private final Minecraft mc;
    private RenderBlocks globalRenderBlocks;
    private IntBuffer glOcclusionQueryBase;
    private boolean occlusionEnabled = false;
    private float lastCloudOffsetX = 0.0f;
    private float lastCloudOffsetZ = 0.0f;
    private float cloudOffsetX = 0.0f;
    private float cloudOffsetZ;
    private float cloudVelocityX;
    private float cloudVelocityZ;
    private final int starGLCallList;
    private final int glSkyList;
    private int minBlockX;
    private int minBlockY;
    private int minBlockZ;
    private int maxBlockX;
    private int maxBlockY;
    private int maxBlockZ;
    private Integer renderDistance = null;
    private int renderEntitiesStartupCounter = 2;
    private int countEntitiesTotal;
    private int countEntitiesRendered;
    private int countEntitiesHidden;
    int[] dummyBuf50k;
    IntBuffer occlusionResult;
    private int renderersLoaded;
    private int renderersBeingClipped;
    private int renderersBeingOccluded;
    private int renderersBeingRendered;
    private int renderersSkippingRenderPass;
    private int worldRenderersCheckIndex;
    private final List<ChunkRenderer> glRenderLists;
    private final DisplayList[] allDisplayLists = new DisplayList[]{new DisplayList(), new DisplayList(), new DisplayList(), new DisplayList()};
    int dummyInt0 = 0;
    int glDummyList;
    double prevSortX = -9999.0;
    double prevSortY = -9999.0;
    double prevSortZ = -9999.0;
    public float damagePartialTime;
    int frustumCheckOffset = 0;
    private double auroraBrightness = 0.0;
    private double targetAuroraBrightness = Double.NaN;
    private double auroraBrightnessDelta = Double.NaN;
    private double rainbowBrightness = 0.0;
    private double targetRainbowBrightness = Double.NaN;
    private double rainbowBrightnessDelta = Double.NaN;

    public RenderGlobal(Minecraft minecraft, TextureManager textureManager) {
        this.tileEntities = new ArrayList<BlockEntity>();
        this.chunkRenderersToUpdate = new ArrayList<ChunkRenderer>();
        this.dummyBuf50k = new int[50000];
        this.occlusionResult = GLAllocation.createDirectIntBuffer(64);
        this.glRenderLists = new ArrayList<ChunkRenderer>();
        this.glDummyList = GLAllocation.generateDisplayLists(1);
        this.mc = minecraft;
        this.textureManager = textureManager;
        this.glRenderListBase = GLAllocation.generateDisplayLists(0x111600);
        this.occlusionEnabled = OpenGLHelper.enableOcclusionCheck;
        if (this.occlusionEnabled) {
            this.occlusionResult.clear();
            this.glOcclusionQueryBase = GLAllocation.createDirectIntBuffer(373248);
            this.glOcclusionQueryBase.clear();
            this.glOcclusionQueryBase.position(0);
            this.glOcclusionQueryBase.limit(373248);
            ARBOcclusionQuery.glGenQueriesARB((IntBuffer)this.glOcclusionQueryBase);
        }
        this.starGLCallList = GLAllocation.generateDisplayLists(3);
        GL11.glPushMatrix();
        GL11.glNewList((int)this.starGLCallList, (int)4864);
        this.setupStarsCallList();
        GL11.glEndList();
        GL11.glPopMatrix();
        Tessellator tessellator = Tessellator.instance;
        this.glSkyList = this.starGLCallList + 1;
        GL11.glNewList((int)this.glSkyList, (int)4864);
        int byte1 = 64;
        int i = 256 / byte1 + 2;
        float y = 16.0f;
        for (int x = -byte1 * i; x <= byte1 * i; x += byte1) {
            for (int z = -byte1 * i; z <= byte1 * i; z += byte1) {
                tessellator.startDrawingQuads();
                tessellator.addVertex(x, y, z);
                tessellator.addVertex(x + byte1, y, z);
                tessellator.addVertex(x + byte1, y, z + byte1);
                tessellator.addVertex(x, y, z + byte1);
                tessellator.draw();
            }
        }
        GL11.glEndList();
    }

    private void setupStarsCallList() {
        Random random = new Random(10842L);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        for (int i = 0; i < 1500; ++i) {
            double d = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.25f + random.nextFloat() * 0.25f;
            double d4 = d * d + d1 * d1 + d2 * d2;
            if (d4 >= 1.0 || d4 <= 0.01) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d * d + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d22;
                double d17 = 0.0;
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d20 = d17;
                double d21 = d18 * d16 - d19 * d15;
                double d23 = d22 = d19 * d16 + d18 * d15;
                double d24 = d21 * d12 + d20 * d13;
                double d25 = d20 * d12 - d21 * d13;
                double d26 = d25 * d9 - d23 * d10;
                double d27 = d24;
                double d28 = d23 * d9 + d25 * d10;
                tessellator.addVertex(d5 + d26, d6 + d27, d7 + d28);
            }
        }
        tessellator.draw();
    }

    public void changeWorld(World world) {
        if (this.worldObj != null) {
            this.worldObj.removeListener(this);
        }
        this.prevSortX = -9999.0;
        this.prevSortY = -9999.0;
        this.prevSortZ = -9999.0;
        EntityRenderDispatcher.instance.unloadEntityRenderers();
        EntityRenderDispatcher.instance.setWorld(world);
        this.worldObj = world;
        this.globalRenderBlocks = new RenderBlocks(world);
        this.auroraBrightness = 0.0;
        this.targetAuroraBrightness = Double.NaN;
        if (world != null) {
            world.addListener(this);
            this.loadRenderers();
        }
    }

    public void loadRenderers() {
        this.deleteRenderListBase();
        this.glRenderListBase = GLAllocation.generateDisplayLists(0x111600);
        LeavesBlockModel.setGraphicsLevel((Integer)this.mc.gameSettings.fancyGraphics.value == 1);
        this.renderDistance = (Integer)this.mc.gameSettings.renderDistance.value;
        if (this.worldObj == null) {
            return;
        }
        if (this.chunkRenderers != null) {
            for (ChunkRenderer chunkRenderer : this.chunkRenderers) {
                chunkRenderer.delete();
            }
        }
        int renderDiameterBlocks = this.renderDistance * 16 * 2;
        this.renderChunksWide = renderDiameterBlocks / 16 + 1;
        this.renderChunksTall = this.worldObj.getHeightBlocks() / 16;
        this.renderChunksDeep = renderDiameterBlocks / 16 + 1;
        this.chunkRenderers = new ChunkRenderer[this.renderChunksWide * this.renderChunksTall * this.renderChunksDeep];
        this.sortedChunkRenderers = new ChunkRenderer[this.renderChunksWide * this.renderChunksTall * this.renderChunksDeep];
        int renderListOffset = 0;
        int chunkIndex = 0;
        this.minBlockX = 0;
        this.minBlockY = 0;
        this.minBlockZ = 0;
        this.maxBlockX = this.renderChunksWide;
        this.maxBlockY = this.renderChunksTall;
        this.maxBlockZ = this.renderChunksDeep;
        for (ChunkRenderer cr : this.chunkRenderersToUpdate) {
            cr.dirty = false;
        }
        this.chunkRenderersToUpdate.clear();
        this.tileEntities.clear();
        for (int x = 0; x < this.renderChunksWide; ++x) {
            for (int y = 0; y < this.renderChunksTall; ++y) {
                for (int z = 0; z < this.renderChunksDeep; ++z) {
                    int index = (z * this.renderChunksTall + y) * this.renderChunksWide + x;
                    this.chunkRenderers[index] = this.mc.terrainRenderer.createChunkRenderer(this.worldObj, this.tileEntities, x * 16, y * 16, z * 16, 16, this.glRenderListBase + renderListOffset);
                    if (this.occlusionEnabled) {
                        this.chunkRenderers[index].occlusionId = this.glOcclusionQueryBase.get(chunkIndex);
                    }
                    this.chunkRenderers[index].occlusionQuerying = false;
                    this.chunkRenderers[index].occlusionVisible = true;
                    this.chunkRenderers[index].visible = true;
                    this.chunkRenderers[index].id = chunkIndex++;
                    this.chunkRenderers[index].setDirty();
                    this.sortedChunkRenderers[index] = this.chunkRenderers[index];
                    this.chunkRenderersToUpdate.add(this.chunkRenderers[index]);
                    renderListOffset += 3;
                }
            }
        }
        if (this.worldObj != null && this.mc.activeCamera != null) {
            this.markRenderersForNewPosition(MathHelper.floor(this.mc.activeCamera.getX()), MathHelper.floor(this.mc.activeCamera.getY()), MathHelper.floor(this.mc.activeCamera.getZ()));
            Arrays.sort(this.sortedChunkRenderers, new CameraSorter(this.mc.activeCamera));
        }
        this.renderEntitiesStartupCounter = 2;
    }

    public void renderAurora(ICamera camera, float partialTick) {
        float celestialAngle = this.worldObj.getCelestialAngle(partialTick);
        if (celestialAngle < 0.25f) {
            return;
        }
        double cameraX = camera.getX(partialTick);
        double cameraY = camera.getY(partialTick);
        double cameraZ = camera.getZ(partialTick);
        double cameraYaw = camera.getYRot(partialTick);
        double temperature = this.worldObj.getBlockTemperature((int)cameraX, (int)cameraZ);
        float mult = 0.0f;
        if (temperature <= (double)0.4f || this.worldObj.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_WINTER_ENDLESS) {
            temperature /= (double)0.4f;
            temperature = -temperature + 1.0;
            mult = (float)((double)mult + temperature);
        }
        double altitude = this.worldObj.getWorldType().getYPercentage((int)cameraY);
        if ((temperature <= (double)0.6f || this.worldObj.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_WINTER || this.worldObj.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_WINTER_ENDLESS) && altitude >= (double)0.8f) {
            if ((altitude -= (double)0.8f) > (double)0.1f) {
                altitude = 0.1f;
            }
            mult = (float)((double)mult + altitude);
        }
        if (mult < 0.0f) {
            mult = 0.0f;
        }
        if (mult > 1.0f) {
            mult = 1.0f;
        }
        if (Double.isNaN(this.targetAuroraBrightness)) {
            this.auroraBrightness = mult;
        }
        this.targetAuroraBrightness = mult;
        double totalDelta = this.targetAuroraBrightness - this.auroraBrightness;
        this.auroraBrightnessDelta = totalDelta / 100.0;
        this.auroraBrightness += this.auroraBrightnessDelta * (double)partialTick;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)519);
        GL11.glDisable((int)2912);
        GL11.glDisable((int)3008);
        double scale = 1.0;
        double auroraY = ((float)(this.worldObj.getWorldType().getMinY() + this.worldObj.getWorldType().getYRange()) + 64.0f) * 2.0f;
        double rotationX = Math.cos(cameraYaw * Math.PI / 180.0);
        double rotationZ = Math.sin(cameraYaw * Math.PI / 180.0);
        this.textureManager.bindTexture(this.textureManager.loadTexture("/assets/minecraft/textures/environment/aurora.png"));
        double time = (float)this.worldObj.getWorldTime() + partialTick;
        AuroraProvider aurora = this.worldObj.auroraProvider;
        double radius = 512.0;
        long worldTime = this.worldObj.getWorldTime();
        Tessellator.instance.startDrawingQuads();
        for (double x = -radius; x < radius; x += 8.0) {
            for (double z = -radius; z < radius; z += 8.0) {
                double posX = cameraX + x;
                double posZ = cameraZ + z;
                double distanceSq = x * x + z + z;
                double distanceSqPercentage = distanceSq / (radius * radius + radius * radius);
                distanceSqPercentage = 1.0 - distanceSqPercentage;
                double sample = aurora.getAuroraPresence(posX, posZ, worldTime, celestialAngle) * this.auroraBrightness;
                if (sample * (double)0.3f * distanceSqPercentage < (double)0.01f) continue;
                this.renderAuroraBeam(x * 1.0, auroraY * 1.0 - cameraY * 1.0 + aurora.getAuroraHeightOffset(posX, posZ, time), z * 1.0, rotationX, rotationZ, aurora.getAuroraRedOffset(posX, posZ, time), aurora.getAuroraGreenOffset(posX, posZ, time), aurora.getAuroraBlueOffset(posX, posZ, time), 1.0, (float)(sample * (double)0.3f * distanceSqPercentage));
            }
        }
        Tessellator.instance.draw();
        GL11.glEnable((int)2912);
        GL11.glEnable((int)3008);
        GL11.glDepthFunc((int)515);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2896);
    }

    private void renderAuroraBeam(double x, double y, double z, double xOffset, double zOffset, float redOffset, float greenOffset, float blueOffset, double scale, float transparency) {
        float width = 16.0f;
        Tessellator tessellator = Tessellator.instance;
        tessellator.setColorRGBA_F(0.0f + redOffset, 1.0f + greenOffset, 0.49803922f + blueOffset, transparency);
        tessellator.addVertexWithUV(x - xOffset * scale * (double)width, y - scale * 256.0, z - zOffset * scale * (double)width, 1.0, 1.0);
        tessellator.addVertexWithUV(x - xOffset * scale * (double)width, y + scale, z - zOffset * scale * (double)width, 1.0, 0.0);
        tessellator.addVertexWithUV(x + xOffset * scale * (double)width, y + scale, z + zOffset * scale * (double)width, 0.0, 0.0);
        tessellator.addVertexWithUV(x + xOffset * scale * (double)width, y - scale * 256.0, z + zOffset * scale * (double)width, 0.0, 1.0);
    }

    public void renderEntities(ICamera camera, float partialTick) {
        Entity entity;
        int i;
        if (this.renderEntitiesStartupCounter > 0) {
            --this.renderEntitiesStartupCounter;
            return;
        }
        BlockEntityRenderDispatcher.instance.cacheActiveRenderInfo(this.worldObj, this.textureManager, this.mc.font, camera, partialTick);
        EntityRenderDispatcher.instance.cacheActiveRenderInfo(this.worldObj, this.textureManager, this.mc.font, camera, this.mc.gameSettings, partialTick);
        this.countEntitiesTotal = 0;
        this.countEntitiesRendered = 0;
        this.countEntitiesHidden = 0;
        EntityRenderDispatcher.renderPosX = camera.getX(partialTick);
        EntityRenderDispatcher.renderPosY = camera.getY(partialTick);
        EntityRenderDispatcher.renderPosZ = camera.getZ(partialTick);
        BlockEntityRenderDispatcher.renderPosX = camera.getX(partialTick);
        BlockEntityRenderDispatcher.renderPosY = camera.getY(partialTick);
        BlockEntityRenderDispatcher.renderPosZ = camera.getZ(partialTick);
        List<Entity> loadedEntities = this.worldObj.getLoadedEntityList();
        this.countEntitiesTotal = loadedEntities.size();
        Tessellator tessellator = Tessellator.instance;
        for (i = 0; i < this.worldObj.weatherEffects.size(); ++i) {
            entity = this.worldObj.weatherEffects.get(i);
            ++this.countEntitiesRendered;
            if (!entity.shouldRender(camera.getPosition(partialTick)) && this.mc.thePlayer.vehicle != entity) continue;
            EntityRenderDispatcher.instance.renderEntity(tessellator, entity, partialTick);
        }
        for (i = 0; i < loadedEntities.size(); ++i) {
            entity = loadedEntities.get(i);
            if (this.mc.activeCamera != null && this.mc.activeCamera instanceof EntityCamera && ((EntityCamera)this.mc.activeCamera).mob == entity && !this.mc.activeCamera.showPlayer() || this.mc.thePlayer.vehicle != entity && (!entity.shouldRender(camera.getPosition(partialTick)) || !entity.ignoreFrustumCheck && !camera.getFrustum().isVisible(entity.bb, partialTick))) continue;
            int floorY = MathHelper.floor(entity.y);
            if (floorY < 0) {
                floorY = 0;
            }
            if (floorY >= this.worldObj.getHeightBlocks()) {
                floorY = this.worldObj.getHeightBlocks() - 1;
            }
            if (!this.worldObj.isBlockLoaded(MathHelper.floor(entity.x), floorY, MathHelper.floor(entity.z)) && this.mc.thePlayer.vehicle != entity) continue;
            ++this.countEntitiesRendered;
            EntityRenderDispatcher.instance.renderEntity(tessellator, entity, partialTick);
        }
        for (BlockEntity blockEntity : this.tileEntities) {
            BlockEntityRenderDispatcher.instance.renderTileEntity(tessellator, blockEntity, partialTick);
        }
    }

    public String getRendererDebugInfo() {
        return "C: " + this.renderersBeingRendered + "/" + this.renderersLoaded + ". F: " + this.renderersBeingClipped + ", O: " + this.renderersBeingOccluded + ", E: " + this.renderersSkippingRenderPass;
    }

    public String getEntityDebugInfo() {
        return "E: " + this.countEntitiesRendered + "/" + this.countEntitiesTotal + ". B: " + this.countEntitiesHidden + ", I: " + (this.countEntitiesTotal - this.countEntitiesHidden - this.countEntitiesRendered);
    }

    public void markRenderersForNewPosition(int i, int j, int k) {
        i -= 8;
        j -= 8;
        k -= 8;
        this.minBlockX = Integer.MAX_VALUE;
        this.minBlockY = Integer.MAX_VALUE;
        this.minBlockZ = Integer.MAX_VALUE;
        this.maxBlockX = Integer.MIN_VALUE;
        this.maxBlockY = Integer.MIN_VALUE;
        this.maxBlockZ = Integer.MIN_VALUE;
        int l = this.renderChunksWide * 16;
        int i1 = l / 2;
        for (int j1 = 0; j1 < this.renderChunksWide; ++j1) {
            int k1 = j1 * 16;
            int l1 = k1 + i1 - i;
            if (l1 < 0) {
                l1 -= l - 1;
            }
            if ((k1 -= (l1 /= l) * l) < this.minBlockX) {
                this.minBlockX = k1;
            }
            if (k1 > this.maxBlockX) {
                this.maxBlockX = k1;
            }
            for (int i2 = 0; i2 < this.renderChunksDeep; ++i2) {
                int j2 = i2 * 16;
                int k2 = j2 + i1 - k;
                if (k2 < 0) {
                    k2 -= l - 1;
                }
                if ((j2 -= (k2 /= l) * l) < this.minBlockZ) {
                    this.minBlockZ = j2;
                }
                if (j2 > this.maxBlockZ) {
                    this.maxBlockZ = j2;
                }
                for (int l2 = 0; l2 < this.renderChunksTall; ++l2) {
                    int i3 = l2 * 16;
                    if (i3 < this.minBlockY) {
                        this.minBlockY = i3;
                    }
                    if (i3 > this.maxBlockY) {
                        this.maxBlockY = i3;
                    }
                    ChunkRenderer worldrenderer = this.chunkRenderers[(i2 * this.renderChunksTall + l2) * this.renderChunksWide + j1];
                    boolean flag = worldrenderer.dirty;
                    worldrenderer.setPos(k1, i3, j2);
                    if (flag || !worldrenderer.dirty) continue;
                    this.chunkRenderersToUpdate.add(worldrenderer);
                }
            }
        }
    }

    public int sortAndRender(ICamera camera, int renderPass, double partialTick) {
        double dPosZ;
        double dPosY;
        for (int i = 0; i < 10; ++i) {
            this.worldRenderersCheckIndex = (this.worldRenderersCheckIndex + 1) % this.chunkRenderers.length;
            ChunkRenderer chunkRenderer = this.chunkRenderers[this.worldRenderersCheckIndex];
            if (!chunkRenderer.dirty || this.chunkRenderersToUpdate.contains(chunkRenderer)) continue;
            this.chunkRenderersToUpdate.add(chunkRenderer);
        }
        if (this.mc.gameSettings.renderDistance.value != this.renderDistance) {
            this.loadRenderers();
        }
        if (renderPass == 0) {
            this.renderersLoaded = 0;
            this.renderersBeingClipped = 0;
            this.renderersBeingOccluded = 0;
            this.renderersBeingRendered = 0;
            this.renderersSkippingRenderPass = 0;
        }
        double entityPosX = camera.getX((float)partialTick);
        double entityPosY = camera.getY((float)partialTick);
        double entityPosZ = camera.getZ((float)partialTick);
        double dPosX = camera.getX() - this.prevSortX;
        if (dPosX * dPosX + (dPosY = camera.getY() - this.prevSortY) * dPosY + (dPosZ = camera.getZ() - this.prevSortZ) * dPosZ > 16.0) {
            this.prevSortX = camera.getX();
            this.prevSortY = camera.getY();
            this.prevSortZ = camera.getZ();
            this.markRenderersForNewPosition(MathHelper.floor(camera.getX()), MathHelper.floor(camera.getY()), MathHelper.floor(camera.getZ()));
            Arrays.sort(this.sortedChunkRenderers, new CameraSorter(camera));
        }
        Lighting.disable();
        int k = 0;
        if (this.occlusionEnabled && ((Boolean)this.mc.gameSettings.advancedOpenGL.value).booleanValue() && renderPass == 0) {
            int min = 0;
            int max = 16;
            this.checkOcclusionQueryResult(min, max);
            for (int i = min; i < max; ++i) {
                this.sortedChunkRenderers[i].occlusionVisible = true;
            }
            k += this.renderSortedRenderers(min, max, renderPass, partialTick);
            do {
                int byte0 = max;
                if ((max *= 2) > this.sortedChunkRenderers.length) {
                    max = this.sortedChunkRenderers.length;
                }
                GL11.glDisable((int)3553);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)3008);
                GL11.glDisable((int)2912);
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                GL11.glDepthMask((boolean)false);
                this.checkOcclusionQueryResult(byte0, max);
                GL11.glPushMatrix();
                float f = 0.0f;
                float f1 = 0.0f;
                float f2 = 0.0f;
                for (int k1 = byte0; k1 < max; ++k1) {
                    float f3;
                    int l1;
                    if (this.sortedChunkRenderers[k1].isEmpty()) {
                        this.sortedChunkRenderers[k1].visible = false;
                        continue;
                    }
                    if (!this.sortedChunkRenderers[k1].visible) {
                        this.sortedChunkRenderers[k1].occlusionVisible = true;
                    }
                    if (!this.sortedChunkRenderers[k1].visible || this.sortedChunkRenderers[k1].occlusionQuerying || this.cloudOffsetX % (float)(l1 = (int)(1.0f + (f3 = MathHelper.sqrt_float(this.sortedChunkRenderers[k1].distanceToCameraSquared(camera))) / 128.0f)) != (float)(k1 % l1)) continue;
                    ChunkRenderer worldrenderer1 = this.sortedChunkRenderers[k1];
                    float f4 = (float)((double)worldrenderer1.xRender - entityPosX);
                    float f5 = (float)((double)worldrenderer1.yRender - entityPosY);
                    float f6 = (float)((double)worldrenderer1.zRender - entityPosZ);
                    float f7 = f4 - f;
                    float f8 = f5 - f1;
                    float f9 = f6 - f2;
                    if (f7 != 0.0f || f8 != 0.0f || f9 != 0.0f) {
                        GL11.glTranslatef((float)f7, (float)f8, (float)f9);
                        f += f7;
                        f1 += f8;
                        f2 += f9;
                    }
                    ARBOcclusionQuery.glBeginQueryARB((int)35092, (int)this.sortedChunkRenderers[k1].occlusionId);
                    this.sortedChunkRenderers[k1].renderBB();
                    ARBOcclusionQuery.glEndQueryARB((int)35092);
                    this.sortedChunkRenderers[k1].occlusionQuerying = true;
                }
                GL11.glPopMatrix();
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)3553);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)2912);
                k += this.renderSortedRenderers(byte0, max, renderPass, partialTick);
            } while (max < this.sortedChunkRenderers.length);
        } else {
            k += this.renderSortedRenderers(0, this.sortedChunkRenderers.length, renderPass, partialTick);
        }
        return k;
    }

    private void checkOcclusionQueryResult(int min, int max) {
        for (int i = min; i < max; ++i) {
            if (!this.sortedChunkRenderers[i].occlusionQuerying) continue;
            this.occlusionResult.clear();
            ARBOcclusionQuery.glGetQueryObjectuivARB((int)this.sortedChunkRenderers[i].occlusionId, (int)34919, (IntBuffer)this.occlusionResult);
            if (this.occlusionResult.get(0) == 0) continue;
            this.sortedChunkRenderers[i].occlusionQuerying = false;
            this.occlusionResult.clear();
            ARBOcclusionQuery.glGetQueryObjectuivARB((int)this.sortedChunkRenderers[i].occlusionId, (int)34918, (IntBuffer)this.occlusionResult);
            this.sortedChunkRenderers[i].occlusionVisible = this.occlusionResult.get(0) != 0;
        }
    }

    private int renderSortedRenderers(int min, int max, int renderPass, double partialTick) {
        this.glRenderLists.clear();
        int addedWorldRenderers = 0;
        for (int i = min; i < max; ++i) {
            int callList;
            if (renderPass == 0) {
                ++this.renderersLoaded;
                if (this.sortedChunkRenderers[i].empty[renderPass]) {
                    ++this.renderersSkippingRenderPass;
                } else if (!this.sortedChunkRenderers[i].visible) {
                    ++this.renderersBeingClipped;
                } else if (this.occlusionEnabled && !this.sortedChunkRenderers[i].occlusionVisible) {
                    ++this.renderersBeingOccluded;
                } else {
                    ++this.renderersBeingRendered;
                }
            }
            if (this.sortedChunkRenderers[i].empty[renderPass] || !this.sortedChunkRenderers[i].visible || this.occlusionEnabled && !this.sortedChunkRenderers[i].occlusionVisible || (callList = this.sortedChunkRenderers[i].getList(renderPass)) < 0) continue;
            this.glRenderLists.add(this.sortedChunkRenderers[i]);
            ++addedWorldRenderers;
        }
        double posX = this.mc.activeCamera.getX((float)partialTick);
        double posY = this.mc.activeCamera.getY((float)partialTick);
        double posZ = this.mc.activeCamera.getZ((float)partialTick);
        int k1 = 0;
        for (DisplayList displayList : this.allDisplayLists) {
            displayList.clear();
        }
        for (ChunkRenderer chunkRenderer : this.glRenderLists) {
            int displayListIndex = -1;
            for (int i = 0; i < k1; ++i) {
                if (!this.allDisplayLists[i].isSetToPos(chunkRenderer.xRender, chunkRenderer.yRender, chunkRenderer.zRender)) continue;
                displayListIndex = i;
            }
            if (displayListIndex < 0) {
                displayListIndex = k1++;
                this.allDisplayLists[displayListIndex].setToPos(chunkRenderer.xRender, chunkRenderer.yRender, chunkRenderer.zRender, posX, posY, posZ);
            }
            this.allDisplayLists[displayListIndex].addCallToList(chunkRenderer.getList(renderPass));
        }
        if (!((Boolean)this.mc.gameSettings.fog.value).booleanValue()) {
            GL11.glDisable((int)2912);
        }
        this.callAllDisplayLists(renderPass, partialTick);
        if (!((Boolean)this.mc.gameSettings.fog.value).booleanValue()) {
            GL11.glEnable((int)2912);
        }
        return addedWorldRenderers;
    }

    public void callAllDisplayLists(int renderPass, double partialTick) {
        for (DisplayList displayList : this.allDisplayLists) {
            displayList.call();
        }
    }

    public void updateClouds() {
        float windDirection = this.worldObj.worldType.getWindManager().getWindDirection(this.worldObj, 0.0f, 500.0f, 0.0f);
        float windIntensity = this.worldObj.worldType.getWindManager().getWindIntensity(this.worldObj, 0.0f, 500.0f, 0.0f);
        float dx = -((float)(Math.cos((double)windDirection * Math.PI * 2.0) * (double)windIntensity));
        float dz = -((float)(Math.sin((double)windDirection * Math.PI * 2.0) * (double)windIntensity));
        this.cloudVelocityX += dx;
        this.cloudVelocityZ += dz;
        float maxVel = 1.5f;
        if (this.cloudVelocityX > maxVel) {
            this.cloudVelocityX = maxVel;
        }
        if (this.cloudVelocityX < -maxVel) {
            this.cloudVelocityX = -maxVel;
        }
        if (this.cloudVelocityZ > maxVel) {
            this.cloudVelocityZ = maxVel;
        }
        if (this.cloudVelocityZ < -maxVel) {
            this.cloudVelocityZ = -maxVel;
        }
        this.lastCloudOffsetX = this.cloudOffsetX;
        this.lastCloudOffsetZ = this.cloudOffsetZ;
        this.cloudOffsetX += this.cloudVelocityX;
        this.cloudOffsetZ += this.cloudVelocityZ;
    }

    public void drawSky(float partialTick) {
        if (!this.mc.theWorld.getWorldType().hasSky() || this.mc.currentScreen instanceof ModelViewerScreen) {
            return;
        }
        float celestialAngle = this.worldObj.getCelestialAngle(partialTick);
        GL11.glDisable((int)3553);
        Vec3 skyColor = this.worldObj.getSkyColor(this.mc.activeCamera, partialTick);
        float r = (float)skyColor.x;
        float g = (float)skyColor.y;
        float b = (float)skyColor.z;
        GL11.glColor3f((float)r, (float)g, (float)b);
        Tessellator t = Tessellator.instance;
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)2912);
        GL11.glColor3f((float)r, (float)g, (float)b);
        GL11.glCallList((int)this.glSkyList);
        GL11.glDisable((int)2912);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Lighting.disable();
        float[] sunriseColor = this.worldObj.worldType.getSunriseColor(celestialAngle, partialTick);
        if (sunriseColor != null) {
            GL11.glDisable((int)3553);
            GL11.glShadeModel((int)7425);
            GL11.glPushMatrix();
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(celestialAngle <= 0.5f ? 0.0f : 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            float sr = sunriseColor[0];
            float sg = sunriseColor[1];
            float sb = sunriseColor[2];
            t.startDrawing(6);
            t.setColorRGBA_F(sr, sg, sb, sunriseColor[3]);
            t.addVertex(0.0, 100.0, 0.0);
            int numVertices = 16;
            t.setColorRGBA_F(sunriseColor[0], sunriseColor[1], sunriseColor[2], 0.0f);
            for (int i = 0; i <= numVertices; ++i) {
                float theta = (float)i * (float)Math.PI * 2.0f / (float)numVertices;
                float sunriseX = MathHelper.sin(theta);
                float sunriseYZ = MathHelper.cos(theta);
                t.addVertex(sunriseX * 120.0f, sunriseYZ * 120.0f, -sunriseYZ * 40.0f * sunriseColor[3]);
            }
            t.draw();
            GL11.glPopMatrix();
            GL11.glShadeModel((int)7424);
        }
        GL11.glEnable((int)3553);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glPushMatrix();
        float sunAlpha = 1.0f - (this.worldObj.getCurrentWeather() != null && this.worldObj.getCurrentWeather() != Weathers.OVERWORLD_CLEAR ? this.worldObj.weatherManager.getWeatherIntensity() * this.worldObj.weatherManager.getWeatherPower() * 1.5f : 0.0f);
        if (!((Boolean)this.mc.gameSettings.fog.value).booleanValue() && this.worldObj.getCurrentWeather() == Weathers.OVERWORLD_FOG) {
            sunAlpha = 1.0f;
        }
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(celestialAngle * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        float size = 30.0f;
        this.textureManager.loadTexture("/terrain/sun.png").bind();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)sunAlpha);
        t.startDrawingQuads();
        t.addVertexWithUV(-size, 100.0, -size, 0.0, 0.0);
        t.addVertexWithUV(size, 100.0, -size, 1.0, 0.0);
        t.addVertexWithUV(size, 100.0, size, 1.0, 1.0);
        t.addVertexWithUV(-size, 100.0, size, 0.0, 1.0);
        t.draw();
        if (this.worldObj.rainbowTicks > 0 || !Double.isNaN(this.rainbowBrightness) && this.rainbowBrightness > 0.0) {
            float timeScalar;
            double angDiff;
            float halfRainbowLength = (float)this.worldObj.startingRainbowTicks / 2.0f;
            float rainbowTimeScalar = 1.0f - Math.abs((float)this.worldObj.rainbowTicks + partialTick - halfRainbowLength) / halfRainbowLength;
            float angDeg = celestialAngle * 360.0f;
            if (angDeg >= 0.0f && angDeg < 180.0f) {
                angDiff = MathHelper.deltaAngle(angDeg, 80.0);
                timeScalar = 1.0f - (float)(Math.sqrt(angDiff * angDiff) / 90.0);
            } else {
                angDiff = MathHelper.deltaAngle(angDeg, 280.0);
                timeScalar = 1.0f - (float)(Math.sqrt(angDiff * angDiff) / 90.0);
            }
            float cutoff = 2.25f;
            timeScalar -= 0.5555556f;
            if (timeScalar < 0.0f) {
                timeScalar = 0.0f;
            }
            timeScalar *= 2.25f;
            timeScalar *= rainbowTimeScalar;
            Weather[] blocked = this.worldObj.getBlockBiome((int)MathHelper.floor((double)this.mc.thePlayer.x), (int)MathHelper.floor((double)this.mc.thePlayer.y), (int)MathHelper.floor((double)this.mc.thePlayer.z)).blockedWeathers;
            boolean isWeatherBlocked = false;
            for (Weather w : blocked) {
                if (!w.equals(this.worldObj.weatherManager.getLastWeather())) continue;
                isWeatherBlocked = true;
                break;
            }
            this.targetRainbowBrightness = isWeatherBlocked ? 0.0 : (double)timeScalar;
            if (Double.isNaN(this.rainbowBrightness)) {
                this.rainbowBrightness = this.targetRainbowBrightness;
            }
            double totalDelta = this.targetRainbowBrightness - this.rainbowBrightness;
            this.rainbowBrightnessDelta = totalDelta / 100.0;
            this.rainbowBrightness += this.rainbowBrightnessDelta * (double)partialTick;
            this.textureManager.loadTexture("/terrain/rainbow.png").bind();
            t.startDrawingQuads();
            int iterations = 10;
            for (int i = 0; i < 10; ++i) {
                size = 200.0f - (float)(i * 4);
                int color = Color.HSBtoRGB((float)i / 10.0f, 1.0f, (float)((double)0.3f * this.rainbowBrightness));
                float colR = (float)(color >> 16 & 0xFF) / 255.0f;
                float colG = (float)(color >> 8 & 0xFF) / 255.0f;
                float colB = (float)(color >> 0 & 0xFF) / 255.0f;
                float rainbowAlpha = (float)((double)(0.35f - 0.15f * (float)Math.abs(i - 5) / 5.0f) * this.rainbowBrightness);
                t.setColorRGBA_F(colR, colG, colB, rainbowAlpha);
                t.addVertexWithUV(-size, -100.0, size, 1.0, 1.0);
                t.addVertexWithUV(size, -100.0, size, 0.0, 1.0);
                t.addVertexWithUV(size, -100.0, -size, 0.0, 0.0);
                t.addVertexWithUV(-size, -100.0, -size, 1.0, 0.0);
            }
            t.draw();
        } else {
            this.rainbowBrightness = 0.0;
            this.rainbowBrightnessDelta = 0.0;
            this.targetRainbowBrightness = 0.0;
        }
        size = 20.0f;
        this.textureManager.loadTexture("/terrain/moon.png").bind();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)sunAlpha);
        t.startDrawingQuads();
        t.addVertexWithUV(-size, -100.0, size, 1.0, 1.0);
        t.addVertexWithUV(size, -100.0, size, 0.0, 1.0);
        t.addVertexWithUV(size, -100.0, -size, 0.0, 0.0);
        t.addVertexWithUV(-size, -100.0, -size, 1.0, 0.0);
        t.draw();
        GL11.glDisable((int)3553);
        float f17 = this.worldObj.getStarBrightness(partialTick) * sunAlpha;
        if (f17 > 0.0f) {
            GL11.glColor4f((float)f17, (float)f17, (float)f17, (float)f17);
            GL11.glCallList((int)this.starGLCallList);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2912);
        GL11.glPopMatrix();
        if (this.worldObj.worldType.hasGround()) {
            GL11.glColor3f((float)(r * 0.2f + 0.04f), (float)(g * 0.2f + 0.04f), (float)(b * 0.6f + 0.1f));
        } else {
            GL11.glColor3f((float)r, (float)g, (float)b);
        }
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
    }

    private float getCloudHeightModifier() {
        return ((Float)this.mc.gameSettings.cloudHeight.value).floatValue() * 128.0f;
    }

    public void renderClouds(float partialTick) {
        if (!this.mc.theWorld.getWorldType().hasClouds()) {
            return;
        }
        if (this.mc.currentScreen instanceof PhotoModeScreen) {
            return;
        }
        if ((Integer)this.mc.gameSettings.fancyGraphics.value == 1) {
            this.renderCloudsFancy(partialTick);
            return;
        }
        GL11.glDisable((int)2884);
        float cameraY = (float)this.mc.activeCamera.getY(partialTick);
        int cloudRadius = 32;
        int i = 256 / cloudRadius;
        Tessellator tessellator = Tessellator.instance;
        this.textureManager.loadTexture("/assets/minecraft/textures/environment/clouds.png").bind();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Vec3 dimensionColor = this.worldObj.getDimensionColor(this.mc.activeCamera, partialTick);
        float r = (float)dimensionColor.x;
        float g = (float)dimensionColor.y;
        float b = (float)dimensionColor.z;
        float f6 = 4.8828125E-4f;
        double posX = this.mc.activeCamera.getX(partialTick) + (double)((this.lastCloudOffsetX + (this.cloudOffsetX - this.lastCloudOffsetX) * partialTick) * 0.03f);
        double posZ = this.mc.activeCamera.getZ(partialTick) + (double)((this.lastCloudOffsetZ + (this.cloudOffsetZ - this.lastCloudOffsetZ) * partialTick) * 0.03f);
        int j = MathHelper.floor(posX / 2048.0);
        int k = MathHelper.floor(posZ / 2048.0);
        float cloudHeight = this.worldObj.worldType.getCloudHeight() - cameraY + 0.33f + this.getCloudHeightModifier();
        float f10 = (float)((posX -= (double)(j * 2048)) * (double)f6);
        float f11 = (float)((posZ -= (double)(k * 2048)) * (double)f6);
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_F(r, g, b, 0.8f);
        for (int cloudX = -cloudRadius * i; cloudX < cloudRadius * i; cloudX += cloudRadius) {
            for (int cloudZ = -cloudRadius * i; cloudZ < cloudRadius * i; cloudZ += cloudRadius) {
                tessellator.addVertexWithUV(cloudX, cloudHeight, cloudZ + cloudRadius, (float)cloudX * f6 + f10, (float)(cloudZ + cloudRadius) * f6 + f11);
                tessellator.addVertexWithUV(cloudX + cloudRadius, cloudHeight, cloudZ + cloudRadius, (float)(cloudX + cloudRadius) * f6 + f10, (float)(cloudZ + cloudRadius) * f6 + f11);
                tessellator.addVertexWithUV(cloudX + cloudRadius, cloudHeight, cloudZ, (float)(cloudX + cloudRadius) * f6 + f10, (float)cloudZ * f6 + f11);
                tessellator.addVertexWithUV(cloudX, cloudHeight, cloudZ, (float)cloudX * f6 + f10, (float)cloudZ * f6 + f11);
            }
        }
        tessellator.draw();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
    }

    public void renderCloudsFancy(float partialTick) {
        this.mc.renderer.beginRenderClouds(partialTick);
        float celestialAngle = this.worldObj.getCelestialAngle(partialTick);
        float[] sunriseColor = this.worldObj.worldType.getSunriseColor(celestialAngle, partialTick);
        float rSun = 0.0f;
        float gSun = 0.0f;
        float bSun = 0.0f;
        float aSun = 0.0f;
        if (sunriseColor != null) {
            rSun = sunriseColor[0];
            gSun = sunriseColor[1];
            bSun = sunriseColor[2];
            aSun = sunriseColor[3] / 2.0f;
        }
        Vec3 dimensionColor = this.worldObj.getDimensionColor(this.mc.activeCamera, partialTick);
        float rDim = (float)dimensionColor.x;
        float gDim = (float)dimensionColor.y;
        float bDim = (float)dimensionColor.z;
        GL11.glDisable((int)2884);
        float cameraY = (float)this.mc.activeCamera.getY(partialTick);
        Tessellator tessellator = Tessellator.instance;
        float cloudWidth = 12.0f;
        float cloudThickness = 4.0f;
        double dx = (this.mc.activeCamera.getX(partialTick) + (double)((this.lastCloudOffsetX + (this.cloudOffsetX - this.lastCloudOffsetX) * partialTick) * 0.03f)) / (double)cloudWidth;
        double dz = (this.mc.activeCamera.getZ(partialTick) + (double)((this.lastCloudOffsetZ + (this.cloudOffsetZ - this.lastCloudOffsetZ) * partialTick) * 0.03f)) / (double)cloudWidth + 0.33;
        float dy = this.worldObj.worldType.getCloudHeight() - cameraY + 0.33f + this.getCloudHeightModifier();
        int i = MathHelper.floor(dx / 2048.0);
        int j = MathHelper.floor(dz / 2048.0);
        dx -= (double)(i * 2048);
        dz -= (double)(j * 2048);
        this.textureManager.loadTexture("/assets/minecraft/textures/environment/clouds.png").bind();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        float f13 = 0.00390625f;
        float f9 = (float)MathHelper.floor(dx) * f13;
        float f11 = (float)MathHelper.floor(dz) * f13;
        float f14 = (float)(dx - (double)MathHelper.floor(dx));
        float f15 = (float)(dz - (double)MathHelper.floor(dz));
        int cloudWidthScale = 8;
        int radius = 3;
        float f16 = 9.765625E-4f;
        GL11.glScalef((float)cloudWidth, (float)1.0f, (float)cloudWidth);
        float red = rDim + (rSun - rDim) * aSun;
        float green = gDim + (gSun - gDim) * aSun;
        float blue = bDim + (bSun - bDim) * aSun;
        for (int l = 0; l < 2; ++l) {
            if (l == 0) {
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
            } else {
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
            tessellator.startDrawingQuads();
            for (int ix = -radius - 1; ix <= radius; ++ix) {
                for (int iz = -radius - 1; iz <= radius; ++iz) {
                    float f17 = ix * cloudWidthScale;
                    float f18 = iz * cloudWidthScale;
                    float cloudX = f17 - f14;
                    float cloudZ = f18 - f15;
                    if (dy > -cloudThickness - 1.0f) {
                        tessellator.setColorRGBA_F(red * 0.7f, green * 0.7f, blue * 0.7f, 0.8f);
                        tessellator.setNormal(0.0f, -1.0f, 0.0f);
                        tessellator.addVertexWithUV(cloudX + 0.0f, dy + 0.0f, cloudZ + (float)cloudWidthScale, (f17 + 0.0f) * f13 + f9, (f18 + (float)cloudWidthScale) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX + (float)cloudWidthScale, dy + 0.0f, cloudZ + (float)cloudWidthScale, (f17 + (float)cloudWidthScale) * f13 + f9, (f18 + (float)cloudWidthScale) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX + (float)cloudWidthScale, dy + 0.0f, cloudZ + 0.0f, (f17 + (float)cloudWidthScale) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX + 0.0f, dy + 0.0f, cloudZ + 0.0f, (f17 + 0.0f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                    }
                    if (dy <= cloudThickness + 1.0f) {
                        tessellator.setColorRGBA_F(red, green, blue, 0.8f);
                        tessellator.setNormal(0.0f, 1.0f, 0.0f);
                        tessellator.addVertexWithUV(cloudX + 0.0f, dy + cloudThickness - f16, cloudZ + (float)cloudWidthScale, (f17 + 0.0f) * f13 + f9, (f18 + (float)cloudWidthScale) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX + (float)cloudWidthScale, dy + cloudThickness - f16, cloudZ + (float)cloudWidthScale, (f17 + (float)cloudWidthScale) * f13 + f9, (f18 + (float)cloudWidthScale) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX + (float)cloudWidthScale, dy + cloudThickness - f16, cloudZ + 0.0f, (f17 + (float)cloudWidthScale) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX + 0.0f, dy + cloudThickness - f16, cloudZ + 0.0f, (f17 + 0.0f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                    }
                    tessellator.setColorRGBA_F(red * 0.9f, green * 0.9f, blue * 0.9f, 0.8f);
                    if (ix > -1) {
                        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
                        for (int k1 = 0; k1 < cloudWidthScale; ++k1) {
                            tessellator.addVertexWithUV(cloudX + (float)k1 + 0.0f, dy + 0.0f, cloudZ + (float)cloudWidthScale, (f17 + (float)k1 + 0.5f) * f13 + f9, (f18 + (float)cloudWidthScale) * f13 + f11);
                            tessellator.addVertexWithUV(cloudX + (float)k1 + 0.0f, dy + cloudThickness, cloudZ + (float)cloudWidthScale, (f17 + (float)k1 + 0.5f) * f13 + f9, (f18 + (float)cloudWidthScale) * f13 + f11);
                            tessellator.addVertexWithUV(cloudX + (float)k1 + 0.0f, dy + cloudThickness, cloudZ + 0.0f, (f17 + (float)k1 + 0.5f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                            tessellator.addVertexWithUV(cloudX + (float)k1 + 0.0f, dy + 0.0f, cloudZ + 0.0f, (f17 + (float)k1 + 0.5f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                        }
                    }
                    if (ix <= 1) {
                        tessellator.setNormal(1.0f, 0.0f, 0.0f);
                        for (int l1 = 0; l1 < cloudWidthScale; ++l1) {
                            tessellator.addVertexWithUV(cloudX + (float)l1 + 1.0f - f16, dy + 0.0f, cloudZ + (float)cloudWidthScale, (f17 + (float)l1 + 0.5f) * f13 + f9, (f18 + (float)cloudWidthScale) * f13 + f11);
                            tessellator.addVertexWithUV(cloudX + (float)l1 + 1.0f - f16, dy + cloudThickness, cloudZ + (float)cloudWidthScale, (f17 + (float)l1 + 0.5f) * f13 + f9, (f18 + (float)cloudWidthScale) * f13 + f11);
                            tessellator.addVertexWithUV(cloudX + (float)l1 + 1.0f - f16, dy + cloudThickness, cloudZ + 0.0f, (f17 + (float)l1 + 0.5f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                            tessellator.addVertexWithUV(cloudX + (float)l1 + 1.0f - f16, dy + 0.0f, cloudZ + 0.0f, (f17 + (float)l1 + 0.5f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                        }
                    }
                    tessellator.setColorRGBA_F(red * 0.8f, green * 0.8f, blue * 0.8f, 0.8f);
                    if (iz > -1) {
                        tessellator.setNormal(0.0f, 0.0f, -1.0f);
                        for (int i2 = 0; i2 < cloudWidthScale; ++i2) {
                            tessellator.addVertexWithUV(cloudX + 0.0f, dy + cloudThickness, cloudZ + (float)i2 + 0.0f, (f17 + 0.0f) * f13 + f9, (f18 + (float)i2 + 0.5f) * f13 + f11);
                            tessellator.addVertexWithUV(cloudX + (float)cloudWidthScale, dy + cloudThickness, cloudZ + (float)i2 + 0.0f, (f17 + (float)cloudWidthScale) * f13 + f9, (f18 + (float)i2 + 0.5f) * f13 + f11);
                            tessellator.addVertexWithUV(cloudX + (float)cloudWidthScale, dy + 0.0f, cloudZ + (float)i2 + 0.0f, (f17 + (float)cloudWidthScale) * f13 + f9, (f18 + (float)i2 + 0.5f) * f13 + f11);
                            tessellator.addVertexWithUV(cloudX + 0.0f, dy + 0.0f, cloudZ + (float)i2 + 0.0f, (f17 + 0.0f) * f13 + f9, (f18 + (float)i2 + 0.5f) * f13 + f11);
                        }
                    }
                    if (iz > 1) continue;
                    tessellator.setNormal(0.0f, 0.0f, 1.0f);
                    for (int j2 = 0; j2 < cloudWidthScale; ++j2) {
                        tessellator.addVertexWithUV(cloudX + 0.0f, dy + cloudThickness, cloudZ + (float)j2 + 1.0f - f16, (f17 + 0.0f) * f13 + f9, (f18 + (float)j2 + 0.5f) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX + (float)cloudWidthScale, dy + cloudThickness, cloudZ + (float)j2 + 1.0f - f16, (f17 + (float)cloudWidthScale) * f13 + f9, (f18 + (float)j2 + 0.5f) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX + (float)cloudWidthScale, dy + 0.0f, cloudZ + (float)j2 + 1.0f - f16, (f17 + (float)cloudWidthScale) * f13 + f9, (f18 + (float)j2 + 0.5f) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX + 0.0f, dy + 0.0f, cloudZ + (float)j2 + 1.0f - f16, (f17 + 0.0f) * f13 + f9, (f18 + (float)j2 + 0.5f) * f13 + f11);
                    }
                }
            }
            tessellator.draw();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        this.mc.renderer.endRenderClouds(partialTick);
    }

    public boolean updateRenderers(ICamera camera) {
        int renderIndex;
        int numLayers = 2;
        ChunkRendererComparator comparator = new ChunkRendererComparator(camera);
        ChunkRenderer[] chunkRenderers = new ChunkRenderer[2];
        ArrayList<ChunkRenderer> rendererList = null;
        int numChunkRenderersToUpdate = this.chunkRenderersToUpdate.size();
        int renderListSize = 0;
        for (int i = 0; i < numChunkRenderersToUpdate; ++i) {
            ChunkRenderer chunkRenderer = this.chunkRenderersToUpdate.get(i);
            if (chunkRenderer.distanceToCameraSquared(camera) > 256.0f) {
                int layer;
                for (layer = 0; layer < 2 && (chunkRenderers[layer] == null || comparator.compare(chunkRenderers[layer], chunkRenderer) <= 0); ++layer) {
                }
                if (--layer <= 0) continue;
                int i3 = layer;
                while (--i3 != 0) {
                    chunkRenderers[i3 - 1] = chunkRenderers[i3];
                }
                chunkRenderers[layer] = chunkRenderer;
                continue;
            }
            if (rendererList == null) {
                rendererList = new ArrayList<ChunkRenderer>();
            }
            ++renderListSize;
            rendererList.add(chunkRenderer);
            this.chunkRenderersToUpdate.set(i, null);
        }
        if (rendererList != null) {
            if (rendererList.size() > 1) {
                rendererList.sort(comparator);
            }
            for (ChunkRenderer renderer : rendererList) {
                renderer.rebuild();
                renderer.dirty = false;
            }
        }
        int renderersUpdated = 0;
        for (int layer = 1; layer >= 0; --layer) {
            ChunkRenderer renderer = chunkRenderers[layer];
            if (renderer == null) continue;
            if (!renderer.visible && layer != 1) {
                chunkRenderers[layer] = null;
                break;
            }
            renderer.rebuild();
            renderer.dirty = false;
            ++renderersUpdated;
        }
        int setRenders = 0;
        int size = this.chunkRenderersToUpdate.size();
        block5: for (renderIndex = 0; renderIndex != size; ++renderIndex) {
            ChunkRenderer renderer = this.chunkRenderersToUpdate.get(renderIndex);
            if (renderer == null) continue;
            for (int layer = 0; layer < 2; ++layer) {
                if (renderer == chunkRenderers[layer]) continue block5;
            }
            if (setRenders != renderIndex) {
                this.chunkRenderersToUpdate.set(setRenders, renderer);
            }
            ++setRenders;
        }
        while (--renderIndex >= setRenders) {
            this.chunkRenderersToUpdate.remove(renderIndex);
        }
        return numChunkRenderersToUpdate == renderListSize + renderersUpdated;
    }

    public void drawBlockBreaking(ICamera camera, HitResult hitResult, float partialTick) {
        Tessellator tessellator = Tessellator.instance;
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((MathHelper.sin((float)System.currentTimeMillis() / 100.0f) * 0.2f + 0.4f) * 0.5f));
        if (this.damagePartialTime > 0.0f) {
            GL11.glBlendFunc((int)774, (int)768);
            TextureRegistry.blockAtlas.bind();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            GL11.glPushMatrix();
            int k = this.worldObj.getBlockId(hitResult.x, hitResult.y, hitResult.z);
            Block block = k <= 0 ? null : Block.blocksList[k];
            GL11.glDisable((int)3008);
            GL11.glPolygonOffset((float)-3.0f, (float)-3.0f);
            GL11.glEnable((int)32823);
            double x = camera.getX(partialTick);
            double y = camera.getY(partialTick);
            double z = camera.getZ(partialTick);
            if (block == null) {
                block = Blocks.STONE;
            }
            GL11.glEnable((int)3008);
            tessellator.startDrawingQuads();
            tessellator.setTranslation(-x, -y, -z);
            tessellator.lockColor();
            if (LightmapHelper.isLightmapEnabled()) {
                tessellator.setLightmapCoord(LightmapHelper.getLightmapCoord(15, 0));
            }
            BlockModel.setRenderBlocks(this.globalRenderBlocks);
            ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(block)).renderWithOverrideTexture(tessellator, hitResult.x, hitResult.y, hitResult.z, breakingAnimation[MathHelper.clamp((int)(this.damagePartialTime * 10.0f), 0, breakingAnimation.length)]);
            tessellator.draw();
            tessellator.setTranslation(0.0, 0.0, 0.0);
            GL11.glDisable((int)3008);
            GL11.glPolygonOffset((float)0.0f, (float)0.0f);
            GL11.glDisable((int)32823);
            GL11.glEnable((int)3008);
            GL11.glDepthMask((boolean)true);
            GL11.glPopMatrix();
        }
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3008);
    }

    public void drawSelectionBox(ICamera camera, HitResult hitResult, float partialTick) {
        if (this.mc.gameSettings.immersiveMode.drawOutline() && ((Float)this.mc.gameSettings.blockOutlineWidth.value).floatValue() > 0.01f && !(this.mc.currentScreen instanceof ModelViewerScreen)) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            float w = this.mc.getOutlineWidth();
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)(0.35f + w * 0.3f));
            GL11.glLineWidth((float)Math.max(4.0f * w * 2.0f, 1.0f));
            GL11.glDisable((int)3553);
            GL11.glDepthMask((boolean)false);
            double offsetX = camera.getX(partialTick);
            double offsetY = camera.getY(partialTick);
            double offsetZ = camera.getZ(partialTick);
            if (hitResult.hitType == HitResult.HitType.TILE) {
                float expand = 0.002f;
                int j = this.worldObj.getBlockId(hitResult.x, hitResult.y, hitResult.z);
                if (j > 0) {
                    BoundingVolume volume = Block.blocksList[j].getBoundingVolume(this.worldObj, hitResult.x, hitResult.y, hitResult.z);
                    if (volume != null) {
                        this.drawOutlinedVolume(volume, (double)hitResult.x - offsetX, (double)hitResult.y - offsetY, (double)hitResult.z - offsetZ, expand);
                    } else {
                        Block.blocksList[j].setBlockBoundsBasedOnState(this.worldObj, hitResult.x, hitResult.y, hitResult.z);
                        this.drawOutlinedBoundingBox(Block.blocksList[j].getSelectedBoundingBoxFromPool(this.worldObj, hitResult.x, hitResult.y, hitResult.z).grow(expand, expand, expand).cloneMove(-offsetX, -offsetY, -offsetZ));
                    }
                }
            } else if (hitResult.hitType == HitResult.HitType.ENTITY && hitResult.entity.showBoundingBoxOnHover() && !((Boolean)this.mc.gameSettings.showCollisionBoxes.value).booleanValue()) {
                this.drawInterpolatedEntityBoundingBox(hitResult.entity, camera, partialTick);
            }
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
        }
    }

    public void drawDebugEntityOutlines(ICamera camera, float partialTicks) {
        GL11.glDisable((int)3553);
        GL11.glLineWidth((float)2.0f);
        double offsetX = camera.getX(partialTicks);
        double offsetY = camera.getY(partialTicks);
        double offsetZ = camera.getZ(partialTicks);
        float expand = 0.002f;
        List<AABB> collidingBoundingBoxes = this.worldObj.getCubes(this.mc.thePlayer, this.mc.thePlayer.bb.grow(expand, expand, expand));
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        for (AABB aabb : collidingBoundingBoxes) {
            this.drawOutlinedBoundingBox(aabb.cloneMove(-offsetX, -offsetY, -offsetZ).grow(expand, expand, expand));
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float entityRadius = 10.0f;
        if (this.mc.thePlayer.getGamemode() == Gamemode.creative) {
            entityRadius = 100.0f;
        }
        List<Entity> entitiesNearby = this.worldObj.getEntitiesWithinAABBExcludingEntity(this.mc.thePlayer, this.mc.thePlayer.bb.grow(entityRadius, entityRadius, entityRadius));
        for (Entity e : entitiesNearby) {
            this.drawInterpolatedEntityBoundingBox(e, camera, partialTicks);
        }
        GL11.glEnable((int)3553);
    }

    public void drawInterpolatedEntityBoundingBox(Entity entity, ICamera camera, float partialTicks) {
        double cameraX = camera.getX(partialTicks);
        double cameraY = camera.getY(partialTicks);
        double cameraZ = camera.getZ(partialTicks);
        float expand = 0.02f;
        double lerpOffsetX = entity.xo + (entity.x - entity.xo) * (double)partialTicks;
        double lerpOffsetY = entity.yo + (entity.y - entity.yo) * (double)partialTicks;
        double lerpOffsetZ = entity.zo + (entity.z - entity.zo) * (double)partialTicks;
        AABB boundingBox = entity.bb;
        boundingBox = boundingBox.grow(expand, expand, expand);
        boundingBox = boundingBox.cloneMove(-entity.x, -entity.y, -entity.z);
        boundingBox = boundingBox.cloneMove(-cameraX, -cameraY, -cameraZ);
        boundingBox = boundingBox.cloneMove(lerpOffsetX, lerpOffsetY, lerpOffsetZ);
        this.drawOutlinedBoundingBox(boundingBox);
    }

    public void drawDebugChunkBorders(ICamera camera, float partialTicks) {
        int i;
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2912);
        double offsetX = camera.getX(partialTicks);
        double offsetY = camera.getY(partialTicks);
        double offsetZ = camera.getZ(partialTicks);
        Tessellator tessellator = Tessellator.instance;
        tessellator.setTranslation(-offsetX, -offsetY, -offsetZ);
        int blockX = MathHelper.floor(this.mc.thePlayer.x);
        int blockZ = MathHelper.floor(this.mc.thePlayer.z);
        int chunkX = blockX >> 4;
        int chunkZ = blockZ >> 4;
        int x0 = chunkX << 4;
        int z0 = chunkZ << 4;
        int x1 = x0 + 16;
        int z1 = z0 + 16;
        int worldHeight = this.mc.theWorld.getHeightBlocks();
        GL11.glLineWidth((float)2.0f);
        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        tessellator.startDrawing(1);
        for (i = -1; i <= 2; ++i) {
            for (int j = -1; j <= 2; ++j) {
                int x2 = chunkX + i << 4;
                int z2 = chunkZ + j << 4;
                tessellator.addVertex(x2, 0.0, z2);
                tessellator.addVertex(x2, worldHeight, z2);
            }
        }
        tessellator.draw();
        GL11.glLineWidth((float)1.0f);
        GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        tessellator.startDrawing(1);
        for (int y = 0; y <= worldHeight; ++y) {
            if (y % 2 == 1) continue;
            tessellator.addVertex(x0, y, z0);
            tessellator.addVertex(x1, y, z0);
            tessellator.addVertex(x0, y, z1);
            tessellator.addVertex(x1, y, z1);
            tessellator.addVertex(x0, y, z0);
            tessellator.addVertex(x0, y, z1);
            tessellator.addVertex(x1, y, z0);
            tessellator.addVertex(x1, y, z1);
        }
        for (i = 1; i < 16; ++i) {
            if (i % 2 == 1) continue;
            tessellator.addVertex(x0 + i, 0.0, z0);
            tessellator.addVertex(x0 + i, 256.0, z0);
            tessellator.addVertex(x0, 0.0, z0 + i);
            tessellator.addVertex(x0, 256.0, z0 + i);
            tessellator.addVertex(x0 + i, 0.0, z1);
            tessellator.addVertex(x0 + i, 256.0, z1);
            tessellator.addVertex(x1, 0.0, z0 + i);
            tessellator.addVertex(x1, 256.0, z0 + i);
        }
        tessellator.draw();
        tessellator.setTranslation(0.0, 0.0, 0.0);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2912);
    }

    public void drawOutlinedBoundingBox(AABB aabb) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawing(3);
        tessellator.addVertex(aabb.minX, aabb.minY, aabb.minZ);
        tessellator.addVertex(aabb.maxX, aabb.minY, aabb.minZ);
        tessellator.addVertex(aabb.maxX, aabb.minY, aabb.maxZ);
        tessellator.addVertex(aabb.minX, aabb.minY, aabb.maxZ);
        tessellator.addVertex(aabb.minX, aabb.minY, aabb.minZ);
        tessellator.draw();
        tessellator.startDrawing(3);
        tessellator.addVertex(aabb.minX, aabb.maxY, aabb.minZ);
        tessellator.addVertex(aabb.maxX, aabb.maxY, aabb.minZ);
        tessellator.addVertex(aabb.maxX, aabb.maxY, aabb.maxZ);
        tessellator.addVertex(aabb.minX, aabb.maxY, aabb.maxZ);
        tessellator.addVertex(aabb.minX, aabb.maxY, aabb.minZ);
        tessellator.draw();
        tessellator.startDrawing(1);
        tessellator.addVertex(aabb.minX, aabb.minY, aabb.minZ);
        tessellator.addVertex(aabb.minX, aabb.maxY, aabb.minZ);
        tessellator.addVertex(aabb.maxX, aabb.minY, aabb.minZ);
        tessellator.addVertex(aabb.maxX, aabb.maxY, aabb.minZ);
        tessellator.addVertex(aabb.maxX, aabb.minY, aabb.maxZ);
        tessellator.addVertex(aabb.maxX, aabb.maxY, aabb.maxZ);
        tessellator.addVertex(aabb.minX, aabb.minY, aabb.maxZ);
        tessellator.addVertex(aabb.minX, aabb.maxY, aabb.maxZ);
        tessellator.draw();
    }

    public void drawOutlinedVolume(BoundingVolume volume, double xOffset, double yOffset, double zOffset, float expand) {
        Tessellator t = Tessellator.instance;
        t.startDrawing(1);
        Float[] points = volume.getBakedLineCoords();
        for (int i = 0; i < points.length; i += 3) {
            float expand0 = (points[i].floatValue() - 0.5f) * 2.0f * expand;
            float expand1 = (points[i + 1].floatValue() - 0.5f) * 2.0f * expand;
            float expand2 = (points[i + 2].floatValue() - 0.5f) * 2.0f * expand;
            t.addVertex((double)points[i].floatValue() + xOffset + (double)expand0, (double)points[i + 1].floatValue() + yOffset + (double)expand1, (double)points[i + 2].floatValue() + zOffset + (double)expand2);
        }
        t.draw();
    }

    public void markDirty(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        int wrMinX = MathHelper.bucketInt(minX, 16);
        int wrMinY = MathHelper.bucketInt(minY, 16);
        int wrMinZ = MathHelper.bucketInt(minZ, 16);
        int wrMaxX = MathHelper.bucketInt(maxX, 16);
        int wrMaxY = MathHelper.bucketInt(maxY, 16);
        int wrMaxZ = MathHelper.bucketInt(maxZ, 16);
        for (int wrX = wrMinX; wrX <= wrMaxX; ++wrX) {
            int realWrX = wrX % this.renderChunksWide;
            if (realWrX < 0) {
                realWrX += this.renderChunksWide;
            }
            for (int wrY = wrMinY; wrY <= wrMaxY; ++wrY) {
                int realWrY = wrY % this.renderChunksTall;
                if (realWrY < 0) {
                    realWrY += this.renderChunksTall;
                }
                for (int wrZ = wrMinZ; wrZ <= wrMaxZ; ++wrZ) {
                    int realWrZ = wrZ % this.renderChunksDeep;
                    if (realWrZ < 0) {
                        realWrZ += this.renderChunksDeep;
                    }
                    int i = (realWrZ * this.renderChunksTall + realWrY) * this.renderChunksWide + realWrX;
                    ChunkRenderer worldrenderer = this.chunkRenderers[i];
                    if (worldrenderer.dirty) continue;
                    this.chunkRenderersToUpdate.add(worldrenderer);
                    worldrenderer.setDirty();
                }
            }
        }
    }

    @Override
    public void blockChanged(int x, int y, int z) {
        this.markDirty(x - 1, y - 1, z - 1, x + 1, y + 1, z + 1);
    }

    @Override
    public void setBlocksDirty(int x0, int y0, int z0, int x1, int y1, int z1) {
        this.markDirty(x0 - 1, y0 - 1, z0 - 1, x1 + 1, y1 + 1, z1 + 1);
    }

    public void clipRenderersByFrustum(CameraFrustum frustum, float partialTick) {
        for (int i = 0; i < this.chunkRenderers.length; ++i) {
            if (this.chunkRenderers[i].isEmpty() || this.chunkRenderers[i].visible && (i + this.frustumCheckOffset & 0xF) != 0) continue;
            this.chunkRenderers[i].cull(frustum, partialTick);
        }
        ++this.frustumCheckOffset;
    }

    @Override
    public void playStreamingMusic(String soundPath, String author, int x, int y, int z) {
        if (soundPath != null) {
            if (author != null && !author.isEmpty()) {
                this.mc.ingameHud.setRecordPlayingMessage(author + " - " + I18n.getInstance().translateKey(soundPath));
            } else {
                this.mc.ingameHud.setRecordPlayingMessage(I18n.getInstance().translateKey(soundPath));
            }
        }
        this.mc.sndManager.playMusic(soundPath, (float)x, (float)y, (float)z, 1.0f, 1.0f);
    }

    @Override
    public void playSound(Entity player, String soundPath, SoundCategory category, double x, double y, double z, float volume, float pitch) {
        this.mc.sndManager.playSoundAt(soundPath, category, (float)x, (float)y, (float)z, volume, pitch);
    }

    @Override
    public void addParticle(String particleKey, double x, double y, double z, double motionX, double motionY, double motionZ, int data) {
        this.addParticle(particleKey, x, y, z, motionX, motionY, motionZ, data, 16.0);
    }

    @Override
    public void addParticle(String particleId, double x, double y, double z, double motionX, double motionY, double motionZ, int data, double maxDistance) {
        double d8;
        double d7;
        if (this.mc == null || this.mc.activeCamera == null || this.mc.particleEngine == null) {
            return;
        }
        double d6 = this.mc.activeCamera.getX() - x;
        if (d6 * d6 + (d7 = this.mc.activeCamera.getY() - y) * d7 + (d8 = this.mc.activeCamera.getZ() - z) * d8 > maxDistance * maxDistance) {
            return;
        }
        Particle fx = ((ParticleLambda)ParticleDispatcher.getInstance().getDispatch(particleId)).newParticle(this.worldObj, x, y, z, motionX, motionY, motionZ, data);
        if (fx != null) {
            this.mc.particleEngine.add(fx);
        }
    }

    @Override
    public void allChanged(boolean lightChanged, boolean seasonChanged) {
        if (seasonChanged) {
            Colorizers.update(false);
        }
        if (seasonChanged || lightChanged && !LightmapHelper.isLightmapEnabled()) {
            for (ChunkRenderer chunkRenderer : this.chunkRenderers) {
                if (!chunkRenderer.skyLit || chunkRenderer.dirty) continue;
                this.chunkRenderersToUpdate.add(chunkRenderer);
                chunkRenderer.setDirty();
            }
        }
    }

    @Override
    public void tileEntityChanged(int x, int y, int z, BlockEntity blockEntity) {
    }

    public void deleteRenderListBase() {
        if (this.glRenderListBase >= 0) {
            GLAllocation.deleteDisplayList(this.glRenderListBase);
        }
    }

    @Override
    public void levelEvent(Player player, int id, int x, int y, int z, int data) {
        Random random = this.worldObj.rand;
        switch (id) {
            default: {
                break;
            }
            case 1001: {
                this.worldObj.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, x, y, z, "random.click", 1.0f, 1.2f);
                break;
            }
            case 1000: {
                this.worldObj.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, x, y, z, "random.click", 1.0f, 1.0f);
                break;
            }
            case 1002: {
                this.worldObj.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, x, y, z, "random.bow", 1.0f, 1.2f);
                break;
            }
            case 2000: {
                int j1 = data % 3 - 1;
                int k1 = data / 3 % 3 - 1;
                double d = (double)x + (double)j1 * 0.6 + 0.5;
                double d1 = (double)y + 0.5;
                double d2 = (double)z + (double)k1 * 0.6 + 0.5;
                for (int l1 = 0; l1 < 10; ++l1) {
                    double d3 = random.nextDouble() * 0.2 + 0.01;
                    double d4 = d + (double)j1 * 0.01 + (random.nextDouble() - 0.5) * (double)k1 * 0.5;
                    double d5 = d1 + (random.nextDouble() - 0.5) * 0.5;
                    double d6 = d2 + (double)k1 * 0.01 + (random.nextDouble() - 0.5) * (double)j1 * 0.5;
                    double d7 = (double)j1 * d3 + random.nextGaussian() * 0.01;
                    double d8 = -0.03 + random.nextGaussian() * 0.01;
                    double d9 = (double)k1 * d3 + random.nextGaussian() * 0.01;
                    this.addParticle("smoke", d4, d5, d6, d7, d8, d9, 0);
                }
                break;
            }
            case 2001: {
                if (data > 0) {
                    Block block = Block.blocksList[data];
                    this.worldObj.playBlockSoundEffect(null, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, block, EnumBlockSoundEffectType.MINE);
                }
                this.mc.particleEngine.destroy(x, y, z, data, this.worldObj.getBlockMetadata(x, y, z));
                break;
            }
            case 1003: {
                if (Math.random() < 0.5) {
                    this.worldObj.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.door_open", 1.0f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
                    break;
                }
                this.worldObj.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.door_close", 1.0f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case 1004: {
                this.worldObj.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, "random.fizz", 0.5f, 2.6f + (random.nextFloat() - random.nextFloat()) * 0.8f);
                break;
            }
            case 1005: {
                if (Item.itemsList[data] instanceof MusicDiscItem) {
                    MusicDiscItem record = (MusicDiscItem)Item.itemsList[data];
                    this.worldObj.playRecord(record.recordName, record.recordAuthor, x, y, z);
                    break;
                }
                this.worldObj.playRecord(null, null, x, y, z);
                break;
            }
            case 1006: {
                this.worldObj.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.out", 0.5f, this.worldObj.rand.nextFloat() * 0.25f + 0.6f);
                break;
            }
            case 1007: {
                this.worldObj.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.in", 0.5f, this.worldObj.rand.nextFloat() * 0.25f + 0.6f);
            }
        }
    }

    @Override
    public void entityAdded(Entity entity) {
    }

    @Override
    public void entityRemoved(Entity entity) {
    }

    static {
        for (int i = 0; i < breakingAnimation.length; ++i) {
            RenderGlobal.breakingAnimation[i] = TextureRegistry.getTexture("minecraft:block/breaking_" + i);
        }
    }
}

