/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.culling;

import java.nio.FloatBuffer;
import net.minecraft.client.GLAllocation;
import net.minecraft.client.render.culling.FrustumData;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;

public class Frustum
extends FrustumData {
    private static final Frustum FRUSTUM = new Frustum();
    private final FloatBuffer _proj = GLAllocation.createDirectFloatBuffer(16);
    private final FloatBuffer _modl = GLAllocation.createDirectFloatBuffer(16);
    private final FloatBuffer _clip = GLAllocation.createDirectFloatBuffer(16);

    public static FrustumData getFrustum() {
        FRUSTUM.calculateFrustum();
        return FRUSTUM;
    }

    private void normalizePlane(float[][] af, int i) {
        float f = MathHelper.sqrt_float(af[i][0] * af[i][0] + af[i][1] * af[i][1] + af[i][2] * af[i][2]);
        float[] fArray = af[i];
        fArray[0] = fArray[0] / f;
        float[] fArray2 = af[i];
        fArray2[1] = fArray2[1] / f;
        float[] fArray3 = af[i];
        fArray3[2] = fArray3[2] / f;
        float[] fArray4 = af[i];
        fArray4[3] = fArray4[3] / f;
    }

    private void calculateFrustum() {
        this._proj.clear();
        this._modl.clear();
        this._clip.clear();
        GL11.glGetFloatv((int)2983, (FloatBuffer)this._proj);
        GL11.glGetFloatv((int)2982, (FloatBuffer)this._modl);
        this._proj.flip().limit(16);
        this._proj.get(this.projectionMatrix);
        this._modl.flip().limit(16);
        this._modl.get(this.modelViewMatrix);
        this.clip[0] = this.modelViewMatrix[0] * this.projectionMatrix[0] + this.modelViewMatrix[1] * this.projectionMatrix[4] + this.modelViewMatrix[2] * this.projectionMatrix[8] + this.modelViewMatrix[3] * this.projectionMatrix[12];
        this.clip[1] = this.modelViewMatrix[0] * this.projectionMatrix[1] + this.modelViewMatrix[1] * this.projectionMatrix[5] + this.modelViewMatrix[2] * this.projectionMatrix[9] + this.modelViewMatrix[3] * this.projectionMatrix[13];
        this.clip[2] = this.modelViewMatrix[0] * this.projectionMatrix[2] + this.modelViewMatrix[1] * this.projectionMatrix[6] + this.modelViewMatrix[2] * this.projectionMatrix[10] + this.modelViewMatrix[3] * this.projectionMatrix[14];
        this.clip[3] = this.modelViewMatrix[0] * this.projectionMatrix[3] + this.modelViewMatrix[1] * this.projectionMatrix[7] + this.modelViewMatrix[2] * this.projectionMatrix[11] + this.modelViewMatrix[3] * this.projectionMatrix[15];
        this.clip[4] = this.modelViewMatrix[4] * this.projectionMatrix[0] + this.modelViewMatrix[5] * this.projectionMatrix[4] + this.modelViewMatrix[6] * this.projectionMatrix[8] + this.modelViewMatrix[7] * this.projectionMatrix[12];
        this.clip[5] = this.modelViewMatrix[4] * this.projectionMatrix[1] + this.modelViewMatrix[5] * this.projectionMatrix[5] + this.modelViewMatrix[6] * this.projectionMatrix[9] + this.modelViewMatrix[7] * this.projectionMatrix[13];
        this.clip[6] = this.modelViewMatrix[4] * this.projectionMatrix[2] + this.modelViewMatrix[5] * this.projectionMatrix[6] + this.modelViewMatrix[6] * this.projectionMatrix[10] + this.modelViewMatrix[7] * this.projectionMatrix[14];
        this.clip[7] = this.modelViewMatrix[4] * this.projectionMatrix[3] + this.modelViewMatrix[5] * this.projectionMatrix[7] + this.modelViewMatrix[6] * this.projectionMatrix[11] + this.modelViewMatrix[7] * this.projectionMatrix[15];
        this.clip[8] = this.modelViewMatrix[8] * this.projectionMatrix[0] + this.modelViewMatrix[9] * this.projectionMatrix[4] + this.modelViewMatrix[10] * this.projectionMatrix[8] + this.modelViewMatrix[11] * this.projectionMatrix[12];
        this.clip[9] = this.modelViewMatrix[8] * this.projectionMatrix[1] + this.modelViewMatrix[9] * this.projectionMatrix[5] + this.modelViewMatrix[10] * this.projectionMatrix[9] + this.modelViewMatrix[11] * this.projectionMatrix[13];
        this.clip[10] = this.modelViewMatrix[8] * this.projectionMatrix[2] + this.modelViewMatrix[9] * this.projectionMatrix[6] + this.modelViewMatrix[10] * this.projectionMatrix[10] + this.modelViewMatrix[11] * this.projectionMatrix[14];
        this.clip[11] = this.modelViewMatrix[8] * this.projectionMatrix[3] + this.modelViewMatrix[9] * this.projectionMatrix[7] + this.modelViewMatrix[10] * this.projectionMatrix[11] + this.modelViewMatrix[11] * this.projectionMatrix[15];
        this.clip[12] = this.modelViewMatrix[12] * this.projectionMatrix[0] + this.modelViewMatrix[13] * this.projectionMatrix[4] + this.modelViewMatrix[14] * this.projectionMatrix[8] + this.modelViewMatrix[15] * this.projectionMatrix[12];
        this.clip[13] = this.modelViewMatrix[12] * this.projectionMatrix[1] + this.modelViewMatrix[13] * this.projectionMatrix[5] + this.modelViewMatrix[14] * this.projectionMatrix[9] + this.modelViewMatrix[15] * this.projectionMatrix[13];
        this.clip[14] = this.modelViewMatrix[12] * this.projectionMatrix[2] + this.modelViewMatrix[13] * this.projectionMatrix[6] + this.modelViewMatrix[14] * this.projectionMatrix[10] + this.modelViewMatrix[15] * this.projectionMatrix[14];
        this.clip[15] = this.modelViewMatrix[12] * this.projectionMatrix[3] + this.modelViewMatrix[13] * this.projectionMatrix[7] + this.modelViewMatrix[14] * this.projectionMatrix[11] + this.modelViewMatrix[15] * this.projectionMatrix[15];
        this.frustumData[0][0] = this.clip[3] - this.clip[0];
        this.frustumData[0][1] = this.clip[7] - this.clip[4];
        this.frustumData[0][2] = this.clip[11] - this.clip[8];
        this.frustumData[0][3] = this.clip[15] - this.clip[12];
        this.normalizePlane(this.frustumData, 0);
        this.frustumData[1][0] = this.clip[3] + this.clip[0];
        this.frustumData[1][1] = this.clip[7] + this.clip[4];
        this.frustumData[1][2] = this.clip[11] + this.clip[8];
        this.frustumData[1][3] = this.clip[15] + this.clip[12];
        this.normalizePlane(this.frustumData, 1);
        this.frustumData[2][0] = this.clip[3] + this.clip[1];
        this.frustumData[2][1] = this.clip[7] + this.clip[5];
        this.frustumData[2][2] = this.clip[11] + this.clip[9];
        this.frustumData[2][3] = this.clip[15] + this.clip[13];
        this.normalizePlane(this.frustumData, 2);
        this.frustumData[3][0] = this.clip[3] - this.clip[1];
        this.frustumData[3][1] = this.clip[7] - this.clip[5];
        this.frustumData[3][2] = this.clip[11] - this.clip[9];
        this.frustumData[3][3] = this.clip[15] - this.clip[13];
        this.normalizePlane(this.frustumData, 3);
        this.frustumData[4][0] = this.clip[3] - this.clip[2];
        this.frustumData[4][1] = this.clip[7] - this.clip[6];
        this.frustumData[4][2] = this.clip[11] - this.clip[10];
        this.frustumData[4][3] = this.clip[15] - this.clip[14];
        this.normalizePlane(this.frustumData, 4);
        this.frustumData[5][0] = this.clip[3] + this.clip[2];
        this.frustumData[5][1] = this.clip[7] + this.clip[6];
        this.frustumData[5][2] = this.clip[11] + this.clip[10];
        this.frustumData[5][3] = this.clip[15] + this.clip[14];
        this.normalizePlane(this.frustumData, 5);
    }
}

