/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.dynamictexture;

import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.dynamictexture.DynamicTextureRotating;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;

public class DynamicTextureTrommel
extends DynamicTextureRotating {
    private boolean counterClockwise;
    private double rotation = 0.0;
    private double speed = 0.12;

    public DynamicTextureTrommel(Minecraft minecraft, IconCoordinate textureIndex, boolean counterClockwise) {
        super(minecraft, textureIndex);
        this.counterClockwise = counterClockwise;
    }

    @Override
    public void postInit() {
        this.initTexture();
        BufferedImage atlasImage = this.targetTexture.parentAtlas.atlas;
        IconCoordinate foreground = TextureRegistry.getTexture("minecraft:block/trommel_active_front_foreground");
        this.dialImageData = new byte[foreground.getArea() * 4];
        for (int x = 0; x < foreground.width; ++x) {
            for (int y = 0; y < foreground.height; ++y) {
                DynamicTextureTrommel.putPixel(this.dialImageData, y * foreground.width + x, atlasImage.getRGB(foreground.iconX + x, foreground.iconY + y));
            }
        }
        this.dialTexRes = foreground.width;
        IconCoordinate background = TextureRegistry.getTexture("minecraft:block/trommel_active_front_background");
        this.clockImageData = new byte[background.getArea() * 4];
        for (int x = 0; x < background.width; ++x) {
            for (int y = 0; y < background.height; ++y) {
                DynamicTextureTrommel.putPixel(this.clockImageData, y * background.width + x, atlasImage.getRGB(background.iconX + x, background.iconY + y));
            }
        }
    }

    @Override
    public double getAngle() {
        return 0.0;
    }

    @Override
    public void updateAngle() {
        if (this.counterClockwise) {
            this.rotation -= this.speed;
            if (this.rotation < 0.0) {
                this.rotation += Math.PI * 2;
            }
        } else {
            this.rotation += this.speed;
            if (this.rotation > Math.PI * 2) {
                this.rotation -= Math.PI * 2;
            }
        }
        this.angleFinal = this.rotation;
    }
}

