/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.EntityBlock;
import net.minecraft.core.block.entity.BasketBlockEntity;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BasketBlock
extends EntityBlock {
    protected BasketBlock(String blockName, String namespaceId, int id, Material material) {
        super(blockName, namespaceId, id, material);
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player entityplayer, Side side, double xPlaced, double yPlaced) {
        BasketBlockEntity te = (BasketBlockEntity)world.getBlockEntity(x, y, z);
        if (te.getNumUnitsInside() > 0) {
            te.givePlayerAllItems(world, entityplayer);
            return true;
        }
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    protected BlockEntity getNewBlockEntity() {
        return new BasketBlockEntity();
    }

    public int getFillLevel(WorldSource world, int x, int y, int z) {
        BasketBlockEntity te = (BasketBlockEntity)world.getBlockEntity(x, y, z);
        float fill = (float)te.getNumUnitsInside() / (float)te.getMaxUnits();
        return (int)Math.ceil(10.0f * fill);
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isSignalSource() {
        return true;
    }

    @Override
    public boolean getDirectSignal(World world, int x, int y, int z, Side side) {
        return this.getSignal(world, x, y, z, side);
    }

    @Override
    public boolean getSignal(WorldSource worldSource, int x, int y, int z, Side side) {
        BasketBlockEntity basketTileEntity = (BasketBlockEntity)worldSource.getBlockEntity(x, y, z);
        if (basketTileEntity != null) {
            return basketTileEntity.getNumUnitsInside() == basketTileEntity.getMaxUnits();
        }
        return false;
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, BlockEntity blockEntity) {
        return new ItemStack[]{new ItemStack(Items.BASKET)};
    }
}

