/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.FullRotatableBlock;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class BoneShaleBlock
extends FullRotatableBlock {
    public BoneShaleBlock(String translationKey, String namespaceId, int id, Material material) {
        super(translationKey, namespaceId, id, material);
    }

    @Override
    public float blockStrength(World world, int x, int y, int z, Side side, Player player) {
        float blockHardness = this.blockHardness;
        int meta = world.getBlockMetadata(x, y, z);
        Direction direction = FullRotatableBlock.metaToDirection(meta);
        if (side != direction.getSide()) {
            blockHardness *= 66.6f;
        }
        if (!player.canHarvestBlock(this)) {
            return 1.0f / blockHardness / 30.0f;
        }
        return player.getCurrentPlayerStrVsBlock(this) / blockHardness / 30.0f;
    }
}

