/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class FarmlandBlock
extends Block
implements IBonemealable {
    public FarmlandBlock(String key, String namespaceId, int id) {
        super(key, namespaceId, id, Material.dirt);
        this.setTicking(true);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);
        this.withLightBlock(255);
    }

    public static boolean isWet(int data) {
        return (data & 0xF) > 0;
    }

    public static int setWet(int data, int amount) {
        return amount & 0xF | data & 0xF0;
    }

    public static boolean isFertilized(int data) {
        return (data & 0x10) > 0;
    }

    public static int setFertilized(int data, boolean fertilized) {
        int f = fertilized ? 16 : 0;
        return data & 0xF | f;
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        return AABB.getTemporaryBB(x + 0, y + 0, z + 0, x + 1, y + 1, z + 1);
    }

    @Override
    public void setBlockBoundsBasedOnState(WorldSource world, int x, int y, int z) {
        Material material = world.getBlockMaterial(x, y + 1, z);
        if (material == Material.vegetable) {
            this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        } else {
            this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);
        }
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, BlockEntity blockEntity) {
        switch (dropCause) {
            case SILK_TOUCH: 
            case PICK_BLOCK: {
                return new ItemStack[]{new ItemStack(this)};
            }
        }
        if (FarmlandBlock.isWet(world.getBlockMetadata(x, y, z))) {
            return new ItemStack[]{new ItemStack(Blocks.MUD)};
        }
        return new ItemStack[]{new ItemStack(Blocks.DIRT)};
    }

    private boolean isCropsNearby(World world, int x, int y, int z) {
        boolean radius = false;
        for (int ix = x - 0; ix <= x + 0; ++ix) {
            for (int iz = z - 0; iz <= z + 0; ++iz) {
                if (world.getBlockId(ix, y + 1, iz) != Blocks.CROPS_WHEAT.id) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    private boolean isWaterNearby(World world, int x, int y, int z) {
        for (int ix = x - 4; ix <= x + 4; ++ix) {
            for (int iy = y; iy <= y + 1; ++iy) {
                for (int iz = z - 4; iz <= z + 4; ++iz) {
                    if (!Block.hasTag(world.getBlockId(ix, iy, iz), BlockTags.IS_WATER)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void onEntityWalking(World world, int x, int y, int z, Entity entity) {
        if (world.rand.nextInt(4) == 0 && entity instanceof Player) {
            if (((Player)entity).inventory.armorInventory[0] != null && ((Player)entity).inventory.armorInventory[0].getItem() == Items.ARMOR_BOOTS_LEATHER) {
                return;
            }
            if (FarmlandBlock.isWet(world.getBlockMetadata(x, y, z))) {
                world.setBlockWithNotify(x, y, z, Blocks.MUD.id);
            } else {
                world.setBlockWithNotify(x, y, z, Blocks.DIRT.id);
            }
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        super.onNeighborBlockChange(world, x, y, z, blockId);
        Material material = world.getBlockMaterial(x, y + 1, z);
        if (material.isSolid() && material != Material.vegetable) {
            if (FarmlandBlock.isWet(world.getBlockMetadata(x, y, z))) {
                world.setBlockWithNotify(x, y, z, Blocks.MUD.id);
            } else {
                world.setBlockWithNotify(x, y, z, Blocks.DIRT.id);
            }
        }
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (rand.nextInt(5) == 0) {
            int data = world.getBlockMetadata(x, y, z);
            if (this.isWaterNearby(world, x, y, z) || world.canBlockBeRainedOn(x, y + 1, z)) {
                world.setBlockMetadataWithNotify(x, y, z, data | 7);
            } else if (FarmlandBlock.isWet(data)) {
                int newData = (data & 0xF) - 1 | data & 0xF0;
                world.setBlockMetadataWithNotify(x, y, z, newData);
            } else if (!this.isCropsNearby(world, x, y, z)) {
                world.setBlockWithNotify(x, y, z, Blocks.DIRT.id);
            }
        }
    }

    @Override
    public boolean onBonemealUsed(ItemStack itemstack, Player entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        int data = world.getBlockMetadata(blockX, blockY, blockZ);
        if (!FarmlandBlock.isFertilized(data)) {
            world.setBlockMetadataWithNotify(blockX, blockY, blockZ, FarmlandBlock.setFertilized(data, true));
            return true;
        }
        return false;
    }
}

