/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.IPainted;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class LampBlock
extends Block
implements IPainted {
    public boolean isActive;

    public LampBlock(String key, String namespaceId, int id, boolean isActivated) {
        super(key, namespaceId, id, Material.stone);
        this.isActive = isActivated;
    }

    @Override
    public void onBlockPlacedByMob(World world, int x, int y, int z, Side side, Mob mob, double sideHeight) {
        boolean hasSignal;
        if (world.isClientSide) {
            return;
        }
        boolean bl = hasSignal = world.hasDirectSignal(x, y, z) || world.hasNeighborSignal(x, y, z);
        if (hasSignal && !this.isActive) {
            world.setBlockAndMetadataWithNotify(x, y, z, Blocks.LAMP_ACTIVE.id, world.getBlockMetadata(x, y, z));
        } else if (!hasSignal && this.isActive) {
            world.setBlockAndMetadataWithNotify(x, y, z, Blocks.LAMP_IDLE.id, world.getBlockMetadata(x, y, z));
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        boolean hasSignal;
        boolean bl = hasSignal = world.hasDirectSignal(x, y, z) || world.hasNeighborSignal(x, y, z);
        if (hasSignal && !this.isActive) {
            world.setBlockAndMetadataWithNotify(x, y, z, Blocks.LAMP_ACTIVE.id, world.getBlockMetadata(x, y, z));
        } else if (!hasSignal && this.isActive) {
            world.setBlockAndMetadataWithNotify(x, y, z, Blocks.LAMP_IDLE.id, world.getBlockMetadata(x, y, z));
        }
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, BlockEntity blockEntity) {
        return new ItemStack[]{new ItemStack(Blocks.LAMP_IDLE, 1, meta)};
    }

    @Override
    public DyeColor fromMetadata(int meta) {
        return DyeColor.colorFromBlockMeta(meta & 0xF);
    }

    @Override
    public int toMetadata(DyeColor color) {
        return color.blockMeta;
    }

    @Override
    public int stripColorFromMetadata(int meta) {
        return 0;
    }

    @Override
    public void removeDye(World world, int x, int y, int z) {
        world.setBlockMetadataWithNotify(x, y, z, 0);
    }
}

