/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public abstract class RotatableBlock
extends Block {
    public RotatableBlock(String key, String namespaceId, int id, Material material) {
        super(key, namespaceId, id, material);
    }

    public void setDefaultDirection(World world, int x, int y, int z) {
        if (world.isClientSide) {
            return;
        }
        int idNegZ = world.getBlockId(x, y, z - 1);
        int idPosZ = world.getBlockId(x, y, z + 1);
        int idNegX = world.getBlockId(x - 1, y, z);
        int idPosX = world.getBlockId(x + 1, y, z);
        int byte0 = 3;
        if (Block.solid[idNegZ] && !Block.solid[idPosZ]) {
            byte0 = 3;
        }
        if (Block.solid[idPosZ] && !Block.solid[idNegZ]) {
            byte0 = 2;
        }
        if (Block.solid[idNegX] && !Block.solid[idPosX]) {
            byte0 = 5;
        }
        if (Block.solid[idPosX] && !Block.solid[idNegX]) {
            byte0 = 4;
        }
        world.setBlockMetadataWithNotify(x, y, z, byte0);
    }

    public static int getOrientation(int i) {
        return i & 7;
    }

    @Override
    public void onBlockPlacedByMob(World world, int x, int y, int z, Side side, Mob mob, double sideHeight) {
        world.setBlockMetadataWithNotify(x, y, z, mob.getHorizontalPlacementDirection(side).getOpposite().getId());
    }

    @Override
    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
        super.onBlockPlacedByWorld(world, x, y, z);
        this.setDefaultDirection(world, x, y, z);
    }
}

