/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.EntityBlock;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.entity.SeatBlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class SeatBlock
extends EntityBlock {
    public SeatBlock(String key, String namespaceId, int id) {
        super(key, namespaceId, id, Material.wood);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.5625, 1.0);
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        SeatBlockEntity tileEntity;
        if (world.isBlockNormalCube(x, y + 1, z)) {
            return false;
        }
        if (!world.isClientSide && (tileEntity = (SeatBlockEntity)world.getBlockEntity(x, y, z)).getPassenger() == null) {
            player.startRiding(tileEntity);
        }
        return true;
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        SeatBlockEntity tileEntity;
        if (!world.isClientSide && (tileEntity = (SeatBlockEntity)world.getBlockEntity(x, y, z)) != null && tileEntity.getPassenger() != null) {
            tileEntity.ejectRider();
        }
        super.onBlockRemoved(world, x, y, z, data);
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    protected BlockEntity getNewBlockEntity() {
        return new SeatBlockEntity();
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, BlockEntity blockEntity) {
        if (dropCause != EnumDropCause.IMPROPER_TOOL) {
            return new ItemStack[]{new ItemStack(Items.SEAT)};
        }
        return null;
    }
}

