/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.entity;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.entity.ItemEntity;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import net.minecraft.core.world.save.conversion.ChunkConverter;

public class JukeboxBlockEntity
extends BlockEntity {
    public int record;

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.record = nbttagcompound.getInteger("Record");
        byte expanded = nbttagcompound.getByte("Expanded");
        if (expanded == 0 && this.record >= 256) {
            this.record += Block.blocksList.length - 256;
        }
        if (this.record < Block.blocksList.length) {
            short[] id = new short[]{(short)this.record};
            byte[] meta = new byte[]{0};
            ChunkConverter.converters[0].convertBlocksAndMetadata(id, meta);
            this.record = id[0];
        }
    }

    @Override
    public void writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        if (this.record > 0) {
            nbttagcompound.putInt("Record", this.record);
            nbttagcompound.putByte("Expanded", (byte)1);
        }
    }

    @Override
    public void dropContents(World world, int x, int y, int z) {
        if (this.record != 0) {
            float f = 0.7f;
            double d = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.2 + 0.6;
            double d2 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            ItemEntity item = new ItemEntity(world, (double)x + d, (double)y + d1, (double)z + d2, new ItemStack(this.record, 1, 0));
            item.pickupDelay = 10;
            world.entityJoinedWorld(item);
            world.playSoundEffect(1005, x, y, z, 0);
            world.playRecord(null, null, x, y, z);
            this.record = 0;
            this.setChanged();
            world.setBlockMetadataWithNotify(x, y, z, 0);
        }
    }
}

