/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.SandBlock;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;

public class FallingBlockEntity
extends Entity {
    public int blockID;
    public int blockMeta;
    @Nullable
    public BlockEntity blockEntity;
    public int fallTime;
    public boolean hasRemovedBlock = false;

    public FallingBlockEntity(World world) {
        super(world);
        this.blockID = Blocks.SAND.id;
        this.fallTime = 0;
    }

    public FallingBlockEntity(World world, double x, double y, double z, int blockId, int blockMeta, @Nullable BlockEntity blockEntity) {
        super(world);
        this.fallTime = 0;
        this.blockID = blockId;
        this.blockMeta = blockMeta;
        this.blockEntity = blockEntity;
        this.blocksBuilding = true;
        this.setSize(0.98f, 0.98f);
        this.heightOffset = this.bbHeight / 2.0f;
        this.setPos(x, y, z);
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    @Override
    protected boolean makeStepSound() {
        return false;
    }

    @Override
    protected void defineSynchedData() {
    }

    @Override
    public boolean isPickable() {
        return !this.removed;
    }

    @Override
    public void tick() {
        if (this.blockID == 0) {
            this.remove();
            return;
        }
        this.pushTime *= 0.98f;
        if (this.pushTime < 0.05f || (double)this.pushTime < 0.25 && this.onGround) {
            this.pushTime = 0.0f;
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if ((double)this.pushTime < 0.05 && this.yd <= 0.0) {
            ++this.fallTime;
        }
        this.yd -= 0.04;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.98;
        this.yd *= 0.98;
        this.zd *= 0.98;
        int x = MathHelper.floor(this.x);
        int y = MathHelper.floor(this.y);
        int z = MathHelper.floor(this.z);
        if (this.world.getBlockId(x, y, z) == this.blockID && !this.hasRemovedBlock) {
            this.world.setBlockWithNotify(x, y, z, 0);
            this.hasRemovedBlock = true;
        }
        if (this.onGround) {
            Block blockBelow = this.world.getBlock(x, y - 1, z);
            double friction = blockBelow == null ? 0.98 : (double)(blockBelow.friction * 0.91f);
            this.xd *= friction;
            this.zd *= friction;
            this.yd *= -0.5;
            this.pushTime *= (float)friction;
        }
        if ((double)this.pushTime < 0.05) {
            if (this.onGround) {
                this.remove();
                if (!(this.world.canBlockBePlacedAt(this.blockID, x, y, z, true, Side.TOP) && !SandBlock.canFallBelow(this.world, x, y - 1, z) && this.world.setBlock(x, y, z, this.blockID) || this.world.isClientSide)) {
                    if (this.hasRemovedBlock) {
                        this.drop();
                    }
                } else if (!this.world.isClientSide) {
                    this.world.setBlockMetadata(x, y, z, this.blockMeta);
                    this.world.notifyBlockChange(x, y, z, this.blockID);
                    if (this.blockEntity != null) {
                        BlockEntity oldEnt = this.world.getBlockEntity(x, y, z);
                        if (oldEnt != null) {
                            oldEnt.invalidate();
                        }
                        this.blockEntity.validate();
                        this.blockEntity.x = x;
                        this.blockEntity.y = y;
                        this.blockEntity.z = z;
                        this.world.replaceBlockTileEntity(x, y, z, this.blockEntity);
                    }
                }
            } else if (this.fallTime > 100 && !this.world.isClientSide) {
                if (this.hasRemovedBlock) {
                    this.drop();
                }
                this.remove();
            }
        }
    }

    public void drop() {
        this.spawnAtLocation(new ItemStack(this.blockID, 1, this.blockMeta), 0.0f);
        if (this.blockEntity != null) {
            int x = MathHelper.floor(this.x);
            int y = MathHelper.floor(this.y);
            int z = MathHelper.floor(this.z);
            this.blockEntity.dropContents(this.world, x, y, z);
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putShort("Tile", (short)this.blockID);
        tag.putShort("TileData", (short)this.blockMeta);
        if (this.blockEntity != null) {
            CompoundTag entityTag = new CompoundTag();
            this.blockEntity.writeToNBT(entityTag);
            tag.putCompound("TileEntity", entityTag);
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        this.blockID = tag.getShort("Tile") & 0x3FFF;
        this.blockMeta = tag.getShort("TileData") & 0xFF;
        if (tag.containsKey("TileEntity")) {
            this.blockEntity = BlockEntity.createAndLoadEntity(tag.getCompound(""));
        }
    }

    @Override
    public float getShadowHeightOffs() {
        return 0.0f;
    }

    public World getWorld() {
        return this.world;
    }

    @Override
    public boolean showBoundingBoxOnHover() {
        return true;
    }
}

