/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.monster;

import com.mojang.nbt.CompoundTag;
import java.util.List;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.monster.Enemy;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;

public class SlimeMob
extends Mob
implements Enemy {
    public static final int DATA_SLIME_SIZE = 16;
    public float squish;
    public float oSquish;
    private int jumpDelay = 0;
    private final boolean hasSlimeSplit;
    private boolean sizeSet = false;

    public SlimeMob(World world) {
        super(world);
        this.textureIdentifier = new NamespaceID("minecraft", "slime");
        this.heightOffset = 0.0f;
        this.jumpDelay = 20;
        this.scoreValue = 100;
        this.hasSlimeSplit = false;
        this.mobDrops.add(new WeightedRandomLootObject(Items.SLIMEBALL.getDefaultStack(), 0, 2));
    }

    public SlimeMob(World world, boolean isSplit) {
        super(world);
        this.textureIdentifier = new NamespaceID("minecraft", "slime");
        this.heightOffset = 0.0f;
        this.jumpDelay = 20;
        this.scoreValue = 100;
        this.hasSlimeSplit = isSplit;
        this.mobDrops.add(new WeightedRandomLootObject(Items.SLIMEBALL.getDefaultStack(), 0, 2));
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(16, (byte)1, Byte.class);
    }

    @Override
    public void spawnInit() {
        super.defineSynchedData();
        if (!this.hasSlimeSplit) {
            int size = this.random.nextInt(3) + 1;
            if (size == 3) {
                size = 4;
            }
            this.setSlimeSize(size);
        }
    }

    public void setSlimeSize(int i) {
        this.entityData.set(16, (byte)i);
        this.setSize(0.5f * (float)i, 0.5f * (float)i);
        this.setHealthRaw(this.getMaxHealth());
        this.setPos(this.x, this.y, this.z);
    }

    @Override
    public int getMaxHealth() {
        return this.getSlimeSize() * this.getSlimeSize();
    }

    public int getSlimeSize() {
        return this.entityData.getByte(16);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Size", this.getSlimeSize() - 1);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setSlimeSize(tag.getInteger("Size") + 1);
    }

    @Override
    public void tick() {
        if (!this.sizeSet) {
            this.setSlimeSize(this.getSlimeSize());
            this.sizeSet = true;
        }
        this.oSquish = this.squish;
        boolean flag = this.onGround;
        super.tick();
        if (this.onGround && !flag) {
            int i = this.getSlimeSize();
            for (int j = 0; j < i * 8; ++j) {
                float f = this.random.nextFloat() * (float)Math.PI * 2.0f;
                double f1 = (double)this.random.nextFloat() * 0.5 + 0.5;
                double f2 = (double)(MathHelper.sin(f) * (float)i) * 0.5 * f1;
                double f3 = (double)(MathHelper.cos(f) * (float)i) * 0.5 * f1;
                this.world.spawnParticle("item", this.x + f2, this.bb.minY, this.z + f3, 0.0, 0.0, 0.0, Items.SLIMEBALL.id);
            }
            if (i > 2) {
                this.world.playSoundAtEntity(null, this, "mob.slime", this.getSoundVolume(), ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            }
            this.squish = -0.5f;
        }
        if (!this.world.isClientSide && !this.world.getDifficulty().canHostileMobsSpawn()) {
            this.remove();
        }
        this.squish *= 0.6f;
    }

    @Override
    protected void updateAI() {
        boolean targetPlayer;
        this.tryToDespawn();
        Player entityplayer = this.world.getClosestPlayerToEntity(this, 16.0);
        boolean bl = targetPlayer = entityplayer != null && entityplayer.getGamemode().areMobsHostile();
        if (entityplayer != null && targetPlayer) {
            this.lookAt(entityplayer, 10.0f, 20.0f);
        }
        if (this.onGround && this.jumpDelay-- <= 0) {
            if (!targetPlayer) {
                float rotation = (this.world.rand.nextFloat() - 0.5f) * 90.0f;
                this.yRot += rotation;
            }
            this.jumpDelay = this.random.nextInt(20) + 10;
            if (entityplayer != null) {
                this.jumpDelay /= 3;
            }
            this.isJumping = true;
            if (this.getSlimeSize() > 1) {
                this.world.playSoundAtEntity(null, this, "mob.slime", this.getSoundVolume(), ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) * 0.8f);
            }
            this.squish = 1.0f;
            this.moveStrafing = 1.0f - this.random.nextFloat() * 2.0f;
            this.moveForward = this.getSlimeSize();
        } else {
            this.isJumping = false;
            if (this.onGround) {
                this.moveForward = 0.0f;
                this.moveStrafing = 0.0f;
            }
        }
    }

    @Override
    public void remove() {
        int size = this.getSlimeSize();
        if (!this.world.isClientSide && size > 1 && this.getHealth() <= 0) {
            int splitCount = this.world.rand.nextInt(4) + 1;
            for (int j = 0; j < splitCount; ++j) {
                float f = ((float)(j % 2) - 0.5f) * (float)size / 4.0f;
                float f1 = ((float)(j / 2) - 0.5f) * (float)size / 4.0f;
                SlimeMob entityslime = new SlimeMob(this.world, true);
                entityslime.setSlimeSize(size / 2);
                entityslime.moveTo(this.x + (double)f, this.y + 0.5, this.z + (double)f1, this.random.nextFloat() * 360.0f, 0.0f);
                this.world.entityJoinedWorld(entityslime);
            }
        }
        super.remove();
    }

    @Override
    public void playerTouch(Player player) {
        int i = this.getSlimeSize();
        if (i > 1 && this.canEntityBeSeen(player) && (double)this.distanceTo(player) < 0.6 * (double)i && player.hurt(this, i, DamageType.COMBAT)) {
            this.world.playSoundAtEntity(null, this, "mob.slimeattack", 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
    }

    @Override
    protected String getHurtSound() {
        return "mob.slime";
    }

    @Override
    protected String getDeathSound() {
        return "mob.slime";
    }

    @Override
    protected List<WeightedRandomLootObject> getMobDrops() {
        if (this.getSlimeSize() == 1) {
            return this.mobDrops;
        }
        return null;
    }

    @Override
    public boolean canSpawnHere() {
        Chunk chunk = this.world.getChunkFromBlockCoords(MathHelper.floor(this.x), MathHelper.floor(this.z));
        if (this.y > 32.0) {
            return false;
        }
        if (chunk.getChunkRandom(987234911L).nextInt(10) != 0) {
            return false;
        }
        if (!this.world.getDifficulty().canHostileMobsSpawn()) {
            return false;
        }
        return super.canSpawnHere();
    }

    @Override
    protected float getSoundVolume() {
        return 0.6f;
    }
}

