/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.player;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.ListTag;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.achievement.Achievements;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.block.BedBlock;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.entity.DispenserBlockEntity;
import net.minecraft.core.block.entity.FlagBlockEntity;
import net.minecraft.core.block.entity.FurnaceBlockEntity;
import net.minecraft.core.block.entity.SignBlockEntity;
import net.minecraft.core.block.entity.TrommelBlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.data.gamerule.GameRules;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.FishingBobberEntity;
import net.minecraft.core.entity.ItemEntity;
import net.minecraft.core.entity.LightningEntity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.TNTPrimedEntity;
import net.minecraft.core.entity.animal.PigMob;
import net.minecraft.core.entity.animal.WolfMob;
import net.minecraft.core.entity.monster.CreeperMob;
import net.minecraft.core.entity.monster.GhastMob;
import net.minecraft.core.entity.monster.GiantMob;
import net.minecraft.core.entity.monster.Monster;
import net.minecraft.core.entity.monster.SkeletonMob;
import net.minecraft.core.entity.monster.SlimeMob;
import net.minecraft.core.entity.monster.SnowmanMob;
import net.minecraft.core.entity.monster.SpiderMob;
import net.minecraft.core.entity.monster.ZombieMob;
import net.minecraft.core.entity.monster.ZombiePigMob;
import net.minecraft.core.entity.projectile.ArrowProjectile;
import net.minecraft.core.entity.projectile.CannonballProjectile;
import net.minecraft.core.entity.projectile.FireballProjectile;
import net.minecraft.core.entity.projectile.GoldenArrowProjectile;
import net.minecraft.core.entity.vehicle.BoatEntity;
import net.minecraft.core.entity.vehicle.MinecartEntity;
import net.minecraft.core.enums.ArtType;
import net.minecraft.core.enums.Difficulty;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.enums.EnumSleepStatus;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.item.tool.SwordToolItem;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.player.inventory.container.Inventory;
import net.minecraft.core.player.inventory.menu.AbstractContainerMenu;
import net.minecraft.core.player.inventory.menu.InventoryMenu;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.ICarriable;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.weather.Weathers;
import net.minecraft.server.entity.player.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public abstract class Player
extends Mob {
    public static final int DATA_UNKNOWN = 16;
    public static final int DATA_SELECTED_ART = 17;
    public static final int DATA_HELD_ARROW = 18;
    public static final TextFormatting deathMsgColor = TextFormatting.RED;
    public Inventory inventory;
    public AbstractContainerMenu inventorySlots;
    public AbstractContainerMenu craftingInventory;
    public Gamemode gamemode = Gamemode.survival;
    public int score = 0;
    public List<String> messageHistory = new ArrayList<String>();
    public float cameraVelocityOld;
    public float cameraVelocity;
    public boolean isSwinging = false;
    public int swingProgressInt = 0;
    public String username;
    public UUID uuid;
    public int dimension;
    public double xdO;
    public double ydO;
    public double zd0;
    protected boolean sleeping;
    public ChunkCoordinates bedChunkCoordinates;
    public ChunkCoordinates dimensionEnterCoordinate;
    private int sleepTimer;
    public float sleepOffX;
    public float sleepOffY;
    public float sleepOffZ;
    private ChunkCoordinates playerSpawnCoordinate;
    private ChunkCoordinates lastDeathCoordinate;
    private ChunkCoordinates startMinecartRidingCoordinate;
    public int timeUntilPortal = 20;
    protected boolean inPortal = false;
    public int portalID;
    public float timeInPortal;
    public float prevTimeInPortal;
    private final int damageRemainder;
    @Nullable
    public FishingBobberEntity bobberEntity = null;
    @Nullable
    protected ICarriable heldObject;
    public volatile String skinURL;
    public volatile String capeURL;
    public boolean slimModel = false;
    protected float baseSpeed = 0.1f;
    protected float baseFlySpeed = 0.02f;
    protected boolean isDwarf = false;
    public int lastRenderTick = 0;
    public float wobbleTimer = 0.0f;

    public Player(World world) {
        super(world);
        this.inventory = new Inventory(this);
        this.craftingInventory = this.inventorySlots = new InventoryMenu(this.inventory, !world.isClientSide);
        this.heightOffset = 1.62f;
        ChunkCoordinates chunkcoordinates = world.getSpawnPoint();
        this.moveTo((double)chunkcoordinates.x + 0.5, chunkcoordinates.y + 1, (double)chunkcoordinates.z + 0.5, 0.0f, 0.0f);
        this.entityType = "humanoid";
        this.fireImmuneTicks = 20;
        this.textureIdentifier = new NamespaceID("minecraft", "char");
        this.damageRemainder = 0;
    }

    @Override
    public int getMaxHealth() {
        return 20;
    }

    public ArtType getSelectedArt() {
        return ArtType.values.get(this.entityData.getByte(17));
    }

    public void setSelectedArt(ArtType selectedArt) {
        this.entityData.set(17, (byte)ArtType.values.indexOf(selectedArt));
    }

    private void setupDwarfMode() {
        boolean dwarfModeEnabled = this.world.getGameRuleValue(GameRules.DWARF_MODE);
        if (dwarfModeEnabled && !this.isDwarf) {
            this.setSize(0.6f, 0.8f);
            this.heightOffset = 0.62f;
            this.setPos(this.x, this.y - 1.0, this.z);
        } else if (!dwarfModeEnabled && this.isDwarf) {
            this.setSize(0.6f, 1.8f);
            this.heightOffset = 1.62f;
            this.setPos(this.x, this.y + 1.0, this.z);
        }
        this.isDwarf = dwarfModeEnabled;
    }

    public boolean isDwarf() {
        return this.isDwarf;
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(16, (byte)0, Byte.class);
        this.entityData.define(17, (byte)0, Byte.class);
        this.entityData.define(18, -1, Integer.class);
    }

    @Override
    public boolean canSkate() {
        return this.inventory.armorInventory[0] != null && this.inventory.armorInventory[0].itemID == Items.ARMOR_BOOTS_ICESKATES.id;
    }

    @Override
    public void tick() {
        if (this.world.dimension == Dimension.NETHER) {
            if (this.y >= 260.0) {
                this.addStat(Achievements.ENTER_OLDWORLD, 1);
            } else if (this.y >= 128.0) {
                this.addStat(Achievements.ENTER_NETHER, 1);
            } else {
                this.addStat(Achievements.ENTER_WARRENS, 1);
            }
        }
        this.xdO = this.xd;
        this.ydO = this.yd;
        this.zd0 = this.zd;
        this.setupDwarfMode();
        if (this.isPlayerSleeping()) {
            ++this.sleepTimer;
            if (this.sleepTimer > 100) {
                this.sleepTimer = 100;
            }
            if (!this.world.isClientSide) {
                if (!this.isInBed()) {
                    this.wakeUpPlayer(true, true);
                } else if (this.world.isDaytime() && this.world.getCurrentWeather() != Weathers.OVERWORLD_STORM) {
                    this.wakeUpPlayer(false, true);
                }
            }
        } else if (this.sleepTimer > 0) {
            ++this.sleepTimer;
            if (this.sleepTimer >= 110) {
                this.sleepTimer = 0;
            }
        }
        super.tick();
        if (this.heldObject != null) {
            this.heldObject.heldTick(this.world, this);
        }
        if (!this.world.isClientSide && this.craftingInventory != null && !this.craftingInventory.stillValid(this)) {
            this.closeScreen();
            this.craftingInventory = this.inventorySlots;
        }
        this.addStat(StatList.minutesPlayedStat, 1);
        if (this.vehicle == null) {
            this.startMinecartRidingCoordinate = null;
        }
    }

    @Override
    protected boolean isMovementBlocked() {
        return this.getHealth() <= 0 || this.isPlayerSleeping();
    }

    protected void closeScreen() {
        this.craftingInventory = this.inventorySlots;
    }

    @Override
    public void rideTick() {
        double d = this.x;
        double d1 = this.y;
        double d2 = this.z;
        super.rideTick();
        this.cameraVelocityOld = this.cameraVelocity;
        this.cameraVelocity = 0.0f;
        this.addMountedMovementStat(this.x - d, this.y - d1, this.z - d2);
    }

    @Override
    public void resetPos() {
        this.heightOffset = 1.62f;
        this.setSize(0.6f, 1.8f);
        super.resetPos();
        this.setHealthRaw(this.getMaxHealth());
        this.deathTime = 0;
        this.setupDwarfMode();
    }

    @Override
    protected void updateAI() {
        if (this.isSwinging) {
            ++this.swingProgressInt;
            if (this.swingProgressInt >= 8) {
                this.swingProgressInt = 0;
                this.isSwinging = false;
            }
        } else {
            this.swingProgressInt = 0;
        }
        this.swingProgress = (float)this.swingProgressInt / 8.0f;
    }

    @Override
    public void onLivingUpdate() {
        List<Entity> list;
        if (this.world.getDifficulty() == Difficulty.PEACEFUL && this.getHealth() < this.getMaxHealth() && this.tickCount % 20 * 12 == 0) {
            this.heal(1);
        }
        this.inventory.decrementAnimations();
        this.cameraVelocityOld = this.cameraVelocity;
        super.onLivingUpdate();
        this.speed = this.baseSpeed;
        this.flySpeed = this.baseFlySpeed;
        if (this.isSprinting()) {
            this.speed = (float)((double)this.speed + (double)this.baseSpeed * 0.3);
            this.flySpeed = (float)((double)this.flySpeed + (double)this.baseFlySpeed * 0.3);
        }
        double velocity = MathHelper.sqrt(this.xd * this.xd + this.zd * this.zd);
        double pitch = (float)Math.atan(-this.yd * 0.2) * 15.0f;
        if (velocity > (double)0.1f) {
            velocity = 0.1f;
        }
        if (!this.onGround || this.getHealth() <= 0) {
            velocity = 0.0;
        }
        if (this.onGround || this.getHealth() <= 0) {
            pitch = 0.0;
        }
        this.cameraVelocity += (float)((velocity - (double)this.cameraVelocity) * (double)0.4f);
        this.cameraPitch += (float)((pitch - (double)this.cameraPitch) * (double)0.8f);
        if (!this.dead && this.lastDeathCoordinate != null && this.distanceTo(this.lastDeathCoordinate.x, this.lastDeathCoordinate.y, this.lastDeathCoordinate.z) < 8.0) {
            this.lastDeathCoordinate = null;
        }
        if (this.getHealth() > 0 && (list = this.world.getEntitiesWithinAABBExcludingEntity(this, this.bb.grow(1.0, 0.5, 1.0))) != null) {
            for (Entity entity : list) {
                if (entity.removed) continue;
                this.collideWithPlayer(entity);
            }
        }
    }

    @Override
    public void playHurtSound() {
        float pitch = 1.0f;
        if (this.world.getGameRuleValue(GameRules.DWARF_MODE).booleanValue()) {
            pitch = 2.0f;
        }
        this.world.playSoundAtEntity(null, this, this.getHurtSound(), this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + pitch);
    }

    @Override
    public void playDeathSound() {
        float pitch = 1.0f;
        if (this.world.getGameRuleValue(GameRules.DWARF_MODE).booleanValue()) {
            pitch = 2.0f;
        }
        this.world.playSoundAtEntity(null, this, this.getDeathSound(), this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + pitch);
    }

    private void collideWithPlayer(Entity entity) {
        entity.playerTouch(this);
        String entityName = EntityDispatcher.getEncodeId(entity);
        this.addStat(StatList.mobEncounterStats.get(entityName), 1);
    }

    public int getScore() {
        return this.score;
    }

    @Override
    public void onDeath(Entity entityKilledBy) {
        if (this.getGamemode().isPermaDeath()) {
            this.setGamemode(Gamemode.spectator);
        }
        super.onDeath(entityKilledBy);
        this.setSize(0.2f, 0.2f);
        this.setPos(this.x, this.y, this.z);
        this.lastDeathCoordinate = new ChunkCoordinates((int)this.x, (int)this.y, (int)this.z);
        this.yd = 0.1;
        if (this.username.equals("MaggAndGeez")) {
            this.dropPlayerItemWithRandomChoice(new ItemStack(Items.AMMO_FIREBALL, 1), true);
        } else if (this.username.equals("jonkadelic")) {
            this.dropPlayerItemWithRandomChoice(new ItemStack(Items.FOOD_COOKIE, 1), true);
        } else if (this.username.equals("AnActualSign")) {
            this.dropPlayerItemWithRandomChoice(new ItemStack(Items.SIGN, 1), true);
        }
        if (!this.world.getGameRuleValue(GameRules.KEEP_INVENTORY).booleanValue()) {
            this.craftingInventory.onCraftGuiClosed(this);
            this.inventory.dropAllItems();
        }
        if (this.heldObject != null) {
            this.heldObject.drop(this.world, this);
            this.heldObject = null;
        }
        if (entityKilledBy != null) {
            this.xd = -MathHelper.cos((this.attackedAtYaw + this.yRot) * (float)Math.PI / 180.0f) * 0.1f;
            this.zd = -MathHelper.sin((this.attackedAtYaw + this.yRot) * (float)Math.PI / 180.0f) * 0.1f;
        } else {
            this.zd = 0.0;
            this.xd = 0.0;
        }
        this.heightOffset = 0.1f;
        this.addStat(StatList.deathsStat, 1);
    }

    @Override
    public boolean sendDeathMessage(Entity entityKilledBy) {
        return true;
    }

    @Override
    public String getDeathMessage(Entity entityKilledBy) {
        if (this.random.nextInt(8000) == 666) {
            return this.getDisplayName() + deathMsgColor + " was killed by Herobrine.";
        }
        if (entityKilledBy instanceof ZombieMob) {
            if (entityKilledBy instanceof ZombiePigMob) {
                return this.getDisplayName() + deathMsgColor + " discovered mob mentality.";
            }
            return this.getDisplayName() + deathMsgColor + " became a zombie.";
        }
        if (entityKilledBy instanceof CreeperMob) {
            return deathMsgColor + "Aw man, " + this.getDisplayName() + deathMsgColor + " didn't see the creeper.";
        }
        if (entityKilledBy instanceof SkeletonMob) {
            return this.getDisplayName() + deathMsgColor + " was a victim of aimbot.";
        }
        if (entityKilledBy instanceof SpiderMob) {
            return this.getDisplayName() + deathMsgColor + " spent too much time on the web.";
        }
        if (entityKilledBy instanceof GhastMob) {
            return this.getDisplayName() + deathMsgColor + " didn't return the serve.";
        }
        if (entityKilledBy instanceof SlimeMob) {
            return this.getDisplayName() + deathMsgColor + " was slimed.";
        }
        if (entityKilledBy instanceof WolfMob) {
            return this.getDisplayName() + deathMsgColor + " got what they deserved.";
        }
        if (entityKilledBy instanceof GoldenArrowProjectile) {
            if (((GoldenArrowProjectile)entityKilledBy).owner instanceof ServerPlayer) {
                if (((ServerPlayer)((GoldenArrowProjectile)entityKilledBy).owner).uuid.equals(this.uuid)) {
                    return this.getDisplayName() + deathMsgColor + " got gold in their eye.";
                }
                return this.getDisplayName() + deathMsgColor + " got pierced by " + ((ArrowProjectile)entityKilledBy).owner.getDisplayName() + deathMsgColor + ".";
            }
            return this.getDisplayName() + deathMsgColor + " is Swiss cheese.";
        }
        if (entityKilledBy instanceof ArrowProjectile) {
            if (((ArrowProjectile)entityKilledBy).owner instanceof SkeletonMob) {
                return this.getDisplayName() + deathMsgColor + " was a victim of aimbot.";
            }
            if (((ArrowProjectile)entityKilledBy).owner instanceof ServerPlayer) {
                if (((ServerPlayer)((ArrowProjectile)entityKilledBy).owner).uuid.equals(this.uuid)) {
                    return this.getDisplayName() + deathMsgColor + " lost a game of Russian roulette.";
                }
                return this.getDisplayName() + deathMsgColor + " got 360 noscoped by " + ((ArrowProjectile)entityKilledBy).owner.getDisplayName() + deathMsgColor + ".";
            }
            return this.getDisplayName() + deathMsgColor + " is a pincushion.";
        }
        if (entityKilledBy instanceof CannonballProjectile) {
            if (((CannonballProjectile)entityKilledBy).owner instanceof ServerPlayer) {
                if (((ServerPlayer)((CannonballProjectile)entityKilledBy).owner).uuid.equals(this.uuid)) {
                    return this.getDisplayName() + deathMsgColor + " jumped too high.";
                }
                return this.getDisplayName() + deathMsgColor + " was fragmented by " + ((CannonballProjectile)entityKilledBy).owner.getDisplayName() + deathMsgColor + ".";
            }
            return this.getDisplayName() + deathMsgColor + " was detonated remotely.";
        }
        if (entityKilledBy instanceof FireballProjectile) {
            return this.getDisplayName() + deathMsgColor + " didn't return the serve.";
        }
        if (entityKilledBy instanceof GiantMob) {
            return this.getDisplayName() + deathMsgColor + " was killed by- wait, what?!";
        }
        if (entityKilledBy instanceof LightningEntity) {
            return this.getDisplayName() + deathMsgColor + " was grounded.";
        }
        if (entityKilledBy instanceof TNTPrimedEntity) {
            return this.getDisplayName() + deathMsgColor + " was killed by Popbob.";
        }
        if (entityKilledBy instanceof ServerPlayer) {
            return this.getDisplayName() + deathMsgColor + " was backstabbed by " + ((ServerPlayer)entityKilledBy).getDisplayName() + deathMsgColor + ".";
        }
        if (entityKilledBy instanceof PigMob) {
            return this.getDisplayName() + deathMsgColor + " is *really* bad at Minecraft.";
        }
        if (this.world.getBlockMaterial(MathHelper.floor(this.x), MathHelper.floor(this.y), MathHelper.floor(this.z)) == Material.lava) {
            return this.getDisplayName() + deathMsgColor + " got lost in the sauce.";
        }
        if (this.world.getBlockId(MathHelper.floor(this.x), MathHelper.floor(this.y), MathHelper.floor(this.z)) == Blocks.SPIKES.id) {
            return this.getDisplayName() + deathMsgColor + " fell for the trap.";
        }
        if (this.fallDistance > 0.0f) {
            return this.getDisplayName() + deathMsgColor + " forgot to tie their laces.";
        }
        if (this.airSupply <= 0) {
            return this.getDisplayName() + deathMsgColor + " is sleeping with the fishes.";
        }
        if (this.remainingFireTicks > 0) {
            return this.getDisplayName() + deathMsgColor + " was cooked well done.";
        }
        return this.getDisplayName() + deathMsgColor + " died mysteriously.";
    }

    @Override
    protected void dropDeathItems() {
    }

    @Override
    public void awardKillScore(Entity entity, int i) {
        this.score += i;
        if (entity instanceof Player) {
            this.addStat(StatList.playerKillsStat, 1);
        } else {
            this.addStat(StatList.mobKillsStat, 1);
        }
    }

    public void dropCurrentItem(boolean dropFullStack) {
        this.dropPlayerItemWithRandomChoice(this.inventory.removeItem(this.inventory.getCurrentItemIndex(), dropFullStack ? 64 : 1), false);
    }

    public void dropPlayerItem(ItemStack itemstack) {
        this.dropPlayerItemWithRandomChoice(itemstack, false);
    }

    public void setHotbarOffset(int offset) {
        this.inventory.setHotbarOffset(offset, false);
    }

    @Override
    public void setHeldObject(@Nullable ICarriable heldObject) {
        this.heldObject = heldObject;
    }

    @Nullable
    public ICarriable getHeldObject() {
        return this.heldObject;
    }

    @Override
    public boolean isPickable() {
        if (this.getGamemode().canInteract()) {
            return super.isPickable();
        }
        return false;
    }

    @Override
    public boolean isPushable() {
        if (this.getGamemode().canInteract()) {
            return super.isPushable();
        }
        return false;
    }

    @Override
    public boolean isSelectable() {
        if (this.getGamemode().canInteract()) {
            return super.isSelectable();
        }
        return false;
    }

    @Override
    public void push(Entity entity) {
        if (this.noPhysics || !this.getGamemode().canInteract()) {
            return;
        }
        super.push(entity);
    }

    public void dropPlayerItemWithRandomChoice(ItemStack itemstack, boolean flag) {
        if (!this.getGamemode().canInteract()) {
            return;
        }
        if (itemstack == null) {
            return;
        }
        ItemEntity entityitem = new ItemEntity(this.world, this.x, this.y - (double)0.3f + (double)this.getHeadHeight(), this.z, itemstack);
        entityitem.pickupDelay = 40;
        float f = 0.1f;
        if (flag) {
            float f2 = this.random.nextFloat() * 0.5f;
            float f4 = this.random.nextFloat() * (float)Math.PI * 2.0f;
            entityitem.xd = -MathHelper.sin(f4) * f2;
            entityitem.zd = MathHelper.cos(f4) * f2;
            entityitem.yd = 0.2;
        } else {
            float f1 = 0.3f;
            entityitem.xd = -MathHelper.sin(this.yRot / 180.0f * (float)Math.PI) * MathHelper.cos(this.xRot / 180.0f * (float)Math.PI) * f1;
            entityitem.zd = MathHelper.cos(this.yRot / 180.0f * (float)Math.PI) * MathHelper.cos(this.xRot / 180.0f * (float)Math.PI) * f1;
            entityitem.yd = -MathHelper.sin(this.xRot / 180.0f * (float)Math.PI) * f1 + 0.1f;
            f1 = 0.02f;
            float f3 = this.random.nextFloat() * (float)Math.PI * 2.0f;
            entityitem.xd += Math.cos(f3) * (double)(f1 *= this.random.nextFloat());
            entityitem.yd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
            entityitem.zd += Math.sin(f3) * (double)f1;
        }
        this.joinEntityItemWithWorld(entityitem);
        this.addStat(StatList.dropStat, 1);
    }

    protected void joinEntityItemWithWorld(ItemEntity entityitem) {
        this.world.entityJoinedWorld(entityitem);
    }

    public float getCurrentPlayerStrVsBlock(Block block) {
        float defaultBreakSpeed;
        float f = this.inventory.getStrVsBlock(block);
        float f2 = defaultBreakSpeed = this.inventory.getCurrentItem() != null && this.inventory.getCurrentItem().getItem() instanceof SwordToolItem ? 1.51f : 1.01f;
        if (this.getGamemode().doesRequireToolToBreak() && f <= defaultBreakSpeed) {
            return 0.0f;
        }
        if (this.isUnderLiquid(Material.water)) {
            f /= 5.0f;
        }
        if (!this.onGround) {
            f /= 5.0f;
        }
        return f;
    }

    public boolean canHarvestBlock(Block block) {
        if (block == null) {
            return false;
        }
        return this.inventory.canHarvestBlock(block);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        ListTag nbttaglist = tag.getList("Inventory");
        this.inventory.readFromNBT(nbttaglist);
        this.inventory.setCurrentItemIndex(tag.getIntegerOrDefault("CurrentItem", this.inventory.getCurrentItemIndex()), true);
        this.inventory.setHotbarOffset(tag.getIntegerOrDefault("HotbarOffset", this.inventory.getHotbarOffset()), true);
        int dim = tag.getInteger("Dimension");
        if (dim == -1) {
            dim = 1;
        }
        this.dimension = dim;
        this.sleeping = tag.getBoolean("Sleeping");
        this.sleepTimer = tag.getShort("SleepTimer");
        this.setGamemodeOnLogin(Gamemode.gamemodesList[tag.getInteger("Gamemode")]);
        boolean bl = this.noPhysics = tag.getBoolean("Noclip") && this.gamemode.canPlayerFly();
        if (this.sleeping) {
            this.bedChunkCoordinates = new ChunkCoordinates(MathHelper.floor(this.x), MathHelper.floor(this.y), MathHelper.floor(this.z));
            this.wakeUpPlayer(true, true);
        }
        if (tag.containsKey("SpawnX") && tag.containsKey("SpawnY") && tag.containsKey("SpawnZ")) {
            this.playerSpawnCoordinate = new ChunkCoordinates(tag.getInteger("SpawnX"), tag.getInteger("SpawnY"), tag.getInteger("SpawnZ"));
        }
        if (tag.containsKey("LastDeathX") && tag.containsKey("LastDeathY") && tag.containsKey("LastDeathZ")) {
            this.lastDeathCoordinate = new ChunkCoordinates(tag.getInteger("LastDeathX"), tag.getInteger("LastDeathY"), tag.getInteger("LastDeathZ"));
        }
        if (tag.containsKey("HeldObject")) {
            CompoundTag heldTag = tag.getCompound("HeldObject");
            this.heldObject = ICarriable.createAndLoadCarriable(this, heldTag);
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("Inventory", this.inventory.writeToNBT(new ListTag()));
        tag.putInt("CurrentItem", this.inventory.getCurrentItemIndex());
        tag.putInt("HotbarOffset", this.inventory.getHotbarOffset());
        tag.putInt("Dimension", this.dimension);
        tag.putBoolean("Sleeping", this.sleeping);
        tag.putShort("SleepTimer", (short)this.sleepTimer);
        tag.putInt("Gamemode", this.gamemode.getId());
        tag.putBoolean("Noclip", this.noPhysics && this.gamemode.canPlayerFly());
        if (this.playerSpawnCoordinate != null) {
            tag.putInt("SpawnX", this.playerSpawnCoordinate.x);
            tag.putInt("SpawnY", this.playerSpawnCoordinate.y);
            tag.putInt("SpawnZ", this.playerSpawnCoordinate.z);
        }
        if (this.lastDeathCoordinate != null) {
            tag.putInt("LastDeathX", this.lastDeathCoordinate.x);
            tag.putInt("LastDeathY", this.lastDeathCoordinate.y);
            tag.putInt("LastDeathZ", this.lastDeathCoordinate.z);
        }
        if (this.heldObject != null) {
            CompoundTag heldTag = new CompoundTag();
            this.heldObject.writeToNBT(heldTag);
            tag.put("HeldObject", heldTag);
        }
    }

    @Override
    public String getDisplayName() {
        String name = this.nickname;
        name = name.isEmpty() ? this.username : TextFormatting.ITALIC + name;
        return TextFormatting.get(this.chatColor) + name;
    }

    public void displayContainerScreen(Container container) {
    }

    public void displayWorkbenchScreen(int x, int y, int z) {
    }

    public void displayLabelEditorScreen(ItemStack itemStack, int slot) {
    }

    public void displayPaintingPickerScreen() {
    }

    public void displayMobPickerScreen(int x, int y, int z) {
    }

    public void displayWandMobPickerScreen(ItemStack itemStack) {
    }

    public void displayGuidebookScreen() {
    }

    public void onItemPickup(Entity entity, ItemStack item) {
    }

    @Override
    public float getHeadHeight() {
        return 0.12f;
    }

    protected void resetHeight() {
        this.heightOffset = this.getHeightOffset();
    }

    public float getHeightOffset() {
        if (this.isDwarf) {
            return 0.62f;
        }
        return 1.62f;
    }

    public boolean killPlayer() {
        return super.hurt(null, 100, null);
    }

    @Override
    public boolean hurt(Entity attacker, int damage, DamageType type) {
        this.entityAge = 0;
        if (this.getHealth() <= 0) {
            return false;
        }
        if (this.gamemode.isPlayerInvulnerable()) {
            return false;
        }
        if (this.isPlayerSleeping() && !this.world.isClientSide) {
            this.wakeUpPlayer(true, true);
        }
        if (attacker instanceof Monster || attacker instanceof ArrowProjectile) {
            switch (this.world.getDifficulty()) {
                case PEACEFUL: {
                    damage = 0;
                    break;
                }
                case EASY: {
                    damage = damage / 3 + 1;
                    break;
                }
                case HARD: {
                    damage = damage * 3 / 2;
                }
            }
        }
        Entity blamedAttacker = attacker;
        if (damage == 0 && !(attacker instanceof SnowmanMob)) {
            return false;
        }
        if (blamedAttacker instanceof ArrowProjectile && ((ArrowProjectile)blamedAttacker).owner != null) {
            blamedAttacker = ((ArrowProjectile)blamedAttacker).owner;
        }
        if (blamedAttacker instanceof Mob) {
            this.alertWolves((Mob)blamedAttacker, false);
        }
        this.addStat(StatList.damageTakenStat, damage);
        if (attacker != null) {
            String entityName = EntityDispatcher.getEncodeId(attacker);
            this.addStat(StatList.mobEncounterStats.get(entityName), 1);
        }
        return super.hurt(attacker, damage, type);
    }

    protected boolean func_27025_G() {
        return false;
    }

    protected void alertWolves(Mob attacker, boolean flag) {
        WolfMob wolf;
        if (attacker instanceof CreeperMob || attacker instanceof GhastMob) {
            return;
        }
        if (attacker instanceof WolfMob && (wolf = (WolfMob)attacker).isWolfTamed() && this.uuid.equals(wolf.getWolfOwner())) {
            return;
        }
        if (attacker instanceof Player && !this.func_27025_G()) {
            return;
        }
        List<Entity> list = this.world.getEntitiesWithinAABB(WolfMob.class, AABB.getTemporaryBB(this.x, this.y, this.z, this.x + 1.0, this.y + 1.0, this.z + 1.0).grow(16.0, 4.0, 16.0));
        for (Entity entity : list) {
            WolfMob wolf2 = (WolfMob)entity;
            if (!wolf2.isWolfTamed() || wolf2.getTarget() != null || !this.uuid.equals(wolf2.getWolfOwner()) || flag && wolf2.isWolfSitting()) continue;
            wolf2.setTarget(attacker);
        }
    }

    @Override
    protected void damageEntity(int damage, DamageType damageType) {
        float protection = 1.0f - this.inventory.getTotalProtectionAmount(damageType);
        protection = Math.max(protection, 0.01f);
        double d = (float)damage * protection;
        int newDamage = (int)((double)this.random.nextFloat() > 0.5 ? Math.floor(d) : Math.ceil(d));
        int preventedDamage = damage - newDamage;
        if (damageType != null && damageType.shouldDamageArmor()) {
            int armorDamage = (int)Math.ceil((double)preventedDamage / 4.0);
            this.inventory.damageArmor(armorDamage);
        }
        super.damageEntity(newDamage, damageType);
    }

    public void displayFurnaceScreen(FurnaceBlockEntity blockEntity) {
    }

    public void displayTrommelScreen(TrommelBlockEntity blockEntity) {
    }

    public void displayDispenserScreen(DispenserBlockEntity blockEntity) {
    }

    public void displaySignEditorScreen(SignBlockEntity blockEntity) {
    }

    public void displayFlagEditorScreen(FlagBlockEntity blockEntity) {
    }

    @Override
    public boolean interact(Player entityplayer) {
        return false;
    }

    public boolean useCurrentItemOnEntity(Entity entity) {
        ItemStack itemstack;
        boolean flag = false;
        if (entity.interact(this)) {
            this.swingItem();
            flag = true;
        }
        if ((itemstack = this.getCurrentEquippedItem()) != null && entity instanceof Mob) {
            if (itemstack.useItemOnEntity((Mob)entity, this)) {
                this.swingItem();
                flag = true;
            }
            if (itemstack.stackSize <= 0) {
                this.destroyCurrentEquippedItem();
            }
        }
        return flag;
    }

    public ItemStack getCurrentEquippedItem() {
        return this.inventory.getCurrentItem();
    }

    public void destroyCurrentEquippedItem() {
        this.inventory.setItem(this.inventory.getCurrentItemIndex(), null);
    }

    @Override
    public double getRidingHeight() {
        return this.isDwarf ? (double)this.heightOffset + 0.05 : (double)(this.heightOffset - 0.5f);
    }

    public void swingItem() {
        this.swingProgressInt = -1;
        this.isSwinging = true;
    }

    public void attackTargetEntityWithCurrentItem(Entity entity) {
        if (!this.getGamemode().canInteract()) {
            return;
        }
        int i = this.inventory.getDamageVsEntity(entity);
        if (i > 0) {
            if (this.yd < 0.0) {
                ++i;
            }
            entity.hurt(this, i, DamageType.COMBAT);
            ItemStack itemstack = this.getCurrentEquippedItem();
            if (itemstack != null && entity instanceof Mob) {
                itemstack.hitEntity((Mob)entity, this);
                if (itemstack.stackSize <= 0) {
                    this.destroyCurrentEquippedItem();
                }
            }
            if (entity instanceof Mob) {
                if (entity.isAlive()) {
                    this.alertWolves((Mob)entity, true);
                }
                this.addStat(StatList.damageDealtStat, i);
            }
        }
        String entityName = EntityDispatcher.getEncodeId(entity);
        this.addStat(StatList.mobEncounterStats.get(entityName), 1);
    }

    public void respawnPlayer() {
    }

    public abstract void animate4();

    public void onItemStackChanged(ItemStack itemstack) {
    }

    @Override
    public void remove() {
        super.remove();
        this.inventorySlots.onCraftGuiClosed(this);
        if (this.craftingInventory != null) {
            this.craftingInventory.onCraftGuiClosed(this);
        }
    }

    @Override
    public boolean isInWall() {
        return !this.sleeping && super.isInWall();
    }

    public EnumSleepStatus sleepInBedAt(int x, int y, int z) {
        if (!this.world.isClientSide) {
            if (this.isPlayerSleeping() || !this.isAlive()) {
                return EnumSleepStatus.OTHER_PROBLEM;
            }
            if (!this.world.worldType.mayRespawn()) {
                return EnumSleepStatus.NOT_POSSIBLE_HERE;
            }
            if (Math.abs(this.x - (double)x) > 3.0 || Math.abs(this.y - (double)y) > 3.0 || Math.abs(this.z - (double)z) > 3.0) {
                return EnumSleepStatus.TOO_FAR_AWAY;
            }
            if (!(this.bedChunkCoordinates != null && this.bedChunkCoordinates.equals(x, y, z) || this.playerSpawnCoordinate != null && this.playerSpawnCoordinate.equals(x, y, z))) {
                this.sendTranslatedChatMessage("bed.setSpawn");
                this.setPlayerSpawnCoordinate(new ChunkCoordinates(x, y, z));
            }
            if (!this.world.getGameRuleValue(GameRules.ALLOW_SLEEPING).booleanValue()) {
                this.sendStatusMessage(I18n.getInstance().translateKey("bed.noAllowSleeping"));
                return EnumSleepStatus.DISABLED_BY_GAMERULE;
            }
            if (this.world.isDaytime() && this.world.getCurrentWeather() != Weathers.OVERWORLD_STORM) {
                this.sendStatusMessage(I18n.getInstance().translateKey("bed.noSleep"));
                return EnumSleepStatus.NOT_POSSIBLE_NOW;
            }
        }
        this.setPlayerSleeping(x, y, z);
        return EnumSleepStatus.OK;
    }

    private void setPlayerSleeping(int x, int y, int z) {
        this.setSize(0.2f, 0.2f);
        this.heightOffset = 0.2f;
        if (this.world.isBlockLoaded(x, y, z)) {
            int meta = this.world.getBlockMetadata(x, y, z);
            int dir = BedBlock.getDirection(meta);
            float xOff = 0.5f;
            float zOff = 0.5f;
            if (dir == 0) {
                zOff = 0.9f;
            } else if (dir == 1) {
                xOff = 0.1f;
            } else if (dir == 2) {
                zOff = 0.1f;
            } else if (dir == 3) {
                xOff = 0.9f;
            }
            this.func_22052_e(dir);
            this.setPos((float)x + xOff, (float)y + 0.9375f, (float)z + zOff);
        } else {
            this.setPos((float)x + 0.5f, (float)y + 0.9375f, (float)z + 0.5f);
        }
        this.sleeping = true;
        this.sleepTimer = 0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.xd = 0.0;
        this.bedChunkCoordinates = new ChunkCoordinates(x, y, z);
        if (!this.world.isClientSide) {
            this.world.updateEnoughPlayersSleepingFlag(this);
        }
    }

    private void func_22052_e(int i) {
        this.sleepOffX = 0.0f;
        this.sleepOffZ = 0.0f;
        switch (i) {
            case 0: {
                this.sleepOffZ = -1.8f;
                break;
            }
            case 2: {
                this.sleepOffZ = 1.8f;
                break;
            }
            case 1: {
                this.sleepOffX = 1.8f;
                break;
            }
            case 3: {
                this.sleepOffX = -1.8f;
            }
        }
    }

    public void wakeUpPlayer(boolean flag, boolean flag1) {
        this.setSize(0.6f, 1.8f);
        this.resetHeight();
        ChunkCoordinates chunkcoordinates = this.bedChunkCoordinates;
        if (chunkcoordinates != null && this.world.getBlock(chunkcoordinates.x, chunkcoordinates.y, chunkcoordinates.z) instanceof BedBlock) {
            BedBlock.setBedOccupied(this.world, chunkcoordinates.x, chunkcoordinates.y, chunkcoordinates.z, false);
            ChunkCoordinates chunkcoordinates2 = BedBlock.getNearestEmptyChunkCoordinates(this.world, chunkcoordinates.x, chunkcoordinates.y, chunkcoordinates.z, 0);
            if (chunkcoordinates2 == null) {
                chunkcoordinates2 = new ChunkCoordinates(chunkcoordinates.x, chunkcoordinates.y + 1, chunkcoordinates.z);
            }
            this.setPos((float)chunkcoordinates2.x + 0.5f, (float)chunkcoordinates2.y + this.heightOffset + 0.1f, (float)chunkcoordinates2.z + 0.5f);
        }
        this.sleeping = false;
        if (!this.world.isClientSide && flag1) {
            this.world.updateEnoughPlayersSleepingFlag(this);
        }
        this.sleepTimer = flag ? 0 : 100;
    }

    private boolean isInBed() {
        return this.world.getBlock(this.bedChunkCoordinates.x, this.bedChunkCoordinates.y, this.bedChunkCoordinates.z) instanceof BedBlock;
    }

    public static ChunkCoordinates getValidBedSpawnCoordinates(World world, ChunkCoordinates coords) {
        IChunkProvider chunkProvider = world.getChunkProvider();
        chunkProvider.setCurrentChunkOver(coords.x >> 4, coords.z >> 4);
        chunkProvider.prepareChunk(coords.x - 3 >> 4, coords.z - 3 >> 4);
        chunkProvider.prepareChunk(coords.x + 3 >> 4, coords.z - 3 >> 4);
        chunkProvider.prepareChunk(coords.x - 3 >> 4, coords.z + 3 >> 4);
        chunkProvider.prepareChunk(coords.x + 3 >> 4, coords.z + 3 >> 4);
        if (world.getBlock(coords.x, coords.y, coords.z) instanceof BedBlock) {
            return BedBlock.getNearestEmptyChunkCoordinates(world, coords.x, coords.y, coords.z, 0);
        }
        return null;
    }

    public float getBedOrientationInDegrees() {
        if (this.bedChunkCoordinates != null) {
            int i = this.world.getBlockMetadata(this.bedChunkCoordinates.x, this.bedChunkCoordinates.y, this.bedChunkCoordinates.z);
            int j = BedBlock.getDirection(i);
            switch (j) {
                case 0: {
                    return 90.0f;
                }
                case 1: {
                    return 0.0f;
                }
                case 2: {
                    return 270.0f;
                }
                case 3: {
                    return 180.0f;
                }
            }
        }
        return 0.0f;
    }

    @Override
    public boolean isPlayerSleeping() {
        return this.sleeping;
    }

    public boolean isPlayerFullyAsleep() {
        return this.sleeping && this.sleepTimer >= 100;
    }

    public int getSleepTimer() {
        return this.sleepTimer;
    }

    public void sendTranslatedChatMessage(String message) {
        this.sendMessage(I18n.getInstance().translateKey(message));
    }

    public abstract void sendMessage(String var1);

    public abstract void sendStatusMessage(String var1);

    @Override
    public ItemStack getHeldItem() {
        return this.inventory.getCurrentItem();
    }

    public void updateCreativeInventory(int page, String searchText) {
    }

    public ChunkCoordinates getPlayerSpawnCoordinate() {
        return this.playerSpawnCoordinate;
    }

    public void setPlayerSpawnCoordinate(ChunkCoordinates chunkcoordinates) {
        this.playerSpawnCoordinate = chunkcoordinates != null ? new ChunkCoordinates(chunkcoordinates) : null;
    }

    public void triggerAchievement(Stat statbase) {
        this.addStat(statbase, 1);
    }

    public void addStat(Stat statbase, int i) {
    }

    public int getStat(Stat statbase) {
        return 0;
    }

    @Override
    protected void jump() {
        super.jump();
        this.addStat(StatList.jumpStat, 1);
    }

    @Override
    public void moveEntityWithHeading(float moveStrafing, float moveForward) {
        double d = this.x;
        double d1 = this.y;
        double d2 = this.z;
        super.moveEntityWithHeading(moveStrafing, moveForward);
        this.addMovementStat(this.x - d, this.y - d1, this.z - d2);
    }

    private void addMovementStat(double d, double d1, double d2) {
        if (this.vehicle != null) {
            return;
        }
        if (this.isUnderLiquid(Material.water)) {
            int i = Math.round(MathHelper.sqrt(d * d + d1 * d1 + d2 * d2) * 100.0f);
            if (i > 0) {
                this.addStat(StatList.distanceDoveStat, i);
            }
        } else if (this.isInWater()) {
            int j = Math.round(MathHelper.sqrt(d * d + d2 * d2) * 100.0f);
            if (j > 0) {
                this.addStat(StatList.distanceSwumStat, j);
                if (this.dimension == Dimension.NETHER.id) {
                    this.addStat(Achievements.SWIM_NETHER, 1);
                }
            }
        } else if (this.canClimb()) {
            if (d1 > 0.0) {
                this.addStat(StatList.distanceClimbedStat, (int)Math.round(d1 * 100.0));
            }
        } else if (this.onGround) {
            int k = Math.round(MathHelper.sqrt(d * d + d2 * d2) * 100.0f);
            if (k > 0) {
                this.addStat(StatList.distanceWalkedStat, k);
            }
        } else {
            int l = Math.round(MathHelper.sqrt(d * d + d2 * d2) * 100.0f);
            if (l > 25) {
                this.addStat(StatList.distanceFlownStat, l);
            }
        }
    }

    private void addMountedMovementStat(double d, double d1, double d2) {
        int i;
        if (this.vehicle != null && (i = Math.round(MathHelper.sqrt(d * d + d1 * d1 + d2 * d2) * 100.0f)) > 0) {
            if (this.vehicle instanceof MinecartEntity) {
                this.addStat(StatList.distanceByMinecartStat, i);
                if (this.startMinecartRidingCoordinate == null) {
                    this.startMinecartRidingCoordinate = new ChunkCoordinates(MathHelper.floor(this.x), MathHelper.floor(this.y), MathHelper.floor(this.z));
                } else if (this.startMinecartRidingCoordinate.getSqDistanceTo(MathHelper.floor(this.x), MathHelper.floor(this.y), MathHelper.floor(this.z)) >= 1000.0) {
                    this.addStat(Achievements.ON_A_RAIL, 1);
                }
            } else if (this.vehicle instanceof BoatEntity) {
                this.addStat(StatList.distanceByBoatStat, i);
            } else if (this.vehicle instanceof PigMob) {
                this.addStat(StatList.distanceByPigStat, i);
            }
        }
    }

    @Override
    protected void causeFallDamage(float distance) {
        if (distance >= 2.0f) {
            this.addStat(StatList.distanceFallenStat, (int)Math.round((double)distance * 100.0));
        }
        super.causeFallDamage(distance);
    }

    @Override
    public void killed(Mob entityliving) {
        if (entityliving instanceof Monster) {
            this.triggerAchievement(Achievements.KILL_ENEMY);
        }
    }

    @Override
    public void handlePortal(int portalTileId) {
        if (this.timeUntilPortal > 0) {
            this.timeUntilPortal = 10;
        } else {
            this.portalID = portalTileId;
            this.inPortal = true;
        }
    }

    @Override
    public boolean canBreatheUnderwater() {
        return this.gamemode.isPlayerInvulnerable();
    }

    public Gamemode getGamemode() {
        return this.gamemode;
    }

    public void setGamemodeOnLogin(Gamemode gamemode) {
        this.gamemode = gamemode;
        InventoryMenu newContainer = gamemode.getContainer(this.inventory, !this.world.isClientSide);
        if (this.craftingInventory == this.inventorySlots) {
            this.craftingInventory = newContainer;
        }
        this.inventorySlots = newContainer;
        if (!gamemode.canPlayerFly()) {
            this.noPhysics = false;
        }
        this.fireImmune = gamemode.isImmuneToFire();
    }

    public void setGamemode(Gamemode gamemode) {
        this.gamemode = gamemode;
        this.fireImmune = gamemode.isImmuneToFire();
    }

    public void setNoclip(boolean noclip) {
        this.noPhysics = noclip;
        if (this.noPhysics) {
            this.yd += (double)0.079f;
        }
    }

    public void setLastDeathCoordinate(ChunkCoordinates lastDeathCoordinate) {
        this.lastDeathCoordinate = lastDeathCoordinate;
    }

    public ChunkCoordinates getLastDeathCoordinate() {
        return this.lastDeathCoordinate;
    }

    public void pickBlock(int x, int y, int z) {
        ItemStack selectItem;
        Block block = this.world.getBlock(x, y, z);
        int meta = this.world.getBlockMetadata(x, y, z);
        if (block == null) {
            return;
        }
        BlockEntity blockEntity = this.world.getBlockEntity(x, y, z);
        ItemStack[] result = block.getBreakResult(this.world, EnumDropCause.PICK_BLOCK, x, y, z, meta, blockEntity);
        ItemStack itemStack = selectItem = result != null ? result[0] : null;
        if (selectItem == null) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.inventory.getItem(i + this.inventory.getHotbarOffset());
            if (stack == null || stack.itemID != selectItem.itemID || stack.getMetadata() != selectItem.getMetadata()) continue;
            this.setCurrentItem(i + this.inventory.getHotbarOffset());
            return;
        }
        int emptyHotbarSlot = -1;
        int slot = this.inventory.getCurrentItemIndex();
        for (int i = 0; i < 9; ++i) {
            if (this.inventory.getItem(i + this.inventory.getHotbarOffset()) != null) continue;
            emptyHotbarSlot = i + this.inventory.getHotbarOffset();
            slot = i + this.inventory.getHotbarOffset();
            break;
        }
        int itemSlot = -1;
        int stackSize = -1;
        for (int i = 9; i < 36; ++i) {
            ItemStack stack = this.inventory.getItem(i);
            if (stack == null || stack.itemID != selectItem.itemID || stack.getMetadata() != selectItem.getMetadata() || stackSize != -1 && stack.stackSize >= stackSize) continue;
            itemSlot = i;
            stackSize = stack.stackSize;
        }
        if (itemSlot == -1) {
            if (this.getGamemode() == Gamemode.creative) {
                int emptySlot = -1;
                for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
                    if (this.inventory.getItem(i) != null) continue;
                    emptySlot = i;
                    break;
                }
                int createItemInsertSlot = emptyHotbarSlot != -1 ? emptyHotbarSlot : this.inventory.getCurrentItemIndex();
                selectItem.stackSize = 1;
                if (emptySlot != -1) {
                    this.swapItems(emptySlot, createItemInsertSlot);
                }
                this.inventory.setItem(createItemInsertSlot, selectItem);
                this.setCurrentItem(createItemInsertSlot);
            }
            return;
        }
        this.swapItems(slot, itemSlot);
        this.setCurrentItem(slot);
    }

    public void setCurrentItem(int i) {
        this.inventory.setCurrentItemIndex(i, false);
    }

    public void swapItems(int slot1, int slot2) {
        ItemStack stack1 = this.inventory.getItem(slot1);
        ItemStack stack2 = this.inventory.getItem(slot2);
        this.inventory.setItem(slot2, stack1);
        this.inventory.setItem(slot1, stack2);
    }

    public Item getNextArrow() {
        Item nextArrow = null;
        ItemStack quiverSlot = this.inventory.armorItemInSlot(2);
        if (quiverSlot != null && quiverSlot.itemID == Items.ARMOR_QUIVER.id && quiverSlot.getMetadata() < quiverSlot.getMaxDamage()) {
            nextArrow = Items.AMMO_ARROW;
        } else if (quiverSlot != null && quiverSlot.itemID == Items.ARMOR_QUIVER_GOLD.id) {
            nextArrow = Items.AMMO_ARROW_PURPLE;
        } else if (this.hasItem(Items.AMMO_ARROW_GOLD)) {
            nextArrow = Items.AMMO_ARROW_GOLD;
        } else if (this.hasItem(Items.AMMO_ARROW)) {
            nextArrow = Items.AMMO_ARROW;
        }
        return nextArrow;
    }

    public int getArrowId() {
        return this.entityData.getInt(18);
    }

    public boolean hasItem(Item item) {
        for (ItemStack stack : this.inventory.mainInventory) {
            if (stack == null || stack.getItem() != item) continue;
            return true;
        }
        return false;
    }

    public static class SortByUsername
    implements Comparator<Player> {
        @Override
        public int compare(Player o1, Player o2) {
            return o1.username.compareTo(o2.username);
        }
    }
}

