/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.Random;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.projectile.EggProjectile;
import net.minecraft.core.item.IDispensable;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;

public class EggItem
extends Item
implements IDispensable {
    public EggItem(String name, String namespaceId, int id) {
        super(name, namespaceId, id);
        this.maxStackSize = 16;
    }

    @Override
    public ItemStack onUseItem(ItemStack itemstack, World world, Player entityplayer) {
        itemstack.consumeItem(entityplayer);
        world.playSoundAtEntity(entityplayer, entityplayer, "random.bow", 0.5f, 0.4f / (itemRand.nextFloat() * 0.4f + 0.8f));
        if (!world.isClientSide) {
            world.entityJoinedWorld(new EggProjectile(world, entityplayer));
        }
        return itemstack;
    }

    @Override
    public void onDispensed(ItemStack itemStack, World world, double x, double y, double z, int xOffset, int zOffset, Random random) {
        EggProjectile eggProjectile = new EggProjectile(world, x, y, z);
        eggProjectile.setHeading(xOffset, 0.1, zOffset, 1.1f, 6.0f);
        world.entityJoinedWorld(eggProjectile);
    }
}

