/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.List;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.animal.FireflyClusterMob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.item.PlaceableItem;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class JarItem
extends PlaceableItem {
    protected JarItem(String name, String namespaceId, int id) {
        super(name, namespaceId, id, Blocks.JAR_GLASS);
        this.setMaxStackSize(64);
    }

    @Override
    public boolean onUseItemOnBlock(ItemStack stack, Player player, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        if (player.isSneaking()) {
            return super.onUseItemOnBlock(stack, player, world, blockX, blockY, blockZ, side, xPlaced, yPlaced);
        }
        int count = stack.stackSize;
        ItemStack used = this.onUseItem(stack, world, player);
        if (used != null && used.stackSize != count) {
            return true;
        }
        return super.onUseItemOnBlock(stack, player, world, blockX, blockY, blockZ, side, xPlaced, yPlaced);
    }

    @Override
    public ItemStack onUseItem(ItemStack itemstack, World world, Player entityplayer) {
        if (entityplayer.isSneaking()) {
            return itemstack;
        }
        List<Entity> list = world.getEntitiesWithinAABBExcludingEntity(entityplayer, entityplayer.bb.grow(2.0, 2.0, 2.0));
        for (Entity entity : list) {
            if (!(entity instanceof FireflyClusterMob)) continue;
            FireflyClusterMob fireflyCluster = (FireflyClusterMob)entity;
            FireflyClusterMob.FireflyColor colour = fireflyCluster.getColor();
            boolean didFillJar = colour == FireflyClusterMob.FireflyColor.BLUE ? JarItem.fillJar(entityplayer, new ItemStack(Items.LANTERN_FIREFLY_BLUE, 1)) : (colour == FireflyClusterMob.FireflyColor.ORANGE ? JarItem.fillJar(entityplayer, new ItemStack(Items.LANTERN_FIREFLY_ORANGE, 1)) : (colour == FireflyClusterMob.FireflyColor.RED ? JarItem.fillJar(entityplayer, new ItemStack(Items.LANTERN_FIREFLY_RED, 1)) : JarItem.fillJar(entityplayer, new ItemStack(Items.LANTERN_FIREFLY_GREEN, 1))));
            if (!world.isClientSide && didFillJar) {
                fireflyCluster.setFireflyCount(fireflyCluster.getFireflyCount() - 1);
                if (fireflyCluster.getFireflyCount() <= 0) {
                    fireflyCluster.remove();
                }
            }
            return itemstack;
        }
        return itemstack;
    }

    public static boolean fillJar(Player player, ItemStack itemToGive) {
        if (player.inventory.getCurrentItem().stackSize <= 1) {
            player.inventory.setItem(player.inventory.getCurrentItemIndex(), itemToGive);
        } else {
            player.inventory.insertItem(itemToGive, true);
        }
        if (itemToGive.stackSize < 1) {
            player.swingItem();
            player.inventory.getCurrentItem().consumeItem(player);
            return true;
        }
        return false;
    }
}

