/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import java.util.List;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.arguments.EntityArgumentType;
import net.minecraft.core.net.command.exceptions.CommandExceptions;
import net.minecraft.core.net.command.helpers.EntitySelector;
import net.minecraft.core.net.command.util.CommandHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.ChunkCoordinates;

public class SpawnCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("spawn").requires(CommandSource::hasAdmin)).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            Player sender = source.getSender();
            World world = source.getWorld(0);
            ChunkCoordinates spawnCoordinates = world.getSpawnPoint();
            if (sender == null) {
                throw CommandExceptions.notInWorld().create();
            }
            if (sender.dimension != 0) {
                source.movePlayerToDimension(sender, 0);
            }
            sender.absMoveTo((double)spawnCoordinates.x + 0.5, spawnCoordinates.y, (double)spawnCoordinates.z + 0.5, sender.yRot, sender.xRot);
            source.sendTranslatableMessage("command.commands.spawn.success", new Object[0]);
            return 1;
        })).then(RequiredArgumentBuilder.argument("players", EntityArgumentType.players()).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            Player sender = source.getSender();
            World world = source.getWorld(0);
            ChunkCoordinates spawnCoordinates = world.getSpawnPoint();
            EntitySelector entitySelector = c.getArgument("players", EntitySelector.class);
            List<? extends Entity> players = entitySelector.get(source);
            for (Entity entity : players) {
                if (((Player)entity).dimension != 0) {
                    source.movePlayerToDimension((Player)entity, 0);
                }
                entity.absMoveTo((double)spawnCoordinates.x + 0.5, spawnCoordinates.y, (double)spawnCoordinates.z + 0.5, entity.yRot, entity.xRot);
                if (entity == sender) {
                    source.sendTranslatableMessage("command.commands.spawn.success", new Object[0]);
                    continue;
                }
                source.sendTranslatableMessage("command.commands.spawn.success_receiver", new Object[0]);
                source.sendTranslatableMessage("command.commands.spawn.success_other", CommandHelper.getEntityName(entity));
            }
            return 1;
        }))).then(LiteralArgumentBuilder.literal("get").executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            ChunkCoordinates spawnCoordinates = source.getWorld(0).getSpawnPoint();
            source.sendMessage(I18n.getInstance().translateKeyAndFormat("command.commands.spawn.get", spawnCoordinates.x, spawnCoordinates.y, spawnCoordinates.z));
            return 1;
        })));
    }
}

