/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.world;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Global;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.packet.BlockEventPacket;
import net.minecraft.core.net.packet.ChatPacket;
import net.minecraft.core.net.packet.CustomPayloadPacket;
import net.minecraft.core.net.packet.EnitityEventPacket;
import net.minecraft.core.net.packet.EntityTagDataPacket;
import net.minecraft.core.net.packet.ExplosionPacket;
import net.minecraft.core.net.packet.WeatherEffectPacket;
import net.minecraft.core.net.packet.WeatherStatusPacket;
import net.minecraft.core.util.collection.IntHashMap;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.Explosion;
import net.minecraft.core.world.ExplosionCannonball;
import net.minecraft.core.world.SpawnerMobs;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.IChunkLoader;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.save.LevelStorage;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.world.chunk.provider.ChunkProviderServer;

public class WorldServer
extends World {
    public ChunkProviderServer chunkProviderServer;
    public boolean field_819_z = false;
    public boolean levelSaving;
    public MinecraftServer mcServer;
    private final IntHashMap<Entity> entityIntHashMap;
    private long lastWeatherSend = System.currentTimeMillis();

    public WorldServer(MinecraftServer minecraftserver, LevelStorage isavehandler, String name, int dimensionId, WorldType worldType, long seed, SpawnerMobs.SpawnerConfig spawnerConfig) {
        super(isavehandler, name, seed, Dimension.getDimensionList().get(dimensionId), worldType, spawnerConfig);
        this.entityIntHashMap = new IntHashMap();
        this.mcServer = minecraftserver;
    }

    @Override
    public void updateEntityWithOptionalForce(Entity entity, boolean flag) {
        if (!(entity.passenger instanceof Player)) {
            super.updateEntityWithOptionalForce(entity, flag);
        }
    }

    public void func_12017_b(Entity entity, boolean flag) {
        super.updateEntityWithOptionalForce(entity, flag);
    }

    @Override
    protected IChunkProvider createChunkProvider() {
        IChunkLoader ichunkloader = this.saveHandler.getChunkLoader(this.dimension);
        this.chunkProviderServer = (ChunkProviderServer)Global.accessor.createChunkProvider(this, ichunkloader);
        return this.chunkProviderServer;
    }

    public List<BlockEntity> getBlockEntitiesWithinBounds(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        ArrayList<BlockEntity> arraylist = new ArrayList<BlockEntity>();
        for (int i = 0; i < this.loadedBlockEntityList.size(); ++i) {
            BlockEntity blockEntity = (BlockEntity)this.loadedBlockEntityList.get(i);
            if (blockEntity.x < minX || blockEntity.y < minY || blockEntity.z < minZ || blockEntity.x >= maxX || blockEntity.y >= maxY || blockEntity.z >= maxZ) continue;
            arraylist.add(blockEntity);
        }
        return arraylist;
    }

    @Override
    public boolean canMineBlock(Player entityplayer, int i, int j, int k) {
        int i1;
        int l = (int)MathHelper.abs(i - this.levelData.getSpawnX());
        if (l > (i1 = (int)MathHelper.abs(k - this.levelData.getSpawnZ()))) {
            i1 = l;
        }
        return i1 > 16 || this.mcServer.playerList.isOp(entityplayer.uuid);
    }

    @Override
    protected void obtainEntitySkin(Entity entity) {
        super.obtainEntitySkin(entity);
        if (entity == null) {
            return;
        }
        this.entityIntHashMap.put(entity.id, entity);
    }

    @Override
    protected void releaseEntitySkin(Entity entity) {
        super.releaseEntitySkin(entity);
        if (entity == null) {
            return;
        }
        this.entityIntHashMap.remove(entity.id);
    }

    @Override
    protected void updateSleepingPlayers() {
        if (this.areEnoughPlayersFullyAsleep()) {
            boolean wasInterrupted = false;
            if (this.spawningConfig.canHostileSpawn(this) && this.getPlayersRequiredToSkipNight() <= 1) {
                wasInterrupted = SpawnerMobs.performSleepSpawning(this, this.players);
            }
            if (!wasInterrupted) {
                if (MinecraftServer.getInstance() != null && this.players.size() > 1 && this.getPlayersRequiredToSkipNight() <= 1) {
                    Player player = null;
                    for (Player player2 : this.players) {
                        if (!player2.isPlayerFullyAsleep()) continue;
                        player = player2;
                    }
                    if (player != null) {
                        MinecraftServer.getInstance().playerList.sendPacketToAllPlayersInDimension(new ChatPacket(TextFormatting.YELLOW + player.getDisplayName() + TextFormatting.ORANGE + " went to sleep. Sweet dreams!"), this.dimension.id);
                    }
                }
                long timePlusOneDay = this.levelData.getWorldTime() + 24000L;
                this.levelData.setWorldTime(timePlusOneDay - timePlusOneDay % 24000L + (long)this.worldType.getSunriseTick(this) + 1000L);
                this.wakeUpAllPlayers();
            }
        }
    }

    @Override
    public void updateEnoughPlayersSleepingFlag(Player player) {
        this.enoughPlayersSleeping = false;
        if (this.players.size() > 0) {
            int playersSleeping = 0;
            int req = this.getPlayersRequiredToSkipNight();
            for (Player p : this.players) {
                if (!p.isPlayerSleeping()) continue;
                ++playersSleeping;
            }
            if (playersSleeping >= req) {
                this.enoughPlayersSleeping = true;
            }
            if (MinecraftServer.getInstance() != null && player != null && this.players.size() > 1 && req > 1) {
                int moreReq = req - playersSleeping;
                if (player.isPlayerSleeping()) {
                    MinecraftServer.getInstance().playerList.sendPacketToAllPlayersInDimension(new ChatPacket(TextFormatting.YELLOW + player.username + TextFormatting.ORANGE + " went to bed."), this.dimension.id);
                } else {
                    MinecraftServer.getInstance().playerList.sendPacketToAllPlayersInDimension(new ChatPacket(TextFormatting.YELLOW + player.username + TextFormatting.ORANGE + " has left their bed."), this.dimension.id);
                }
                if (moreReq > 0) {
                    if (moreReq > 1) {
                        MinecraftServer.getInstance().playerList.sendPacketToAllPlayersInDimension(new ChatPacket(TextFormatting.LIGHT_GRAY + "" + moreReq + " more players are required to sleep to skip to daytime"), this.dimension.id);
                    } else {
                        MinecraftServer.getInstance().playerList.sendPacketToAllPlayersInDimension(new ChatPacket(TextFormatting.LIGHT_GRAY + "1 more player is required to sleep to skip to daytime"), this.dimension.id);
                    }
                }
            }
        }
    }

    public Entity getEntityFromId(int i) {
        return this.entityIntHashMap.get(i);
    }

    @Override
    public boolean addWeatherEffect(Entity entity) {
        if (super.addWeatherEffect(entity)) {
            this.mcServer.playerList.sendPacketToPlayersAroundPoint(entity.x, entity.y, entity.z, 512.0, this.dimension.id, new WeatherEffectPacket(entity));
            return true;
        }
        return false;
    }

    @Override
    public void sendTrackedEntityStatusUpdatePacket(Entity entityId, byte entityStatus) {
        EnitityEventPacket enitityEventPacket38Entitystatus = new EnitityEventPacket(entityId.id, entityStatus);
        this.mcServer.getEntityTracker(this.dimension.id).sendPacketToTrackedPlayersAndTrackedEntity(entityId, enitityEventPacket38Entitystatus);
    }

    @Override
    public void sendTrackedEntityStatusUpdatePacket(Entity entityId, byte entityStatus, float attackedAtYaw) {
        EnitityEventPacket enitityEventPacket38Entitystatus = new EnitityEventPacket(entityId.id, entityStatus, attackedAtYaw);
        this.mcServer.getEntityTracker(this.dimension.id).sendPacketToTrackedPlayersAndTrackedEntity(entityId, enitityEventPacket38Entitystatus);
    }

    @Override
    public void sendTrackedEntityDataPacket(Entity entity) {
        EntityTagDataPacket entitytagdataNBT = new EntityTagDataPacket(entity);
        this.mcServer.getEntityTracker(this.dimension.id).sendPacketToTrackedPlayersAndTrackedEntity(entity, entitytagdataNBT);
    }

    @Override
    public Explosion createExplosion(Entity entity, double x, double y, double z, float explosionSize) {
        return this.newExplosion(entity, x, y, z, explosionSize, false, false);
    }

    @Override
    public Explosion newExplosion(Entity entity, double x, double y, double z, float explosionSize, boolean flaming, boolean isCannonBall) {
        Explosion explosion = !isCannonBall ? new Explosion(this, entity, x, y, z, explosionSize) : new ExplosionCannonball(this, entity, x, y, z, explosionSize);
        explosion.isFlaming = flaming;
        explosion.explode();
        explosion.addEffects(true);
        this.mcServer.playerList.sendPacketToPlayersAroundPoint(x, y, z, 64.0, this.dimension.id, new ExplosionPacket(x, y, z, explosionSize, explosion.destroyedBlockPositions, isCannonBall));
        return explosion;
    }

    @Override
    public void triggerEvent(int x, int y, int z, int index, int data) {
        super.triggerEvent(x, y, z, index, data);
        this.mcServer.playerList.sendPacketToPlayersAroundPoint(x, y, z, 64.0, this.dimension.id, new BlockEventPacket(x, y, z, index, data));
    }

    public void checkLock() {
        this.saveHandler.checkSessionLock();
    }

    @Override
    public void tick() {
        super.tick();
        if (System.currentTimeMillis() - this.lastWeatherSend > 1000L) {
            this.mcServer.playerList.sendPacketToAllPlayers(new WeatherStatusPacket(this.dimension.id, this.getCurrentWeather() != null ? this.getCurrentWeather().weatherId : -1, this.weatherManager.getNextWeather() != null ? this.weatherManager.getNextWeather().weatherId : -1, this.weatherManager.getWeatherDuration(), this.weatherManager.getWeatherIntensity(), this.weatherManager.getWeatherPower()));
            this.lastWeatherSend = System.currentTimeMillis();
        }
    }

    @Override
    public void sendGlobalMessage(String message) {
        this.mcServer.playerList.sendPacketToAllPlayers(new ChatPacket(message));
    }

    @Override
    public void addRainbow(int rainbowTicks) {
        byte b0 = (byte)(rainbowTicks >> 24 & 0xFF);
        byte b1 = (byte)(rainbowTicks >> 16 & 0xFF);
        byte b2 = (byte)(rainbowTicks >> 8 & 0xFF);
        byte b3 = (byte)(rainbowTicks >> 0 & 0xFF);
        this.mcServer.playerList.sendPacketToAllPlayersInDimension(new CustomPayloadPacket("BTA|RainbowStart", new byte[]{b0, b1, b2, b3}), this.dimension.id);
        super.addRainbow(rainbowTicks);
    }
}

