/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.particle;

import net.minecraft.client.entity.particle.Particle;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.BaseLeavesBlock;
import net.minecraft.core.block.Block;
import net.minecraft.core.world.World;

public class LeafParticle
extends Particle {
    public LeafParticle(World world, double x, double y, double z, double xa, double ya, double za) {
        super(world, x, y, z, xa, ya, za);
        this.tex = TextureRegistry.getTexture("minecraft:block/leaves/oak_fancy");
        this.gravity = 0.125f;
        this.size /= 2.0f;
        this.lifetime *= 16;
        this.yd = 0.0;
        this.xd = 0.0;
        this.zd = 0.0;
    }

    @Override
    public boolean collidesWithBlock(Block block, int metadata) {
        return !(block instanceof BaseLeavesBlock);
    }

    public LeafParticle init(int x, int y, int z) {
        Block block = Block.blocksList[this.world.getBlockId(x, y, z)];
        if (!(block instanceof BaseLeavesBlock)) {
            this.remove();
        }
        int col = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(block)).getWorldColor(this.world, x, y, z);
        this.rCol *= (float)(col >> 16 & 0xFF) / 255.0f;
        this.gCol *= (float)(col >> 8 & 0xFF) / 255.0f;
        this.bCol *= (float)(col & 0xFF) / 255.0f;
        return this;
    }

    @Override
    public void tick() {
        float windDirection = this.world.worldType.getWindManager().getWindDirection(this.world, (float)this.x, (float)this.y, (float)this.z);
        float windIntensity = this.world.worldType.getWindManager().getWindIntensity(this.world, (float)this.x, (float)this.y, (float)this.z) * 0.01f;
        float dx = (float)(Math.cos((double)windDirection * Math.PI * 2.0) * (double)windIntensity);
        float dz = (float)(Math.sin((double)windDirection * Math.PI * 2.0) * (double)windIntensity);
        this.xd += (double)dx;
        this.zd += (double)dz;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.yd -= 0.04 * (double)this.gravity;
        if (this.onGround) {
            this.xd *= 0.0;
            this.zd *= 0.0;
        }
        this.move(this.xd, this.yd, this.zd);
    }

    @Override
    public int getParticleTexture() {
        return 1;
    }

    @Override
    public void render(Tessellator t, float partialTick, double xOff, double yOff, double zOff, float xa, float ya, float za, float xa2, float za2) {
        float u0 = (float)this.tex.getSubIconU(this.uo / 4.0f);
        float u2 = (float)this.tex.getSubIconU(0.25);
        float v0 = (float)this.tex.getSubIconV(this.uo / 4.0f);
        float v2 = (float)this.tex.getSubIconV(0.25);
        float r = 0.1f * this.size;
        float x = (float)(this.xo + (this.x - this.xo) * (double)partialTick - xOff);
        float y = (float)(this.yo + (this.y - this.yo) * (double)partialTick - yOff);
        float z = (float)(this.zo + (this.z - this.zo) * (double)partialTick - zOff);
        float br = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            t.setLightmapCoord(this.getLightmapCoord(partialTick));
        } else {
            br = this.getBrightness(partialTick);
        }
        t.setColorOpaque_F(br * this.rCol, br * this.gCol, br * this.bCol);
        t.addVertexWithUV(x - xa * r - xa2 * r, y - ya * r, z - za * r - za2 * r, u0, v2);
        t.addVertexWithUV(x - xa * r + xa2 * r, y + ya * r, z - za * r + za2 * r, u0, v0);
        t.addVertexWithUV(x + xa * r + xa2 * r, y + ya * r, z + za * r + za2 * r, u2, v0);
        t.addVertexWithUV(x + xa * r - xa2 * r, y - ya * r, z + za * r - za2 * r, u2, v2);
    }
}

