/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.particle;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.particle.BreakingItemParticle;
import net.minecraft.client.entity.particle.BubbleParticle;
import net.minecraft.client.entity.particle.ExplodeParticle;
import net.minecraft.client.entity.particle.FireflyParticle;
import net.minecraft.client.entity.particle.FlameParticle;
import net.minecraft.client.entity.particle.FluidDripParticle;
import net.minecraft.client.entity.particle.FootstepParticle;
import net.minecraft.client.entity.particle.GoldenArrowParticle;
import net.minecraft.client.entity.particle.HeartParticle;
import net.minecraft.client.entity.particle.LavaParticle;
import net.minecraft.client.entity.particle.LeafParticle;
import net.minecraft.client.entity.particle.NoteParticle;
import net.minecraft.client.entity.particle.ParticleLambda;
import net.minecraft.client.entity.particle.PortalParticle;
import net.minecraft.client.entity.particle.RedstoneDustParticle;
import net.minecraft.client.entity.particle.SlimeChunkParticle;
import net.minecraft.client.entity.particle.SmokeParticle;
import net.minecraft.client.entity.particle.SnowShovelParticle;
import net.minecraft.client.entity.particle.SplashParticle;
import net.minecraft.client.entity.particle.TerrainParticle;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.util.dispatch.Dispatcher;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.animal.FireflyClusterMob;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.BlockParticleHelper;
import net.minecraft.core.util.helper.MathHelper;

public final class ParticleDispatcher
extends Dispatcher<String, ParticleLambda> {
    private static final ParticleDispatcher INSTANCE = new ParticleDispatcher();
    private static final ParticleLambda BLANK = (world, x, y, z, motionX, motionY, motionZ, data) -> null;

    public static ParticleDispatcher getInstance() {
        return INSTANCE;
    }

    public List<String> getParticleIds() {
        return new ArrayList<String>(this.dispatches.keySet());
    }

    @Override
    protected ParticleLambda getDefault() {
        return BLANK;
    }

    private ParticleDispatcher() {
        Minecraft mc = Minecraft.getMinecraft(this);
        this.addDispatch("bubble", (world, x, y, z, motionX, motionY, motionZ, data) -> new BubbleParticle(world, x, y, z, motionX, motionY, motionZ, true));
        this.addDispatch("smoke", (world, x, y, z, motionX, motionY, motionZ, data) -> new SmokeParticle(world, x, y, z, motionX, motionY, motionX));
        this.addDispatch("note", (world, x, y, z, motionX, motionY, motionZ, data) -> new NoteParticle(world, x, y, z, motionX, motionY, motionX, data));
        this.addDispatch("portal", (world, x, y, z, motionX, motionY, motionZ, data) -> new PortalParticle(world, x, y, z, motionX, motionY, motionX));
        this.addDispatch("explode", (world, x, y, z, motionX, motionY, motionZ, data) -> new ExplodeParticle(world, x, y, z, motionX, motionY, motionX));
        this.addDispatch("flame", (world, x, y, z, motionX, motionY, motionZ, data) -> new FlameParticle(world, x, y, z, motionX, motionY, motionX, FlameParticle.Type.ORANGE));
        this.addDispatch("blueflame", (world, x, y, z, motionX, motionY, motionZ, data) -> new FlameParticle(world, x, y, z, motionX, motionY, motionX, FlameParticle.Type.BLUE));
        this.addDispatch("soulflame", (world, x, y, z, motionX, motionY, motionZ, data) -> new FlameParticle(world, x, y, z, motionX, motionY, motionX, FlameParticle.Type.SOUL));
        this.addDispatch("lava", (world, x, y, z, motionX, motionY, motionZ, data) -> new LavaParticle(world, x, y, z));
        this.addDispatch("footstep", (world, x, y, z, motionX, motionY, motionZ, data) -> new FootstepParticle(mc.textureManager, world, x, y, z));
        this.addDispatch("splash", (world1, d, d1, d2, d3, d4, d5, data) -> new SplashParticle(world1, d, d1, d2, d3, d4, d5));
        this.addDispatch("largesmoke", (world, x, y, z, motionX, motionY, motionZ, data) -> new SmokeParticle(world, x, y, z, motionX, motionY, motionX, 2.5f));
        this.addDispatch("reddust", (world, x, y, z, motionX, motionY, motionZ, data) -> new RedstoneDustParticle(world, x, y, z, (float)motionX, (float)motionY, (float)motionZ, data));
        this.addDispatch("item", (world, x, y, z, motionX, motionY, motionZ, data) -> new BreakingItemParticle(world, x, y, z, Item.itemsList[MathHelper.clamp(data, 0, Item.itemsList.length - 1)]));
        this.addDispatch("block", (world, x, y, z, motionX, motionY, motionZ, data) -> new TerrainParticle(world, x, y, z, motionX, motionY, motionZ, Block.blocksList[BlockParticleHelper.decodeBlockID(data)], BlockParticleHelper.decodeBlockSide(data), BlockParticleHelper.decodeBlockMeta(data)).init((int)x, (int)y, (int)z));
        this.addDispatch("snowshovel", (world, x, y, z, motionX, motionY, motionZ, data) -> new SnowShovelParticle(world, x, y, z, motionX, motionY, motionX));
        this.addDispatch("heart", (world, x, y, z, motionX, motionY, motionZ, data) -> new HeartParticle(world, x, y, z, motionX, motionY, motionX));
        this.addDispatch("slimechunk", (world, x, y, z, motionX, motionY, motionZ, data) -> {
            if (((Boolean)mc.gameSettings.slimeParticles.value).booleanValue()) {
                return new SlimeChunkParticle(world, x, y, z, Items.SLIMEBALL);
            }
            return null;
        });
        this.addDispatch("fireflyGreen", (world, x, y, z, motionX, motionY, motionZ, data) -> new FireflyParticle(world, x, y, z, motionX, motionY, motionX, FireflyClusterMob.FireflyColor.GREEN.getId()));
        this.addDispatch("fireflyBlue", (world, x, y, z, motionX, motionY, motionZ, data) -> new FireflyParticle(world, x, y, z, motionX, motionY, motionX, FireflyClusterMob.FireflyColor.BLUE.getId()));
        this.addDispatch("fireflyOrange", (world, x, y, z, motionX, motionY, motionZ, data) -> new FireflyParticle(world, x, y, z, motionX, motionY, motionX, FireflyClusterMob.FireflyColor.ORANGE.getId()));
        this.addDispatch("fireflyRed", (world, x, y, z, motionX, motionY, motionZ, data) -> new FireflyParticle(world, x, y, z, motionX, motionY, motionX, FireflyClusterMob.FireflyColor.RED.getId()));
        this.addDispatch("arrowtrail", (world, x, y, z, motionX, motionY, motionZ, data) -> new GoldenArrowParticle(world, x, y, z, motionX, motionY, motionX));
        this.addDispatch("fallingleaf", (world, x, y, z, motionX, motionY, motionZ, data) -> {
            int id = world.getBlockId(MathHelper.floor(x), MathHelper.floor(y), MathHelper.floor(z));
            if (id != 0) {
                return new LeafParticle(world, x, y, z, motionX, motionY, motionX).init(MathHelper.floor(x), MathHelper.floor(y), MathHelper.floor(z));
            }
            return null;
        });
        this.addDispatch("dripWater", (world, x, y, z, motionX, motionY, motionZ, data) -> {
            int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(Blocks.FLUID_WATER_STILL)).getWorldColor(world, MathHelper.floor(x), MathHelper.floor(y), MathHelper.floor(z));
            return new FluidDripParticle(world, x, y, z, color, TextureRegistry.getTexture("minecraft:block/water_flowing"));
        });
        this.addDispatch("dripLava", (world, x, y, z, motionX, motionY, motionZ, data) -> new FluidDripParticle(world, x, y, z, 0xFFFFFF, TextureRegistry.getTexture("minecraft:block/lava_flowing")).setFullBright());
    }
}

