/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.particle;

import net.minecraft.client.entity.particle.Particle;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class RedstoneDustParticle
extends Particle {
    private final float oSize;
    private int brightness = -1;

    public RedstoneDustParticle(World world, double x, double y, double z, float red, float green, float blue, int brightness) {
        this(world, x, y, z, 1.0f, red, green, blue, brightness);
    }

    public RedstoneDustParticle(World world, double x, double y, double z, float scale, float red, float green, float blue, int brightness) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        if (brightness >= 0) {
            this.brightness = brightness;
        }
        this.xd *= 0.1;
        this.yd *= 0.1;
        this.zd *= 0.1;
        float n = (float)Math.random() * 0.4f + 0.6f;
        this.rCol = ((float)(Math.random() * 0.2) + 0.8f) * red * n;
        this.gCol = ((float)(Math.random() * 0.2) + 0.8f) * green * n;
        this.bCol = ((float)(Math.random() * 0.2) + 0.8f) * blue * n;
        this.size *= 0.75f;
        this.size *= scale;
        this.oSize = this.size;
        this.lifetime = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        this.lifetime *= (int)scale;
        this.noPhysics = false;
    }

    @Override
    public void render(Tessellator t, float partialTick, double xOff, double yOff, double zOff, float xa, float ya, float za, float xa2, float za2) {
        float l = ((float)this.age + partialTick) / (float)this.lifetime * 32.0f;
        if (l < 0.0f) {
            l = 0.0f;
        }
        if (l > 1.0f) {
            l = 1.0f;
        }
        this.size = this.oSize * l;
        if (this.tex == null) {
            return;
        }
        float u0 = (float)this.tex.getIconUMin();
        float u2 = (float)this.tex.getSubIconU(1.0);
        float v0 = (float)this.tex.getIconVMin();
        float v2 = (float)this.tex.getSubIconV(1.0);
        float r = 0.1f * this.size;
        float x = (float)(this.xo + (this.x - this.xo) * (double)partialTick - xOff);
        float y = (float)(this.yo + (this.y - this.yo) * (double)partialTick - yOff);
        float z = (float)(this.zo + (this.z - this.zo) * (double)partialTick - zOff);
        float br = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            int xTile = MathHelper.floor(this.x);
            int yTile = MathHelper.floor(this.y);
            int zTile = MathHelper.floor(this.z);
            int lmc = this.brightness >= 0 ? LightmapHelper.getLightmapCoord(this.world.getSavedLightValue(LightLayer.Sky, xTile, yTile, zTile), Math.max(this.world.getSavedLightValue(LightLayer.Block, xTile, yTile, zTile), this.brightness)) : this.getLightmapCoord(partialTick);
            t.setLightmapCoord(lmc);
        } else {
            br = Math.max(this.getBrightness(partialTick), (float)this.brightness / 15.0f);
        }
        t.setColorOpaque_F(this.rCol * br, this.gCol * br, this.bCol * br);
        t.addVertexWithUV(x - xa * r - xa2 * r, y - ya * r, z - za * r - za2 * r, u2, v2);
        t.addVertexWithUV(x - xa * r + xa2 * r, y + ya * r, z - za * r + za2 * r, u2, v0);
        t.addVertexWithUV(x + xa * r + xa2 * r, y + ya * r, z + za * r + za2 * r, u0, v0);
        t.addVertexWithUV(x + xa * r - xa2 * r, y - ya * r, z + za * r - za2 * r, u0, v2);
    }

    @Override
    public void tick() {
        int val;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.tex = (val = 7 - this.age * 8 / this.lifetime) >= 0 ? TextureRegistry.getTexture("minecraft:particle/puff_" + val) : null;
        this.move(this.xd, this.yd, this.zd);
        if (this.y == this.yo) {
            this.xd *= 1.1;
            this.zd *= 1.1;
        }
        this.xd *= 0.96;
        this.yd *= 0.96;
        this.zd *= 0.96;
        if (this.onGround) {
            this.xd *= 0.7;
            this.zd *= 0.7;
        }
    }
}

