/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.player;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.LocalPlayer;
import net.minecraft.client.gui.guidebook.GuidebookScreen;
import net.minecraft.client.net.handler.ClientPacketHandler;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.ItemEntity;
import net.minecraft.core.net.packet.AnimatePacket;
import net.minecraft.core.net.packet.ChatPacket;
import net.minecraft.core.net.packet.ContainerClosePacket;
import net.minecraft.core.net.packet.CustomPayloadPacket;
import net.minecraft.core.net.packet.GuidebookPacket;
import net.minecraft.core.net.packet.MovePlayerPacket;
import net.minecraft.core.net.packet.PlayerActionPacket;
import net.minecraft.core.net.packet.RespawnPacket;
import net.minecraft.core.net.packet.SetHotbarOffsetPacket;
import net.minecraft.core.net.packet.UpdateCreativeInventoryPacket;
import net.minecraft.core.net.packet.UpdatePlayerStatePacket;
import net.minecraft.core.player.Session;
import net.minecraft.core.util.helper.AES;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class MultiplayerLocalPlayer
extends LocalPlayer {
    public ClientPacketHandler sendQueue;
    private int lastInventorySendTime = 0;
    private boolean flashOnSetHealth = false;
    private double oldPosX;
    private double oldPosY1;
    private double oldPosY2;
    private double oldPosZ;
    private float oldRotationYaw;
    private float oldRotationPitch;
    private boolean wasOnGround = false;
    private boolean wasSneaking = false;
    private int noSendTime = 0;

    public MultiplayerLocalPlayer(Minecraft minecraft, World world, Session session, ClientPacketHandler netclienthandler) {
        super(minecraft, world, session, 0);
        this.sendQueue = netclienthandler;
    }

    @Override
    public boolean hurt(Entity attacker, int i, DamageType type) {
        return false;
    }

    @Override
    public void heal(int i) {
    }

    @Override
    public void tick() {
        if (!this.world.isBlockLoaded(MathHelper.floor(this.x), 64, MathHelper.floor(this.z))) {
            return;
        }
        super.tick();
        this.sendPosition();
    }

    public void sendPosition() {
        boolean flag2;
        boolean flag;
        if (this.lastInventorySendTime++ == 20) {
            this.sendInventoryChanged();
            this.lastInventorySendTime = 0;
        }
        if ((flag = this.isSneaking()) != this.wasSneaking) {
            if (flag) {
                this.sendQueue.addToSendQueue(new UpdatePlayerStatePacket(1));
            } else {
                this.sendQueue.addToSendQueue(new UpdatePlayerStatePacket(2));
            }
            this.wasSneaking = flag;
        }
        double d = this.x - this.oldPosX;
        double d1 = this.bb.minY - this.oldPosY1;
        double d2 = this.y - this.oldPosY2;
        double d3 = this.z - this.oldPosZ;
        double d4 = this.yRot - this.oldRotationYaw;
        double d5 = this.xRot - this.oldRotationPitch;
        boolean flag1 = d1 != 0.0 || d2 != 0.0 || d != 0.0 || d3 != 0.0;
        boolean bl = flag2 = d4 != 0.0 || d5 != 0.0;
        if (this.vehicle != null) {
            if (flag2) {
                this.sendQueue.addToSendQueue(new MovePlayerPacket.Pos(this.xd, -999.0, this.zd, this.onGround));
            } else {
                this.sendQueue.addToSendQueue(new MovePlayerPacket.PosRot(this.xd, -999.0, this.zd, this.yRot, this.xRot, this.onGround));
            }
            flag1 = false;
        } else if (flag1 && flag2) {
            this.sendQueue.addToSendQueue(new MovePlayerPacket.PosRot(this.x, this.bb.minY, this.z, this.yRot, this.xRot, this.onGround));
            this.noSendTime = 0;
        } else if (flag1) {
            this.sendQueue.addToSendQueue(new MovePlayerPacket.Pos(this.x, this.bb.minY, this.z, this.onGround));
            this.noSendTime = 0;
        } else if (flag2) {
            this.sendQueue.addToSendQueue(new MovePlayerPacket.Rot(this.yRot, this.xRot, this.onGround));
            this.noSendTime = 0;
        } else {
            this.sendQueue.addToSendQueue(new MovePlayerPacket(this.onGround));
            this.noSendTime = this.wasOnGround != this.onGround || this.noSendTime > 200 ? 0 : ++this.noSendTime;
        }
        this.wasOnGround = this.onGround;
        if (flag1) {
            this.oldPosX = this.x;
            this.oldPosY1 = this.bb.minY;
            this.oldPosY2 = this.y;
            this.oldPosZ = this.z;
        }
        if (flag2) {
            this.oldRotationYaw = this.yRot;
            this.oldRotationPitch = this.xRot;
        }
    }

    @Override
    public void dropCurrentItem(boolean dropFullStack) {
        this.sendQueue.addToSendQueue(new PlayerActionPacket(dropFullStack ? 5 : 4, 0, 0, 0, Side.NONE, 0.0, 0.0));
    }

    private void sendInventoryChanged() {
    }

    @Override
    protected void joinEntityItemWithWorld(ItemEntity entityitem) {
    }

    @Override
    public void sendChatMessage(String s) {
        this.sendQueue.addToSendQueue(new ChatPacket(s, AES.clientKeyChain));
        this.addToSendHistory(s);
    }

    @Override
    public void updateCreativeInventory(int page, String searchText) {
        this.sendQueue.addToSendQueue(new UpdateCreativeInventoryPacket(this.craftingInventory.containerId, page, searchText));
    }

    @Override
    public void setHotbarOffset(int offset) {
        super.setHotbarOffset(offset);
        this.sendQueue.addToSendQueue(new SetHotbarOffsetPacket(offset));
    }

    @Override
    public void displayGuidebookScreen() {
        this.mc.displayScreen(new GuidebookScreen(this.mc.currentScreen));
        this.sendQueue.addToSendQueue(new GuidebookPacket(this.mc.currentScreen instanceof GuidebookScreen));
    }

    @Override
    public void swingItem() {
        super.swingItem();
        this.sendQueue.addToSendQueue(new AnimatePacket(this, 1));
    }

    @Override
    public void respawnPlayer() {
        this.sendInventoryChanged();
        this.sendQueue.addToSendQueue(new RespawnPacket((byte)this.dimension, (byte)Registries.WORLD_TYPES.getNumericIdOfItem(this.world.worldType)));
    }

    @Override
    protected void damageEntity(int i, DamageType damageType) {
        this.setHealthRaw(this.getHealth() - i);
    }

    @Override
    public void closeScreen() {
        this.sendQueue.addToSendQueue(new ContainerClosePacket(this.craftingInventory.containerId));
        this.inventory.setHeldItemStack(null);
        super.closeScreen();
    }

    @Override
    public void setHealth(int i) {
        if (this.flashOnSetHealth) {
            super.setHealth(i);
        } else {
            this.setHealthRaw(i);
            this.flashOnSetHealth = true;
        }
    }

    @Override
    public void addStat(Stat stat, int i) {
        if (stat == null) {
            return;
        }
        if (stat.clientside) {
            super.addStat(stat, i);
        }
    }

    @Override
    public int getStat(Stat stat) {
        if (stat.clientside) {
            return super.getStat(stat);
        }
        return 0;
    }

    @Override
    public void syncPlacementMode() {
        super.syncPlacementMode();
        byte[] data = new byte[]{(byte)(this.rotationLock != null ? this.rotationLock.getId() : -1), (byte)(this.rotationLockHorizontal != null ? this.rotationLockHorizontal.getId() : -1), (byte)(this.rotationLockVertical != null ? this.rotationLockVertical.getId() : -1), (byte)(this.placementModeOverride != null ? this.placementModeOverride.index() : -1)};
        this.sendQueue.addToSendQueue(new CustomPayloadPacket("BTA|RotationLock", data));
    }

    @Override
    public void pickBlock(int x, int y, int z) {
        this.sendQueue.addToSendQueue(new PlayerActionPacket(6, x, y, z, Side.NONE, 0.0, 0.0));
    }
}

