/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.input.controller.Button;
import net.minecraft.client.input.controller.ControllerInput;

public class ControllerGlyphElement
extends Gui {
    private final Minecraft minecraft;

    public ControllerGlyphElement(Minecraft minecraft) {
        this.minecraft = minecraft;
    }

    public void drawButton(ControllerInput controller, Button button, int x, int y, boolean pressed) {
        int u = this.getButtonU(controller, button);
        int v = this.getButtonV(controller, button);
        int sizeU = this.getButtonSizeU(controller, button);
        int sizeV = this.getButtonSizeV(controller, button);
        int vOffset = 0;
        if (pressed) {
            vOffset = sizeV;
        }
        this.minecraft.textureManager.loadTexture("/assets/minecraft/textures/gui/controller/" + controller.getType().getAssetName() + ".png").bind();
        this.drawTexturedModalRect(x, y, u, v + vOffset, sizeU, sizeV);
    }

    public void drawDPad(ControllerInput controllerInput, int x, int y, boolean up, boolean right, boolean down, boolean left) {
        int u = 0;
        int v = 72;
        int sizeU = 46;
        int sizeV = 46;
        this.minecraft.textureManager.loadTexture("/assets/minecraft/textures/gui/controller/" + controllerInput.getType().getAssetName() + ".png").bind();
        this.drawTexturedModalRect(x, y, u, v, sizeU, sizeV);
        if (up) {
            this.drawTexturedModalRect(x, y, 46, 72, 46, 15);
        }
        if (right) {
            this.drawTexturedModalRect(x + 31, y, 77, 72, 15, 46);
        }
        if (down) {
            this.drawTexturedModalRect(x, y + 31, 46, 103, 46, 15);
        }
        if (left) {
            this.drawTexturedModalRect(x, y, 46, 72, 15, 46);
        }
    }

    private int getButtonU(ControllerInput controller, Button button) {
        if (button == controller.buttonA || button == controller.digitalPad.up) {
            return 0;
        }
        if (button == controller.buttonB || button == controller.digitalPad.right) {
            return 18;
        }
        if (button == controller.buttonX || button == controller.digitalPad.down) {
            return 36;
        }
        if (button == controller.buttonY || button == controller.digitalPad.left) {
            return 54;
        }
        if (button == controller.buttonLeftShoulder) {
            return 97;
        }
        if (button == controller.buttonRightShoulder) {
            return 72;
        }
        if (button == controller.buttonLeftTrigger) {
            return 139;
        }
        if (button == controller.buttonRightTrigger) {
            return 122;
        }
        if (button == controller.buttonStart) {
            return 72;
        }
        if (button == controller.buttonBack) {
            return 87;
        }
        return 0;
    }

    private int getButtonV(ControllerInput controller, Button button) {
        if (button == controller.buttonA || button == controller.buttonB || button == controller.buttonX || button == controller.buttonY || button == controller.buttonLeftShoulder || button == controller.buttonRightShoulder || button == controller.buttonLeftTrigger || button == controller.buttonRightTrigger) {
            return 0;
        }
        if (button == controller.digitalPad.up || button == controller.digitalPad.right || button == controller.digitalPad.down || button == controller.digitalPad.left) {
            return 36;
        }
        if (button == controller.buttonStart || button == controller.buttonBack) {
            return 26;
        }
        return 0;
    }

    public int getButtonSizeU(ControllerInput controller, Button button) {
        if (button == controller.buttonA || button == controller.buttonB || button == controller.buttonX || button == controller.buttonY || button == controller.digitalPad.up || button == controller.digitalPad.right || button == controller.digitalPad.down || button == controller.digitalPad.left) {
            return 18;
        }
        if (button == controller.buttonLeftShoulder || button == controller.buttonRightShoulder) {
            return 25;
        }
        if (button == controller.buttonLeftTrigger || button == controller.buttonRightTrigger) {
            return 17;
        }
        if (button == controller.buttonStart || button == controller.buttonBack) {
            return 15;
        }
        return 0;
    }

    public int getButtonSizeV(ControllerInput controller, Button button) {
        if (button == controller.buttonA || button == controller.buttonB || button == controller.buttonX || button == controller.buttonY || button == controller.digitalPad.up || button == controller.digitalPad.right || button == controller.digitalPad.down || button == controller.digitalPad.left) {
            return 18;
        }
        if (button == controller.buttonLeftShoulder || button == controller.buttonRightShoulder) {
            return 13;
        }
        if (button == controller.buttonLeftTrigger || button == controller.buttonRightTrigger) {
            return 15;
        }
        if (button == controller.buttonStart || button == controller.buttonBack) {
            return 15;
        }
        return 0;
    }
}

