/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.input.InputType;
import net.minecraft.client.input.controller.ControllerInput;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.util.debug.DebugRender;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Color;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class Screen
extends Gui {
    protected Minecraft mc;
    public int width;
    public int height;
    public List<ButtonElement> buttons = new ArrayList<ButtonElement>();
    public boolean passEvents = false;
    protected Font font;
    protected ButtonElement clickedButton = null;
    final Screen parentScreen;

    public Screen(Screen parent) {
        this.parentScreen = parent;
    }

    public Screen() {
        this(null);
    }

    public Screen getParentScreen() {
        return this.parentScreen;
    }

    public <E extends ButtonElement> E add(E button) {
        this.buttons.add(button);
        return button;
    }

    public void render(int xm, int ym, float partialTick) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            ButtonElement button = this.buttons.get(i);
            button.drawButton(this.mc, xm, ym);
        }
    }

    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey == Keyboard.KEY_BACK) {
            this.mc.displayScreen(this.parentScreen);
        }
        if (eventKey == Keyboard.KEY_ESCAPE) {
            this.mc.displayScreen(null);
        }
    }

    public void mouseClicked(int mx, int my, int buttonNum) {
        if (buttonNum == 0) {
            for (ButtonElement button : this.buttons) {
                if (!button.mouseClicked(this.mc, mx, my) || !button.playSound) continue;
                this.clickedButton = button;
                this.mc.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
                if (button.listener != null) {
                    button.listener.listen(button);
                } else {
                    this.buttonClicked(button);
                }
                return;
            }
        }
    }

    public void mouseReleased(int mx, int my, int buttonNum) {
        if (this.clickedButton != null && buttonNum == 0) {
            this.buttonReleased(this.clickedButton);
            this.clickedButton.mouseReleased(mx, my);
            this.clickedButton = null;
        }
    }

    protected void buttonClicked(ButtonElement button) {
    }

    protected void buttonReleased(ButtonElement button) {
    }

    public void opened(Minecraft mc, int width, int height) {
        this.mc = mc;
        this.font = mc.font;
        this.width = width;
        this.height = height;
        this.buttons.clear();
        this.init();
    }

    public void init() {
    }

    public void updateEvents() {
        int mouseX = Mouse.getEventX() * this.width / this.mc.resolution.getWidthScreenCoords();
        int mouseY = this.height - Mouse.getEventY() * this.height / this.mc.resolution.getHeightScreenCoords() - 1;
        while (Mouse.next() && this.mc.inputType != InputType.CONTROLLER) {
            if (Mouse.getEventButtonState()) {
                this.mouseClicked(mouseX, mouseY, Mouse.getEventButton());
                continue;
            }
            this.mouseReleased(mouseX, mouseY, Mouse.getEventButton());
        }
        while (Keyboard.next()) {
            if (Keyboard.getEventKeyState() && ((Boolean)this.mc.gameSettings.showFrameTimes.value).booleanValue() && DebugRender.keyPressed(Keyboard.getEventKey())) continue;
            int eventKey = Keyboard.getEventKey();
            char eventChar = Keyboard.getEventCharacter();
            if (eventKey == 0 && Character.isDefined(eventChar)) {
                this.keyPressed(eventChar, eventKey, mouseX, mouseY);
                return;
            }
            if (!Keyboard.getEventKeyState()) continue;
            if (eventKey == Keyboard.KEY_F11) {
                this.mc.gameWindow.toggleFullscreen();
                return;
            }
            this.keyPressed(eventChar, eventKey, mouseX, mouseY);
        }
    }

    public void tick() {
    }

    public void removed() {
    }

    public void renderBackground() {
        if (this.mc.theWorld != null) {
            int color = ((Color)this.mc.gameSettings.guiBackgroundColor.value).getARGB();
            this.drawGradientRect(0, 0, this.width, this.height, color, color);
        } else {
            this.renderTexturedBackground();
        }
    }

    public void renderTexturedBackground() {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        Tessellator tessellator = Tessellator.instance;
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/background.png").bind();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 32.0f;
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0x404040);
        tessellator.addVertexWithUV(0.0, this.height, 0.0, 0.0, (float)this.height / f);
        tessellator.addVertexWithUV(this.width, this.height, 0.0, (float)this.width / f, (float)this.height / f);
        tessellator.addVertexWithUV(this.width, 0.0, 0.0, (float)this.width / f, 0.0);
        tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.0);
        tessellator.draw();
    }

    public void drawControllerCursor() {
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
        this.drawGuiTexture(this.mc.textureManager, (int)(this.mc.controllerInput.cursorX - 8.0), (int)(this.mc.controllerInput.cursorY - 8.0), 16, 16, "/assets/minecraft/textures/gui/controller/cursor.png");
        GL11.glDisable((int)3042);
    }

    public void controllerInput(ControllerInput controller) {
        this.guiSpecificControllerInput(controller);
        this.playControllerButtonSound(controller);
    }

    public void playControllerButtonSound(ControllerInput controller) {
        if (controller.buttonA.pressedThisFrame() || controller.buttonX.pressedThisFrame() || controller.buttonY.pressedThisFrame()) {
            this.mc.sndManager.playSound("random.ui_click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
        }
        if (controller.buttonB.pressedThisFrame()) {
            this.mc.sndManager.playSound("random.ui_back", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
        }
    }

    public void guiSpecificControllerInput(ControllerInput controller) {
    }

    public boolean isPauseScreen() {
        return true;
    }

    public void selectNextField() {
    }

    public void updateFont() {
        this.font = this.mc.font;
    }
}

