/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.createworld;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.TextFieldElement;
import net.minecraft.client.gui.createworld.ButtonComponent;
import net.minecraft.client.gui.paged.CallbackComponent;
import net.minecraft.client.gui.paged.OnValueChangedCallback;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.lang.I18n;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class TextFieldComponent
implements CallbackComponent<String> {
    protected static final Minecraft mc = Minecraft.getMinecraft(ButtonComponent.class);
    protected static final int COMPONENT_SPACING = 2;
    private static final int BUTTON_WIDTH = 150;
    private final String translationKey;
    private final TextFieldElement textField;
    private OnValueChangedCallback<String> callback = null;

    public TextFieldComponent(String translationKey) {
        this.translationKey = translationKey;
        this.textField = new TextFieldElement(null, TextFieldComponent.mc.font, 0, 0, 150, 18, "", "");
    }

    @Override
    public int getHeight() {
        return 24;
    }

    @Override
    public void render(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        Font fr = TextFieldComponent.mc.font;
        String translated = I18n.getInstance().translateKey(this.translationKey);
        int textColor = -1;
        if (relativeMouseX >= 0 && relativeMouseX <= width && relativeMouseY >= 2 && relativeMouseY <= this.getHeight() - 2) {
            textColor = -96;
        }
        fr.drawStringWithShadow(translated, x, y + this.getHeight() / 2 - 4, textColor);
        int stringWidth = fr.getStringWidth(translated);
        int lineMaxX = x + width - 150 - 8;
        this.drawRect(x + stringWidth + 8, y + this.getHeight() / 2, lineMaxX, y + this.getHeight() / 2 + 1, 0x5F7F7F7F);
        this.textField.xPosition = x + width - 150;
        this.textField.yPosition = y + 2 + 1;
        this.textField.drawTextBox();
    }

    @Override
    public void onMouseClick(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        boolean mouseInside;
        boolean bl = mouseInside = relativeMouseX >= width - 150 && relativeMouseX <= width && relativeMouseY >= 2 && relativeMouseY <= 22;
        if (mouseInside) {
            this.textField.setFocused(true);
            Keyboard.enableRepeatEvents((boolean)true);
        } else {
            this.textField.setFocused(false);
            Keyboard.enableRepeatEvents((boolean)false);
        }
    }

    @Override
    public void onMouseMove(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
    }

    @Override
    public void onMouseRelease(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
    }

    @Override
    public void onKeyPress(int keyCode, char character) {
        if (this.textField.isFocused) {
            this.textField.textboxKeyTyped(character, keyCode);
        }
    }

    @Override
    public boolean matchesSearchTerm(String term) {
        return I18n.getInstance().translateKey(this.translationKey).toLowerCase().contains(term.toLowerCase());
    }

    protected void drawRect(int minX, int minY, int maxX, int maxY, int argb) {
        Tessellator tessellator = Tessellator.instance;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_I(argb & 0xFFFFFF, argb >> 24 & 0xFF);
        tessellator.addVertex(minX, maxY, 0.0);
        tessellator.addVertex(maxX, maxY, 0.0);
        tessellator.addVertex(maxX, minY, 0.0);
        tessellator.addVertex(minX, minY, 0.0);
        tessellator.draw();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    @Override
    public CallbackComponent<String> withOnValueChangedCallback(OnValueChangedCallback<String> callback) {
        this.callback = callback;
        return this;
    }
}

