/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.entity.particle.ParticleDispatcher;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.modelviewer.ModelViewerScreen;
import net.minecraft.client.gui.modelviewer.categories.ModelViewerCategory;
import net.minecraft.client.gui.modelviewer.categories.entries.particle.BlockFXEntry;
import net.minecraft.client.gui.modelviewer.categories.entries.particle.BubbleFXEntry;
import net.minecraft.client.gui.modelviewer.categories.entries.particle.GenericFXEntry;
import net.minecraft.client.gui.modelviewer.categories.entries.particle.ItemFXEntry;
import net.minecraft.client.gui.modelviewer.categories.entries.particle.LeafFXEntry;
import net.minecraft.client.gui.modelviewer.categories.entries.particle.NoteFXEntry;
import net.minecraft.client.gui.modelviewer.categories.entries.particle.ParticleEntry;
import net.minecraft.client.gui.modelviewer.categories.entries.particle.RedDustFXEntry;
import net.minecraft.client.gui.modelviewer.elements.ListenerSliderElement;
import net.minecraft.core.lang.I18n;

public class ParticleCategory
extends ModelViewerCategory {
    public Map<String, ParticleEntry> entryMap = new HashMap<String, ParticleEntry>();
    public List<ParticleEntry> entriesList;
    public double spawnRadius = 0.0;
    public ParticleEntry currentEntry;

    public ParticleCategory(ModelViewerScreen modelViewer) {
        super(modelViewer);
        this.initEntries();
        this.entriesList = new ArrayList<ParticleEntry>(this.entryMap.values());
        this.entriesList.sort(Comparator.comparing(o -> o.getParticleName(I18n.getInstance())));
    }

    private void initEntries() {
        for (String s : ParticleDispatcher.getInstance().getParticleIds()) {
            this.entryMap.put(s, new GenericFXEntry(s));
        }
        this.entryMap.put("bubble", new BubbleFXEntry());
        this.entryMap.put("note", new NoteFXEntry());
        this.entryMap.put("reddust", new RedDustFXEntry());
        this.entryMap.put("item", new ItemFXEntry());
        this.entryMap.put("block", new BlockFXEntry());
        this.entryMap.put("fallingleaf", new LeafFXEntry());
    }

    private void setCurrentEntry(ParticleEntry entry) {
        if (this.currentEntry != null) {
            this.currentEntry.onClose();
        }
        this.currentEntry = entry;
        if (this.currentEntry != null) {
            this.currentEntry.onOpen();
        }
    }

    @Override
    public String getCategoryNameKey() {
        return "model.category.particle.name";
    }

    @Override
    public String getCurrentDisplayInfo(I18n translator) {
        return translator.translateKeyAndFormat("model.category.particle.info", this.currentEntry.getParticleName(translator));
    }

    @Override
    public void addContextButtons(List<ButtonElement> buttonList) {
        ButtonElement lastButton = buttonList.get(buttonList.size() - 1);
        ListenerSliderElement radiusSlider = new ListenerSliderElement(-1, this.modelViewer.width - 120, lastButton.yPosition + 21, 120, 20, I18n.getInstance().translateKeyAndFormat("model.category.particle.radius.slider", Float.valueOf((float)((int)(this.spawnRadius * 100.0)) / 100.0f)), (float)this.spawnRadius);
        radiusSlider.setOnValueChanged(() -> {
            this.spawnRadius = radiusSlider.sliderValue;
            radiusSlider.displayString = I18n.getInstance().translateKeyAndFormat("model.category.particle.radius.slider", Float.valueOf((float)((int)(this.spawnRadius * 100.0)) / 100.0f));
        });
        buttonList.add(radiusSlider);
        int xPos = this.modelViewer.width;
        int yPos = radiusSlider.getY() + radiusSlider.getHeight() + 1;
        List<ButtonElement> buttons = this.currentEntry.getEntryButtons(this.mc, this.modelViewer);
        if (buttons != null) {
            for (ButtonElement button : buttons) {
                button.setX(button.getX() + xPos);
                button.setY(button.getY() + yPos);
            }
            buttonList.addAll(buttons);
        }
    }

    @Override
    public void cycleCategoryEntry(int offset) {
        this.setCurrentEntry(this.entriesList.get((this.entriesList.indexOf(this.currentEntry) + this.entriesList.size() + offset) % this.entriesList.size()));
        this.mc.particleEngine.setWorld(this.mc.theWorld);
        this.modelViewer.init();
    }

    @Override
    public void onOpen() {
        this.spawnRadius = 0.0;
        this.setCurrentEntry(this.entriesList.get(0));
    }

    @Override
    public void onClose() {
        this.mc.particleEngine.setWorld(this.mc.theWorld);
        this.currentEntry.onClose();
    }

    @Override
    public void onTick() {
        double offX = 0.0;
        double offY = 0.0;
        double offZ = 0.0;
        if (this.spawnRadius > 0.0) {
            offX = this.mc.theWorld.rand.nextDouble() - this.mc.theWorld.rand.nextDouble();
            offY = this.mc.theWorld.rand.nextDouble() - this.mc.theWorld.rand.nextDouble();
            offZ = this.mc.theWorld.rand.nextDouble() - this.mc.theWorld.rand.nextDouble();
        }
        this.currentEntry.spawnParticle(this.mc, this.mc.theWorld, this.mc.thePlayer.x + (offX *= this.spawnRadius), this.mc.thePlayer.y + (offY *= this.spawnRadius), this.mc.thePlayer.z + (offZ *= this.spawnRadius));
    }
}

