/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options.components;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.SwitchElement;
import net.minecraft.client.gui.options.components.ButtonComponent;
import net.minecraft.client.option.BooleanOption;

public class BooleanOptionComponent
extends ButtonComponent {
    private final BooleanOption option;
    private final SwitchElement button;

    public BooleanOptionComponent(BooleanOption option) {
        super("options." + option.name);
        this.option = option;
        this.button = new SwitchElement(0, 0, 0, 150, 20, (Boolean)this.option.value, "", "");
        this.button.setOn((Boolean)this.option.value);
        this.button.displayString = this.option.getDisplayStringValue();
    }

    @Override
    public void resetValue() {
        this.option.set((Boolean)this.option.getDefaultValue());
        this.button.setOn((Boolean)this.option.value);
        this.button.displayString = this.option.getDisplayStringValue();
        this.option.onUpdate();
    }

    @Override
    public void init(Minecraft mc) {
        this.button.setOn((Boolean)this.option.value);
        this.button.displayString = this.option.getDisplayStringValue();
    }

    @Override
    public boolean isDefault() {
        return ((Boolean)this.option.value).equals(this.option.getDefaultValue());
    }

    @Override
    protected void buttonClicked(int mouseButton, int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        this.option.toggle();
        this.option.onUpdate();
        this.button.setOn((Boolean)this.option.value);
        this.button.displayString = this.option.getDisplayStringValue();
    }

    @Override
    protected void renderButton(int x, int y, int relativeButtonX, int relativeButtonY, int buttonWidth, int buttonHeight, int relativeMouseX, int relativeMouseY) {
        super.renderButton(x, y, relativeButtonX, relativeButtonY, buttonWidth, buttonHeight, relativeMouseX, relativeMouseY);
        this.button.xPosition = x + relativeButtonX;
        this.button.yPosition = y + relativeButtonY;
        this.button.width = buttonWidth;
        this.button.height = buttonHeight;
        this.button.drawButton(mc, x + relativeMouseX, y + relativeMouseY);
    }
}

