/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.holiday;

import java.time.Month;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.minecraft.client.holiday.Holidays;

public class Holiday {
    protected int month;
    protected int day;
    protected String resourcePath = null;

    public Holiday(Month month, int day) {
        this.month = month.ordinal();
        this.day = day;
        Holidays.allHolidays.add(this);
    }

    public Holiday setCustomResourcePath(String path) {
        if (path == null) {
            Holidays.allThemedHolidays.remove(this);
        } else {
            Holidays.allThemedHolidays.add(this);
        }
        this.resourcePath = path;
        return this;
    }

    public boolean hasCustomResources() {
        return this.resourcePath != null;
    }

    public String getCustomResourcesSubPath() {
        return this.resourcePath;
    }

    public boolean isActive() {
        Calendar c = Holiday.getLocalCalendar();
        return c.get(2) == this.month && c.get(5) == this.day;
    }

    public static Calendar getLocalCalendar() {
        return Calendar.getInstance(TimeZone.getTimeZone(ZoneId.systemDefault()), Locale.getDefault());
    }

    public static Date getLocalDate(int year, int month, int day) {
        Calendar c = Holiday.getLocalCalendar();
        c.set(year, month, day);
        return c.getTime();
    }
}

