/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.LeavesBlockModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.FloweringCherryLeavesBlock;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class FloweringCherryLeavesBlockModel<T extends Block>
extends LeavesBlockModel<T> {
    private final IconCoordinate grownCherryOverlay = TextureRegistry.getTexture("minecraft:block/leaves/cherry_overlay");
    private final IconCoordinate floweringCherryOverlay = TextureRegistry.getTexture("minecraft:block/leaves/cherry_flowering_overlay");

    public FloweringCherryLeavesBlockModel(Block block) {
        super(block, "minecraft:block/leaves/cherry");
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        super.render(tessellator, x, y, z);
        int growthRate = FloweringCherryLeavesBlock.getGrowthRate(FloweringCherryLeavesBlockModel.renderBlocks.blockAccess.getBlockMetadata(x, y, z));
        FloweringCherryLeavesBlockModel.renderBlocks.overrideBlockTexture = growthRate > 0 ? this.grownCherryOverlay : this.floweringCherryOverlay;
        this.renderStandardBlock(tessellator, this.block, x, y, z, 1.0f, 1.0f, 1.0f);
        FloweringCherryLeavesBlockModel.renderBlocks.overrideBlockTexture = null;
        return true;
    }

    @Override
    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        super.renderBlockOnInventory(tessellator, metadata, brightness, alpha, lightmapCoordinate);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        IconCoordinate cherryCoord = this.grownCherryOverlay;
        GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        this.renderBottomFace(tessellator, this.block, 0.0, 0.0, 0.0, cherryCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        this.renderTopFace(tessellator, this.block, 0.0, 0.0, 0.0, cherryCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        this.renderNorthFace(tessellator, this.block, 0.0, 0.0, 0.0, cherryCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        this.renderSouthFace(tessellator, this.block, 0.0, 0.0, 0.0, cherryCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        this.renderWestFace(tessellator, this.block, 0.0, 0.0, 0.0, cherryCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        this.renderEastFace(tessellator, this.block, 0.0, 0.0, 0.0, cherryCoord);
        tessellator.draw();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }
}

