/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.StandardBlockModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.piston.PistonBaseBlock;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import org.jetbrains.annotations.Nullable;

public class PistonBlockModel<T extends PistonBaseBlock>
extends StandardBlockModel<T> {
    private final IconCoordinate faceTexture;
    protected IconCoordinate sideTexture = TextureRegistry.getTexture("minecraft:block/piston/side");
    protected IconCoordinate topTexture = TextureRegistry.getTexture("minecraft:block/piston/top");
    protected IconCoordinate bottomTexture = TextureRegistry.getTexture("minecraft:block/piston/bottom");
    protected final double headThickness;

    public PistonBlockModel(Block block, IconCoordinate faceTexture) {
        this(block, faceTexture, 0.25);
    }

    public PistonBlockModel(Block block, IconCoordinate faceTexture, double headThickness) {
        super(block);
        this.headThickness = headThickness;
        this.faceTexture = faceTexture;
    }

    public PistonBlockModel<T> setPistonTextures(IconCoordinate sideTexture, IconCoordinate topTexture, IconCoordinate bottomTexture) {
        this.sideTexture = sideTexture;
        this.topTexture = topTexture;
        this.bottomTexture = bottomTexture;
        return this;
    }

    public PistonBlockModel<T> setPistonTextures(String sideTexture, String topTexture, String bottomTexture) {
        return this.setPistonTextures(TextureRegistry.getTexture(sideTexture), TextureRegistry.getTexture(topTexture), TextureRegistry.getTexture(bottomTexture));
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        ((PistonBaseBlock)this.block).setBlockBoundsBasedOnState(PistonBlockModel.renderBlocks.blockAccess, x, y, z);
        return this.renderPistonBase(tessellator, x, y, z, false);
    }

    public boolean renderHeadless(Tessellator tessellator, int x, int y, int z) {
        PistonBlockModel.renderBlocks.renderAllFaces = true;
        boolean result = this.renderPistonBase(tessellator, x, y, z, true);
        PistonBlockModel.renderBlocks.renderAllFaces = false;
        return result;
    }

    protected boolean renderPistonBase(Tessellator tessellator, int x, int y, int z, boolean noCulling) {
        int meta = PistonBlockModel.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        boolean extended = noCulling || (meta & 8) != 0;
        Direction direction = PistonBaseBlock.getDirection(meta);
        if (extended) {
            switch (direction) {
                case DOWN: {
                    PistonBlockModel.renderBlocks.uvRotateEast = 3;
                    PistonBlockModel.renderBlocks.uvRotateWest = 3;
                    PistonBlockModel.renderBlocks.uvRotateSouth = 3;
                    PistonBlockModel.renderBlocks.uvRotateNorth = 3;
                    ((PistonBaseBlock)this.block).setBlockBounds(0.0, this.headThickness, 0.0, 1.0, 1.0, 1.0);
                    break;
                }
                case UP: {
                    ((PistonBaseBlock)this.block).setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0 - this.headThickness, 1.0);
                    break;
                }
                case NORTH: {
                    PistonBlockModel.renderBlocks.uvRotateSouth = 1;
                    PistonBlockModel.renderBlocks.uvRotateNorth = 2;
                    ((PistonBaseBlock)this.block).setBlockBounds(0.0, 0.0, this.headThickness, 1.0, 1.0, 1.0);
                    break;
                }
                case SOUTH: {
                    PistonBlockModel.renderBlocks.uvRotateSouth = 2;
                    PistonBlockModel.renderBlocks.uvRotateNorth = 1;
                    PistonBlockModel.renderBlocks.uvRotateTop = 3;
                    PistonBlockModel.renderBlocks.uvRotateBottom = 3;
                    ((PistonBaseBlock)this.block).setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0 - this.headThickness);
                    break;
                }
                case WEST: {
                    PistonBlockModel.renderBlocks.uvRotateEast = 1;
                    PistonBlockModel.renderBlocks.uvRotateWest = 2;
                    PistonBlockModel.renderBlocks.uvRotateTop = 2;
                    PistonBlockModel.renderBlocks.uvRotateBottom = 1;
                    ((PistonBaseBlock)this.block).setBlockBounds(this.headThickness, 0.0, 0.0, 1.0, 1.0, 1.0);
                    break;
                }
                case EAST: {
                    PistonBlockModel.renderBlocks.uvRotateEast = 2;
                    PistonBlockModel.renderBlocks.uvRotateWest = 1;
                    PistonBlockModel.renderBlocks.uvRotateTop = 1;
                    PistonBlockModel.renderBlocks.uvRotateBottom = 2;
                    ((PistonBaseBlock)this.block).setBlockBounds(0.0, 0.0, 0.0, 1.0 - this.headThickness, 1.0, 1.0);
                }
            }
            this.renderStandardBlock(tessellator, this.block, x, y, z);
            this.resetRenderBlocks();
            ((PistonBaseBlock)this.block).setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        } else {
            switch (direction) {
                case DOWN: {
                    PistonBlockModel.renderBlocks.uvRotateEast = 3;
                    PistonBlockModel.renderBlocks.uvRotateWest = 3;
                    PistonBlockModel.renderBlocks.uvRotateSouth = 3;
                    PistonBlockModel.renderBlocks.uvRotateNorth = 3;
                    break;
                }
                case NORTH: {
                    PistonBlockModel.renderBlocks.uvRotateSouth = 1;
                    PistonBlockModel.renderBlocks.uvRotateNorth = 2;
                    break;
                }
                case SOUTH: {
                    PistonBlockModel.renderBlocks.uvRotateSouth = 2;
                    PistonBlockModel.renderBlocks.uvRotateNorth = 1;
                    PistonBlockModel.renderBlocks.uvRotateTop = 3;
                    PistonBlockModel.renderBlocks.uvRotateBottom = 3;
                    break;
                }
                case WEST: {
                    PistonBlockModel.renderBlocks.uvRotateEast = 1;
                    PistonBlockModel.renderBlocks.uvRotateWest = 2;
                    PistonBlockModel.renderBlocks.uvRotateTop = 2;
                    PistonBlockModel.renderBlocks.uvRotateBottom = 1;
                    break;
                }
                case EAST: {
                    PistonBlockModel.renderBlocks.uvRotateEast = 2;
                    PistonBlockModel.renderBlocks.uvRotateWest = 1;
                    PistonBlockModel.renderBlocks.uvRotateTop = 1;
                    PistonBlockModel.renderBlocks.uvRotateBottom = 2;
                }
            }
            this.renderStandardBlock(tessellator, this.block, x, y, z);
            this.resetRenderBlocks();
        }
        return true;
    }

    @Override
    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        super.renderBlockOnInventory(tessellator, 1, brightness, alpha, lightmapCoordinate);
    }

    public IconCoordinate getFaceTexture() {
        return this.faceTexture;
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        Direction direction = PistonBaseBlock.getDirection(data);
        if (direction == Direction.NONE) {
            return this.atlasIndices[0];
        }
        if (side.getDirection() == direction) {
            if (PistonBaseBlock.isPowered(data) || ((PistonBaseBlock)this.block).minX > 0.0 || ((PistonBaseBlock)this.block).minY > 0.0 || ((PistonBaseBlock)this.block).minZ > 0.0 || ((PistonBaseBlock)this.block).maxX < 1.0 || ((PistonBaseBlock)this.block).maxY < 1.0 || ((PistonBaseBlock)this.block).maxZ < 1.0) {
                return this.topTexture;
            }
            return this.atlasIndices[0];
        }
        return side.getDirection() != direction.getOpposite() ? this.sideTexture : this.bottomTexture;
    }
}

