/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.StandardBlockModel;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;

public class PlanksPaintedBlockModel<T extends Block>
extends StandardBlockModel<T> {
    public static final IconCoordinate[] texCoords = new IconCoordinate[16];

    public PlanksPaintedBlockModel(Block block) {
        super(block);
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int meta) {
        return texCoords[meta & 0xF];
    }

    static {
        for (DyeColor c : DyeColor.blockOrderedColors()) {
            PlanksPaintedBlockModel.texCoords[c.blockMeta] = TextureRegistry.getTexture("minecraft:block/planks/" + c.colorID);
        }
    }
}

