/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.TrapDoorBlockModel;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.TrapDoorBlock;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.helper.Sides;

public class TrapDoorPaintedBlockModel<T extends Block>
extends TrapDoorBlockModel<T> {
    public static final IconCoordinate[] topTextures = new IconCoordinate[16];
    public static final IconCoordinate[] sideTextures = new IconCoordinate[16];

    public TrapDoorPaintedBlockModel(Block block) {
        super(block);
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        int color = data >> 4 & 0xF;
        int orientation = data & 3;
        if (TrapDoorBlock.isTrapdoorOpen(data)) {
            int index = Sides.orientationLookUpTrapdoorOpen[6 * orientation + side.getId()];
            if (index < 2) {
                return topTextures[color];
            }
            return sideTextures[color];
        }
        if (side.getAxis() == Axis.Y) {
            return topTextures[color];
        }
        return sideTextures[color];
    }

    static {
        for (DyeColor c : DyeColor.blockOrderedColors()) {
            TrapDoorPaintedBlockModel.topTextures[c.blockMeta] = TextureRegistry.getTexture("minecraft:block/trapdoor/planks_" + c.colorID + "/top");
            TrapDoorPaintedBlockModel.sideTextures[c.blockMeta] = TextureRegistry.getTexture("minecraft:block/trapdoor/planks_" + c.colorID + "/side");
        }
    }
}

