/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.StandardBlockModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.VeryRotatableEntityBlock;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import org.jetbrains.annotations.Nullable;

public class VeryRotatableBlockModel<T extends Block>
extends StandardBlockModel<T> {
    public VeryRotatableBlockModel(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        this.block.setBlockBoundsBasedOnState(VeryRotatableBlockModel.renderBlocks.blockAccess, x, y, z);
        int meta = VeryRotatableBlockModel.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        Direction dir = VeryRotatableEntityBlock.metaToDirection(meta);
        if (dir == Direction.DOWN || dir == Direction.UP) {
            VeryRotatableBlockModel.renderBlocks.uvRotateSouth = 1;
            VeryRotatableBlockModel.renderBlocks.uvRotateNorth = 2;
        }
        boolean result = this.renderStandardBlock(tessellator, this.block, x, y, z);
        this.resetRenderBlocks();
        return result;
    }

    @Override
    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        super.renderBlockOnInventory(tessellator, 3, brightness, alpha, lightmapCoordinate);
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        return this.atlasIndices[this.getTextureIndex(side, data)];
    }

    public int getTextureIndex(Side side, int data) {
        Direction dir = VeryRotatableEntityBlock.metaToDirection(data);
        switch (dir) {
            case SOUTH: {
                return side.getId();
            }
            case EAST: {
                return side.getDirection().rotate(1).getId();
            }
            case NORTH: {
                return side.getDirection().rotate(2).getId();
            }
            case WEST: {
                return side.getDirection().rotate(3).getId();
            }
            case UP: {
                switch (side) {
                    case NORTH: {
                        return Side.TOP.getId();
                    }
                    case SOUTH: {
                        return Side.BOTTOM.getId();
                    }
                    case TOP: {
                        return Side.SOUTH.getId();
                    }
                    case BOTTOM: {
                        return Side.NORTH.getId();
                    }
                }
                return side.getId();
            }
            case DOWN: {
                switch (side) {
                    case NORTH: {
                        return Side.TOP.getId();
                    }
                    case SOUTH: {
                        return Side.BOTTOM.getId();
                    }
                    case TOP: {
                        return Side.NORTH.getId();
                    }
                    case BOTTOM: {
                        return Side.SOUTH.getId();
                    }
                }
                return side.getId();
            }
        }
        return 0;
    }
}

