/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.blockentity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.BlockEntityRenderDispatcher;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.PistonBlockModel;
import net.minecraft.client.render.block.model.PistonHeadBlockModel;
import net.minecraft.client.render.blockentity.BlockEntityRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.piston.MovingPistonBlockEntity;
import net.minecraft.core.block.piston.PistonHeadBlock;
import net.minecraft.core.block.piston.SteelPistonBaseBlock;
import net.minecraft.core.world.BlocksContainer;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;

public class PistonBlockEntityRenderer
extends BlockEntityRenderer<MovingPistonBlockEntity> {
    private RenderBlocks renderBlocks;
    private final Minecraft mc = Minecraft.getMinecraft(this);
    private BlocksContainer container = null;
    private RenderBlocks containerRenderBlock = null;

    @Override
    public void onWorldChanged(World world) {
        this.renderBlocks = new RenderBlocks(world);
    }

    @Override
    public void doRender(Tessellator tessellator, MovingPistonBlockEntity blockEntity, double x, double y, double z, float partialTick) {
        Block block = Block.blocksList[blockEntity.getMovedId()];
        if (block != null && blockEntity.getProgress(partialTick) < 1.0f) {
            if (this.container == null || this.container.world != blockEntity.worldObj) {
                this.container = new BlocksContainer(blockEntity.worldObj);
                this.containerRenderBlock = new RenderBlocks(this.container);
            }
            TextureRegistry.blockAtlas.bind();
            Lighting.disable();
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2884);
            if (this.mc.isAmbientOcclusionEnabled()) {
                GL11.glShadeModel((int)7425);
            } else {
                GL11.glShadeModel((int)7424);
            }
            tessellator.startDrawingQuads();
            tessellator.setTranslation((float)x - (float)blockEntity.x + blockEntity.getXOff(partialTick), (float)y - (float)blockEntity.y + blockEntity.getYOff(partialTick), (float)z - (float)blockEntity.z + blockEntity.getZOff(partialTick));
            if (block instanceof PistonHeadBlock && blockEntity.getProgress(partialTick) < 0.5f) {
                BlockModel.setRenderBlocks(this.renderBlocks);
                ((PistonHeadBlockModel)BlockModelDispatcher.getInstance().getDispatch(block)).renderPistonHeadNoCulling(tessellator, (PistonHeadBlock)block, blockEntity.x, blockEntity.y, blockEntity.z, false);
            } else if (blockEntity.isSourcePiston() && !blockEntity.isExtending()) {
                PistonHeadBlockModel blockModelPistonHead;
                PistonBlockModel pistonBase = (PistonBlockModel)BlockModelDispatcher.getInstance().getDispatch(block);
                BlockModel.setRenderBlocks(this.renderBlocks);
                if (block instanceof SteelPistonBaseBlock) {
                    blockModelPistonHead = (PistonHeadBlockModel)BlockModelDispatcher.getInstance().getDispatch(Blocks.PISTON_HEAD_STEEL);
                    blockModelPistonHead.setFaceTextureOverride(pistonBase.getFaceTexture());
                    blockModelPistonHead.renderPistonHeadNoCulling(tessellator, (PistonHeadBlock)Blocks.PISTON_HEAD_STEEL, blockEntity.x, blockEntity.y, blockEntity.z, blockEntity.getProgress(partialTick) < 0.5f);
                    blockModelPistonHead.setFaceTextureOverride(null);
                } else {
                    blockModelPistonHead = (PistonHeadBlockModel)BlockModelDispatcher.getInstance().getDispatch(Blocks.PISTON_HEAD);
                    blockModelPistonHead.setFaceTextureOverride(pistonBase.getFaceTexture());
                    blockModelPistonHead.renderPistonHeadNoCulling(tessellator, (PistonHeadBlock)Blocks.PISTON_HEAD, blockEntity.x, blockEntity.y, blockEntity.z, blockEntity.getProgress(partialTick) < 0.5f);
                    blockModelPistonHead.setFaceTextureOverride(null);
                }
                tessellator.setTranslation((float)x - (float)blockEntity.x, (float)y - (float)blockEntity.y, (float)z - (float)blockEntity.z);
                pistonBase.renderHeadless(tessellator, blockEntity.x, blockEntity.y, blockEntity.z);
            } else {
                BlockModel.setRenderBlocks(this.containerRenderBlock);
                this.container.setBlock(blockEntity.x, blockEntity.y, blockEntity.z, block.id, blockEntity.getMovedData(), blockEntity.getMovedEntity());
                ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(block)).renderNoCulling(Tessellator.instance, blockEntity.x, blockEntity.y, blockEntity.z);
                this.container.setLightReferenceEntity(null);
                this.container.clear();
            }
            tessellator.setTranslation(0.0, 0.0, 0.0);
            tessellator.draw();
            Lighting.enableLight();
            BlockEntity movedEntity = blockEntity.getMovedEntity();
            BlockEntityRenderer<BlockEntity> renderer = BlockEntityRenderDispatcher.instance.getRenderer(movedEntity);
            if (renderer != null) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)blockEntity.getXOff(partialTick), (float)blockEntity.getYOff(partialTick), (float)blockEntity.getZOff(partialTick));
                renderer.doRender(tessellator, movedEntity, x, y, z, partialTick);
                GL11.glPopMatrix();
            }
        }
    }
}

