/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.particle.FireflyParticle;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.entity.animal.FireflyClusterMob;
import org.lwjgl.opengl.GL11;

public class FireflyRenderer
extends EntityRenderer<FireflyClusterMob> {
    private final List<FireflyParticle> fireflies = new ArrayList<FireflyParticle>();
    private final Minecraft mc;
    private final Random rand = new Random(0L);
    private long lastTick;

    public FireflyRenderer() {
        for (int i = 0; i < 20; ++i) {
            FireflyParticle fx = new FireflyParticle(null, this.rand.nextFloat() - 0.5f, this.rand.nextFloat() - 0.5f, 0.0, 0.0, 0.0, 0.0, 0);
            fx.noPhysics = true;
            fx.setAge(this.rand.nextInt(20));
            this.fireflies.add(fx);
        }
        this.mc = Minecraft.getMinecraft(this);
        this.lastTick = System.currentTimeMillis();
    }

    @Override
    public void render(Tessellator tessellator, FireflyClusterMob parent, double x, double y, double z, float yaw, float partialTick) {
    }

    @Override
    public void renderPreview(Tessellator tessellator, FireflyClusterMob entity, double x, double y, double z, float yaw, float partialTick) {
        int i;
        super.renderPreview(tessellator, entity, x, y, z, yaw, partialTick);
        long currentTick = System.currentTimeMillis();
        int storedTicks = (int)((float)(currentTick - this.lastTick) / 50.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.75f, (float)0.0f);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3553);
        Lighting.disable();
        TextureRegistry.particleAtlas.bind();
        for (i = 0; i < this.fireflies.size(); ++i) {
            FireflyParticle firefly = this.fireflies.get(i);
            Tessellator t = Tessellator.instance;
            t.startDrawingQuads();
            firefly.renderParticleInGui(t, partialTick);
            t.draw();
            for (int j = 0; j < storedTicks; ++j) {
                firefly.tickGui();
                this.lastTick = currentTick;
            }
            if (!firefly.removed) continue;
            this.fireflies.remove(i);
            --i;
        }
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        if (this.fireflies.size() < 20) {
            for (i = this.fireflies.size(); i < 20; ++i) {
                if (this.rand.nextInt(4) == 0) continue;
                FireflyParticle fx = new FireflyParticle(null, this.rand.nextFloat() - 0.5f, this.rand.nextFloat() - 0.5f, 0.0, 0.0, 0.0, 0.0, entity.getColor().getId());
                fx.noPhysics = true;
                fx.setAge(this.rand.nextInt(20));
                this.fireflies.add(fx);
            }
        }
    }
}

