/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.model.BaseModel;
import net.minecraft.client.render.model.MinecartModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.vehicle.MinecartEntity;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3;
import org.lwjgl.opengl.GL11;

public class MinecartRenderer
extends EntityRenderer<MinecartEntity> {
    protected BaseModel modelMinecart;

    public MinecartRenderer() {
        this.shadowSize = 0.5f;
        this.modelMinecart = new MinecartModel();
    }

    @Override
    public void render(Tessellator tessellator, MinecartEntity minecart, double x, double y, double z, float yaw, float partialTick) {
        GL11.glPushMatrix();
        double lerpX = MathHelper.lerp(minecart.xo, minecart.x, (double)partialTick);
        double lerpY = MathHelper.lerp(minecart.yo, minecart.y, (double)partialTick);
        double lerpZ = MathHelper.lerp(minecart.zo, minecart.z, (double)partialTick);
        Vec3 vec3 = minecart.getPos(lerpX, lerpY, lerpZ);
        double lerpXRot = MathHelper.lerp(minecart.xRotO, minecart.xRot, partialTick);
        double renderX = x;
        double renderY = y;
        double renderZ = z;
        double renderYaw = yaw;
        boolean doAFlip = false;
        if (vec3 != null) {
            Vec3 realVecVec;
            double scalar = 0.3;
            Vec3 forVec = minecart.getPosOffs(lerpX, lerpY, lerpZ, 0.3);
            Vec3 backVec = minecart.getPosOffs(lerpX, lerpY, lerpZ, -0.3);
            if (forVec == null) {
                forVec = vec3;
            }
            if (backVec == null) {
                backVec = vec3;
            }
            renderX += vec3.x - lerpX;
            renderY += (forVec.y + backVec.y) / 2.0 - lerpY;
            renderZ += vec3.z - lerpZ;
            Vec3 velVec = backVec.add(-forVec.x, -forVec.y, -forVec.z);
            if (velVec.length() != 0.0) {
                velVec = velVec.normalize();
                renderYaw = Math.toDegrees(Math.atan2(velVec.z, velVec.x));
                lerpXRot = Math.atan(velVec.y) * 73.0;
            }
            doAFlip = velVec.dotProduct(realVecVec = Vec3.getTempVec3(minecart.xd, minecart.yd, minecart.zd)) < 0.0;
        }
        GL11.glTranslated((double)renderX, (double)renderY, (double)renderZ);
        GL11.glRotated((double)(180.0 - renderYaw), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)(-lerpXRot), (double)0.0, (double)0.0, (double)1.0);
        double hurtAngle = (float)minecart.timeSinceHit - partialTick;
        double currentDamage = (float)minecart.currentDamage - partialTick;
        if (currentDamage < 0.0) {
            currentDamage = 0.0;
        }
        if (hurtAngle > 0.0) {
            GL11.glRotated((double)(Math.sin(hurtAngle) * hurtAngle * currentDamage / 10.0 * (double)minecart.hurtDirection), (double)1.0, (double)0.0, (double)0.0);
        }
        if (minecart.type != 0) {
            TextureRegistry.blockAtlas.bind();
            float scale = 0.75f;
            GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
            GL11.glTranslatef((float)0.0f, (float)0.3125f, (float)0.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            float brightness = 1.0f;
            if (LightmapHelper.isLightmapEnabled()) {
                LightmapHelper.setLightmapCoord(minecart.getLightmapCoord(partialTick));
            } else if (!Global.accessor.isFullbrightEnabled()) {
                brightness = minecart.getBrightness(partialTick);
            }
            GL11.glPushMatrix();
            if (doAFlip) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            switch (minecart.type) {
                case 1: {
                    Block block = (minecart.typeMeta & 1) != 0 ? Blocks.CHEST_PLANKS_OAK_PAINTED : Blocks.CHEST_PLANKS_OAK;
                    ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(block)).renderBlockOnInventory(tessellator, minecart.typeMeta, brightness, null);
                    break;
                }
                case 2: {
                    if (minecart.fuel > 0) {
                        ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Blocks.FURNACE_STONE_ACTIVE)).renderBlockOnInventory(tessellator, 0, brightness, null);
                        break;
                    }
                    ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Blocks.FURNACE_STONE_IDLE)).renderBlockOnInventory(tessellator, 0, brightness, null);
                }
            }
            GL11.glPopMatrix();
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-0.3125f, (float)0.0f);
            GL11.glScalef((float)1.3333334f, (float)1.3333334f, (float)1.3333334f);
        }
        this.bindTexture("/assets/minecraft/textures/entity/cart.png");
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.modelMinecart.render(0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
    }

    private void drawDebugVec(Tessellator tessellator, Vec3 pos, Vec3 vec, double scale, float r, float g, float b, float a) {
        if (pos == null || vec == null) {
            return;
        }
        GL11.glLineWidth((float)10.0f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        tessellator.startDrawing(1);
        tessellator.setColorRGBA_F(r, g, b, a);
        tessellator.addVertex(pos.x, pos.y, pos.z);
        tessellator.addVertex(pos.x + vec.x * scale, pos.y + vec.y * scale, pos.z + vec.z * scale);
        tessellator.draw();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2896);
    }
}

