/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.item.model;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.ItemRenderer;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.item.model.StandardItemModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.BlockItem;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class BlockItemModel
extends StandardItemModel {
    private Block block;
    private BlockModel<Block> blockModel;

    public BlockItemModel(BlockItem blockItem) {
        super(blockItem, null);
        this.block = blockItem.getBlock();
        this.blockModel = (BlockModel)BlockModelDispatcher.getInstance().getDispatch(this.block);
        this.icon = this.blockModel.getBlockTextureFromSideAndMetadata(Side.NORTH, 0);
    }

    @Override
    @NotNull
    public IconCoordinate getIcon(@Nullable Entity entity, ItemStack itemStack) {
        return this.blockModel.getBlockTextureFromSideAndMetadata(Side.NORTH, itemStack.getMetadata());
    }

    @Override
    public void renderItemFirstPerson(Tessellator tessellator, ItemRenderer renderer, Player player, ItemStack stack, float partialTick) {
        Minecraft mc = Minecraft.getMinecraft(this);
        float brightness = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            int lightmapCoord = player.getLightmapCoord(partialTick);
            if (this.itemfullBright) {
                lightmapCoord = LightmapHelper.setBlocklightValue(lightmapCoord, 15);
            }
            LightmapHelper.setLightmapCoord(lightmapCoord);
        } else if (!mc.fullbright && !this.itemfullBright) {
            brightness = player.getBrightness(1.0f);
        }
        float distanceScale = 0.8f;
        float swingProgress = player.getSwingProgress(partialTick);
        float animationProgress2 = MathHelper.sin(swingProgress * (float)Math.PI);
        float animationProgress = MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)Math.PI);
        GL11.glTranslatef((float)(-animationProgress * 0.4f), (float)(MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)Math.PI * 2.0f) * 0.2f), (float)(-animationProgress2 * 0.2f));
        GL11.glTranslatef((float)0.56f, (float)(-0.52f - (1.0f - renderer.getEquippedProgress(partialTick)) * 0.6f), (float)-0.71999997f);
        GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnable((int)32826);
        float animationProgress3 = MathHelper.sin(swingProgress * swingProgress * (float)Math.PI);
        GL11.glRotatef((float)(-animationProgress3 * 20.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-animationProgress * 20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(-animationProgress * 80.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        float scale = 0.4f;
        GL11.glScalef((float)0.4f, (float)0.4f, (float)0.4f);
        if (this.blockModel.shouldItemRender3d()) {
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        this.renderItem(tessellator, renderer, stack, player, brightness, true);
    }

    @Override
    public void renderItem(Tessellator tessellator, ItemRenderer renderer, ItemStack itemstack, @Nullable Entity entity, float brightness, boolean handheldTransform) {
        if (((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Block.blocksList[itemstack.itemID])).shouldItemRender3d()) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            TextureRegistry.blockAtlas.bind();
            ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Block.blocksList[itemstack.itemID])).renderBlockOnInventory(tessellator, itemstack.getMetadata(), brightness, null);
            GL11.glDisable((int)3042);
        } else {
            super.renderItem(tessellator, renderer, itemstack, entity, brightness, handheldTransform);
        }
    }

    @Override
    public void heldTransformThirdPerson(ItemRenderer renderer, Entity entity, ItemStack itemStack) {
        if (itemStack.itemID < Block.blocksList.length && ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Block.blocksList[itemStack.itemID])).shouldItemRender3d()) {
            float scale = 0.375f;
            GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)-0.3125f);
            GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)0.375f, (float)-0.375f, (float)0.375f);
        } else {
            super.heldTransformThirdPerson(renderer, entity, itemStack);
        }
    }

    @Override
    public void renderItemIntoGui(Tessellator tessellator, Font font, TextureManager textureManager, ItemStack itemStack, int x, int y, float brightness, float alpha) {
        if (itemStack == null) {
            return;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2884);
        if (((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Block.blocksList[itemStack.itemID])).shouldItemRender3d()) {
            GL11.glBlendFunc((int)770, (int)771);
            TextureRegistry.blockAtlas.bind();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(x - 2), (float)(y + 3), (float)-3.0f);
            GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
            GL11.glTranslatef((float)1.0f, (float)0.5f, (float)1.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
            GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            if (this.useColor) {
                int color = this.getColor(itemStack);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                GL11.glColor4f((float)(r * brightness), (float)(g * brightness), (float)(b * brightness), (float)alpha);
            } else {
                GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
            }
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            BlockModel.renderBlocks.useInventoryTint = this.useColor;
            ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Block.blocksList[itemStack.itemID])).renderBlockOnInventory(tessellator, itemStack.getMetadata(), brightness, alpha, null);
            BlockModel.renderBlocks.useInventoryTint = true;
            GL11.glPopMatrix();
        } else {
            super.renderItemIntoGui(tessellator, font, textureManager, itemStack, x, y, brightness, alpha);
        }
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
    }

    @Override
    public void renderAsItemEntity(Tessellator tessellator, Entity entity, Random random, ItemStack itemstack, int renderCount, float yaw, float brightness, float partialTick) {
        if (Block.blocksList[itemstack.itemID] != null && ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Block.blocksList[itemstack.itemID])).shouldItemRender3d()) {
            GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
            TextureRegistry.blockAtlas.bind();
            float itemSize = this.blockModel.getItemRenderScale();
            GL11.glScalef((float)itemSize, (float)itemSize, (float)itemSize);
            for (int i = 0; i < renderCount; ++i) {
                GL11.glPushMatrix();
                if (i > 0) {
                    float rOffX = (random.nextFloat() * 2.0f - 1.0f) * 0.2f / itemSize;
                    float rOffY = (random.nextFloat() * 2.0f - 1.0f) * 0.2f / itemSize;
                    float rOffZ = (random.nextFloat() * 2.0f - 1.0f) * 0.2f / itemSize;
                    GL11.glTranslatef((float)rOffX, (float)rOffY, (float)rOffZ);
                }
                if (LightmapHelper.isLightmapEnabled()) {
                    brightness = 1.0f;
                    LightmapHelper.setLightmapCoord(entity.getLightmapCoord(partialTick));
                }
                if (Global.accessor.isFullbrightEnabled() || this.itemfullBright) {
                    brightness = 1.0f;
                }
                this.blockModel.renderBlockOnInventory(tessellator, itemstack.getMetadata(), brightness, null);
                GL11.glPopMatrix();
            }
        } else {
            super.renderAsItemEntity(tessellator, entity, random, itemstack, renderCount, yaw, brightness, partialTick);
        }
    }

    @Override
    public void renderItemInWorld(Tessellator tessellator, Entity entity, ItemStack itemStack, float brightness, float alpha, boolean worldTransform) {
        if (itemStack == null) {
            return;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2884);
        if (((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Block.blocksList[itemStack.itemID])).shouldItemRender3d()) {
            GL11.glBlendFunc((int)770, (int)771);
            TextureRegistry.blockAtlas.bind();
            if (this.useColor) {
                int color = this.getColor(itemStack);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                GL11.glColor4f((float)(r * brightness), (float)(g * brightness), (float)(b * brightness), (float)alpha);
            } else {
                GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
            }
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            BlockModel.renderBlocks.useInventoryTint = this.useColor;
            ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Block.blocksList[itemStack.itemID])).renderBlockOnInventory(tessellator, itemStack.getMetadata(), brightness, alpha, null);
            BlockModel.renderBlocks.useInventoryTint = true;
        } else {
            super.renderItemInWorld(tessellator, entity, itemStack, brightness, alpha, worldTransform);
        }
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
    }

    @Override
    public int getColor(ItemStack stack) {
        return ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getFallbackColor(stack.getMetadata());
    }
}

