/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import com.mojang.logging.LogUtils;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.EntityBlock;
import net.minecraft.core.block.IPaintable;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.entity.ChestBlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.player.inventory.container.CompoundContainer;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ChestBlock
extends EntityBlock
implements IPaintable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int directionBits = 3;
    public static final int directionOffset = 0;
    public static final int typeBits = 12;
    public static final int typeOffset = 2;

    public ChestBlock(String key, String namespaceId, int id, Material material) {
        super(key, namespaceId, id, material);
    }

    @Override
    public void onBlockPlacedByMob(World world, int x, int y, int z, @NotNull Side placeSide, Mob mob, double xPlaced, double yPlaced) {
        Direction direction = mob.getHorizontalPlacementDirection(placeSide).getOpposite();
        Type type = Type.SINGLE;
        if (mob.isSneaking() && placeSide.isHorizontal() && (mob.rotationLockHorizontal == null || mob.rotationLockHorizontal == Direction.NONE)) {
            int placedOnX = x;
            int placedOnZ = z;
            if (placeSide == Side.NORTH) {
                ++placedOnZ;
            }
            if (placeSide == Side.SOUTH) {
                --placedOnZ;
            }
            if (placeSide == Side.EAST) {
                --placedOnX;
            }
            if (placeSide == Side.WEST) {
                ++placedOnX;
            }
            if (ChestBlock.isSingleChest(world, placedOnX, y, placedOnZ)) {
                Direction direction2 = ChestBlock.getDirectionFromMeta(world.getBlockMetadata(placedOnX, y, placedOnZ));
                if (direction2 == Direction.NORTH) {
                    if (placeSide == Side.EAST) {
                        ChestBlock.setType(world, placedOnX, y, placedOnZ, Type.RIGHT);
                        type = Type.LEFT;
                        direction = direction2;
                    }
                    if (placeSide == Side.WEST) {
                        ChestBlock.setType(world, placedOnX, y, placedOnZ, Type.LEFT);
                        type = Type.RIGHT;
                        direction = direction2;
                    }
                }
                if (direction2 == Direction.EAST) {
                    if (placeSide == Side.SOUTH) {
                        ChestBlock.setType(world, placedOnX, y, placedOnZ, Type.RIGHT);
                        type = Type.LEFT;
                        direction = direction2;
                    }
                    if (placeSide == Side.NORTH) {
                        ChestBlock.setType(world, placedOnX, y, placedOnZ, Type.LEFT);
                        type = Type.RIGHT;
                        direction = direction2;
                    }
                }
                if (direction2 == Direction.SOUTH) {
                    if (placeSide == Side.EAST) {
                        ChestBlock.setType(world, placedOnX, y, placedOnZ, Type.LEFT);
                        type = Type.RIGHT;
                        direction = direction2;
                    }
                    if (placeSide == Side.WEST) {
                        ChestBlock.setType(world, placedOnX, y, placedOnZ, Type.RIGHT);
                        type = Type.LEFT;
                        direction = direction2;
                    }
                }
                if (direction2 == Direction.WEST) {
                    if (placeSide == Side.SOUTH) {
                        ChestBlock.setType(world, placedOnX, y, placedOnZ, Type.LEFT);
                        type = Type.RIGHT;
                        direction = direction2;
                    }
                    if (placeSide == Side.NORTH) {
                        ChestBlock.setType(world, placedOnX, y, placedOnZ, Type.RIGHT);
                        type = Type.LEFT;
                        direction = direction2;
                    }
                }
            }
        } else if (!mob.isSneaking()) {
            if (direction == Direction.NORTH) {
                if (ChestBlock.isSingleChestWithDirection(world, x - 1, y, z, direction) && !ChestBlock.isSingleChestWithDirection(world, x + 1, y, z, direction)) {
                    type = Type.LEFT;
                    ChestBlock.setType(world, x - 1, y, z, Type.RIGHT);
                }
                if (ChestBlock.isSingleChestWithDirection(world, x + 1, y, z, direction) && !ChestBlock.isSingleChestWithDirection(world, x - 1, y, z, direction)) {
                    type = Type.RIGHT;
                    ChestBlock.setType(world, x + 1, y, z, Type.LEFT);
                }
            }
            if (direction == Direction.EAST) {
                if (ChestBlock.isSingleChestWithDirection(world, x, y, z - 1, direction) && !ChestBlock.isSingleChestWithDirection(world, x, y, z + 1, direction)) {
                    type = Type.LEFT;
                    ChestBlock.setType(world, x, y, z - 1, Type.RIGHT);
                }
                if (ChestBlock.isSingleChestWithDirection(world, x, y, z + 1, direction) && !ChestBlock.isSingleChestWithDirection(world, x, y, z - 1, direction)) {
                    type = Type.RIGHT;
                    ChestBlock.setType(world, x, y, z + 1, Type.LEFT);
                }
            }
            if (direction == Direction.SOUTH) {
                if (ChestBlock.isSingleChestWithDirection(world, x - 1, y, z, direction) && !ChestBlock.isSingleChestWithDirection(world, x + 1, y, z, direction)) {
                    type = Type.RIGHT;
                    ChestBlock.setType(world, x - 1, y, z, Type.LEFT);
                }
                if (ChestBlock.isSingleChestWithDirection(world, x + 1, y, z, direction) && !ChestBlock.isSingleChestWithDirection(world, x - 1, y, z, direction)) {
                    type = Type.LEFT;
                    ChestBlock.setType(world, x + 1, y, z, Type.RIGHT);
                }
            }
            if (direction == Direction.WEST) {
                if (ChestBlock.isSingleChestWithDirection(world, x, y, z - 1, direction) && !ChestBlock.isSingleChestWithDirection(world, x, y, z + 1, direction)) {
                    type = Type.RIGHT;
                    ChestBlock.setType(world, x, y, z - 1, Type.LEFT);
                }
                if (ChestBlock.isSingleChestWithDirection(world, x, y, z + 1, direction) && !ChestBlock.isSingleChestWithDirection(world, x, y, z - 1, direction)) {
                    type = Type.LEFT;
                    ChestBlock.setType(world, x, y, z + 1, Type.RIGHT);
                }
            }
        }
        int meta = world.getBlockMetadata(x, y, z);
        meta = ChestBlock.getMetaWithDirection(meta, direction);
        meta = ChestBlock.getMetaWithType(meta, type);
        world.setBlockMetadata(x, y, z, meta);
    }

    @Override
    public void onBlockPlacedOnSide(World world, int x, int y, int z, @NotNull Side side, double xPlaced, double yPlaced) {
        Direction direction = side.getDirection();
        Type type = Type.SINGLE;
        if (direction == Direction.NORTH) {
            if (ChestBlock.isSingleChestWithDirection(world, x - 1, y, z, direction) && !ChestBlock.isSingleChestWithDirection(world, x + 1, y, z, direction)) {
                type = Type.LEFT;
                ChestBlock.setType(world, x - 1, y, z, Type.RIGHT);
            }
            if (ChestBlock.isSingleChestWithDirection(world, x + 1, y, z, direction) && !ChestBlock.isSingleChestWithDirection(world, x - 1, y, z, direction)) {
                type = Type.RIGHT;
                ChestBlock.setType(world, x + 1, y, z, Type.LEFT);
            }
        }
        if (direction == Direction.EAST) {
            if (ChestBlock.isSingleChestWithDirection(world, x, y, z - 1, direction) && !ChestBlock.isSingleChestWithDirection(world, x, y, z + 1, direction)) {
                type = Type.LEFT;
                ChestBlock.setType(world, x, y, z - 1, Type.RIGHT);
            }
            if (ChestBlock.isSingleChestWithDirection(world, x, y, z + 1, direction) && !ChestBlock.isSingleChestWithDirection(world, x, y, z - 1, direction)) {
                type = Type.RIGHT;
                ChestBlock.setType(world, x, y, z + 1, Type.LEFT);
            }
        }
        if (direction == Direction.SOUTH) {
            if (ChestBlock.isSingleChestWithDirection(world, x - 1, y, z, direction) && !ChestBlock.isSingleChestWithDirection(world, x + 1, y, z, direction)) {
                type = Type.RIGHT;
                ChestBlock.setType(world, x - 1, y, z, Type.LEFT);
            }
            if (ChestBlock.isSingleChestWithDirection(world, x + 1, y, z, direction) && !ChestBlock.isSingleChestWithDirection(world, x - 1, y, z, direction)) {
                type = Type.LEFT;
                ChestBlock.setType(world, x + 1, y, z, Type.RIGHT);
            }
        }
        if (direction == Direction.WEST) {
            if (ChestBlock.isSingleChestWithDirection(world, x, y, z - 1, direction) && !ChestBlock.isSingleChestWithDirection(world, x, y, z + 1, direction)) {
                type = Type.RIGHT;
                ChestBlock.setType(world, x, y, z - 1, Type.LEFT);
            }
            if (ChestBlock.isSingleChestWithDirection(world, x, y, z + 1, direction) && !ChestBlock.isSingleChestWithDirection(world, x, y, z - 1, direction)) {
                type = Type.LEFT;
                ChestBlock.setType(world, x, y, z + 1, Type.RIGHT);
            }
        }
        int meta = world.getBlockMetadata(x, y, z);
        meta = ChestBlock.getMetaWithDirection(meta, direction);
        meta = ChestBlock.getMetaWithType(meta, type);
        world.setBlockMetadata(x, y, z, meta);
    }

    public void checkIfOtherHalfExists(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        Type type = ChestBlock.getTypeFromMeta(meta);
        if (type != Type.SINGLE) {
            int otherMeta;
            Direction direction = ChestBlock.getDirectionFromMeta(meta);
            int otherChestX = x;
            int otherChestZ = z;
            if (direction == Direction.NORTH) {
                if (type == Type.LEFT) {
                    --otherChestX;
                }
                if (type == Type.RIGHT) {
                    ++otherChestX;
                }
            }
            if (direction == Direction.EAST) {
                if (type == Type.LEFT) {
                    --otherChestZ;
                }
                if (type == Type.RIGHT) {
                    ++otherChestZ;
                }
            }
            if (direction == Direction.SOUTH) {
                if (type == Type.LEFT) {
                    ++otherChestX;
                }
                if (type == Type.RIGHT) {
                    --otherChestX;
                }
            }
            if (direction == Direction.WEST) {
                if (type == Type.LEFT) {
                    ++otherChestZ;
                }
                if (type == Type.RIGHT) {
                    --otherChestZ;
                }
            }
            boolean valid = false;
            if (ChestBlock.isChest(world, otherChestX, y, otherChestZ) && ChestBlock.getDirectionFromMeta(otherMeta = world.getBlockMetadata(otherChestX, y, otherChestZ)) == direction) {
                Type otherType = ChestBlock.getTypeFromMeta(otherMeta);
                if (type == Type.LEFT && otherType == Type.RIGHT || type == Type.RIGHT && otherType == Type.LEFT) {
                    valid = true;
                }
            }
            if (!valid) {
                ChestBlock.setType(world, x, y, z, Type.SINGLE);
                world.markBlocksDirty(x, y, z, x, y, z);
            }
        }
    }

    public static void setDefaultDirection(World world, int x, int y, int z) {
        if (world.isClientSide) {
            return;
        }
        int bN = world.getBlockId(x, y, z - 1);
        int bS = world.getBlockId(x, y, z + 1);
        int bW = world.getBlockId(x - 1, y, z);
        int bE = world.getBlockId(x + 1, y, z);
        Direction direction = Direction.NORTH;
        if (Block.solid[bN] && !Block.solid[bS]) {
            direction = Direction.SOUTH;
        }
        if (Block.solid[bS] && !Block.solid[bN]) {
            direction = Direction.NORTH;
        }
        if (Block.solid[bW] && !Block.solid[bE]) {
            direction = Direction.EAST;
        }
        if (Block.solid[bE] && !Block.solid[bW]) {
            direction = Direction.WEST;
        }
        world.setBlockMetadataWithNotify(x, y, z, ChestBlock.getMetaWithType(ChestBlock.getMetaWithDirection(world.getBlockMetadata(x, y, z), direction), Type.SINGLE));
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        super.onNeighborBlockChange(world, x, y, z, blockId);
        this.checkIfOtherHalfExists(world, x, y, z);
    }

    public static boolean isChest(World world, int x, int y, int z) {
        return Block.blocksList[world.getBlockId(x, y, z)] instanceof ChestBlock;
    }

    public static boolean isSingleChest(World world, int x, int y, int z) {
        return ChestBlock.isChest(world, x, y, z) && ChestBlock.getTypeFromMeta(world.getBlockMetadata(x, y, z)) == Type.SINGLE;
    }

    public static boolean isSingleChestWithDirection(World world, int x, int y, int z, Direction direction) {
        int meta = world.getBlockMetadata(x, y, z);
        return ChestBlock.isChest(world, x, y, z) && ChestBlock.getTypeFromMeta(meta) == Type.SINGLE && ChestBlock.getDirectionFromMeta(meta) == direction;
    }

    @Override
    protected BlockEntity getNewBlockEntity() {
        return new ChestBlockEntity();
    }

    public void setDirection(World world, int x, int y, int z, Direction direction) {
        if (ChestBlock.isChest(world, x, y, z)) {
            world.setBlockMetadataWithNotify(x, y, z, ChestBlock.getMetaWithDirection(world.getBlockMetadata(x, y, z), direction));
        }
    }

    public static void setType(World world, int x, int y, int z, Type type) {
        if (ChestBlock.isChest(world, x, y, z)) {
            world.setBlockMetadataWithNotify(x, y, z, ChestBlock.getMetaWithType(world.getBlockMetadata(x, y, z), type));
        }
    }

    public static Direction getDirection(World world, int x, int y, int z) {
        if (ChestBlock.isChest(world, x, y, z)) {
            return ChestBlock.getDirectionFromMeta(world.getBlockMetadata(x, y, z));
        }
        return null;
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        if (world.isClientSide) {
            return true;
        }
        this.checkIfOtherHalfExists(world, x, y, z);
        player.displayContainerScreen(ChestBlock.getInventory(world, x, y, z));
        return true;
    }

    public static Container getInventory(World world, int x, int y, int z) {
        Container inventory = (Container)((Object)world.getBlockEntity(x, y, z));
        int meta = world.getBlockMetadata(x, y, z);
        meta = world.getBlockMetadata(x, y, z);
        Type type = ChestBlock.getTypeFromMeta(meta);
        if (type != Type.SINGLE) {
            int otherMeta;
            Container inv2 = null;
            Direction direction = ChestBlock.getDirectionFromMeta(meta);
            int otherChestX = x;
            int otherChestZ = z;
            if (direction == Direction.NORTH) {
                if (type == Type.LEFT) {
                    --otherChestX;
                }
                if (type == Type.RIGHT) {
                    ++otherChestX;
                }
            }
            if (direction == Direction.EAST) {
                if (type == Type.LEFT) {
                    --otherChestZ;
                }
                if (type == Type.RIGHT) {
                    ++otherChestZ;
                }
            }
            if (direction == Direction.SOUTH) {
                if (type == Type.LEFT) {
                    ++otherChestX;
                }
                if (type == Type.RIGHT) {
                    --otherChestX;
                }
            }
            if (direction == Direction.WEST) {
                if (type == Type.LEFT) {
                    ++otherChestZ;
                }
                if (type == Type.RIGHT) {
                    --otherChestZ;
                }
            }
            if (ChestBlock.isChest(world, otherChestX, y, otherChestZ) && ChestBlock.getDirectionFromMeta(otherMeta = world.getBlockMetadata(otherChestX, y, otherChestZ)) == direction) {
                Type otherType = ChestBlock.getTypeFromMeta(otherMeta);
                if (type == Type.LEFT && otherType == Type.RIGHT) {
                    inv2 = (Container)((Object)world.getBlockEntity(otherChestX, y, otherChestZ));
                }
                if (type == Type.RIGHT && otherType == Type.LEFT) {
                    inv2 = inventory;
                    inventory = (Container)((Object)world.getBlockEntity(otherChestX, y, otherChestZ));
                }
            }
            if (inv2 != null) {
                inventory = new CompoundContainer("Large Chest", inventory, inv2);
            }
        }
        return inventory;
    }

    public static int getMetaWithDirection(int meta, Direction direction) {
        if (direction == null) {
            return meta;
        }
        meta &= 0xFFFFFFFC;
        return meta |= direction.ordinal() << 0 & 3;
    }

    public static int getMetaWithType(int meta, Type type) {
        if (type == null) {
            return meta;
        }
        meta &= 0xFFFFFFF3;
        return meta |= type.ordinal() << 2 & 0xC;
    }

    public static Direction getDirectionFromMeta(int meta) {
        switch (meta &= 3) {
            case 0: {
                return Direction.NORTH;
            }
            case 1: {
                return Direction.EAST;
            }
            case 2: {
                return Direction.SOUTH;
            }
            case 3: {
                return Direction.WEST;
            }
        }
        return Direction.NONE;
    }

    public static Type getTypeFromMeta(int meta) {
        return Type.get(meta >> 2 & 3);
    }

    @Override
    public void setColor(World world, int x, int y, int z, DyeColor color) {
        int meta = world.getBlockMetadata(x, y, z);
        world.setBlockAndMetadata(x, y, z, Blocks.CHEST_PLANKS_OAK_PAINTED.id, meta);
        ((IPaintable)((Object)Blocks.CHEST_PLANKS_OAK_PAINTED)).setColor(world, x, y, z, color);
    }

    public static enum Type {
        SINGLE,
        LEFT,
        RIGHT;


        public static Type get(int i) {
            if (i < 0 || i >= Type.values().length) {
                i = 0;
            }
            return Type.values()[i];
        }
    }
}

