/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.TransparentBlock;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;

public class IceBlock
extends TransparentBlock {
    public IceBlock(String key, String namespaceId, int id) {
        super(key, namespaceId, id, Material.ice);
        this.friction = 0.98f;
        this.setTicking(true);
    }

    @Override
    public int getRenderLayer() {
        return 1;
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, BlockEntity blockEntity) {
        switch (dropCause) {
            case PICK_BLOCK: 
            case SILK_TOUCH: {
                return new ItemStack[]{new ItemStack(this)};
            }
        }
        return null;
    }

    @Override
    public void harvestBlock(World world, Player entityplayer, int x, int y, int z, int meta, BlockEntity blockEntity) {
        super.harvestBlock(world, entityplayer, x, y, z, meta, blockEntity);
        Material material = world.getBlockMaterial(x, y - 1, z);
        if (material.blocksMotion() || material.isLiquid()) {
            world.setBlockWithNotify(x, y, z, Blocks.FLUID_WATER_FLOWING.id);
        }
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (world.getSavedLightValue(LightLayer.Block, x, y, z) > 11 - Block.lightBlock[this.id]) {
            world.setBlockWithNotify(x, y, z, Blocks.FLUID_WATER_STILL.id);
        }
    }

    @Override
    public int getPistonPushReaction(World world, int x, int y, int z) {
        return 0;
    }
}

