/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.EntityBlock;
import net.minecraft.core.block.entity.ActivatorBlockEntity;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.entity.JukeboxBlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class JukeboxBlock
extends EntityBlock {
    public JukeboxBlock(String key, String namespaceId, int id) {
        super(key, namespaceId, id, Material.wood);
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        if (world.getBlockMetadata(x, y, z) == 0) {
            return false;
        }
        this.ejectRecord(world, x, y, z);
        return true;
    }

    @Override
    public void onActivatorInteract(World world, int x, int y, int z, ActivatorBlockEntity activator, Direction direction) {
        if (world.getBlockMetadata(x, y, z) != 0) {
            this.ejectRecord(world, x, y, z);
        }
    }

    public void playRecord(World world, int x, int y, int z, int recordId) {
        if (!world.isClientSide) {
            JukeboxBlockEntity jukebox = (JukeboxBlockEntity)world.getBlockEntity(x, y, z);
            jukebox.record = recordId;
            jukebox.setChanged();
            world.setBlockMetadataWithNotify(x, y, z, 1);
        }
    }

    public void ejectRecord(World world, int x, int y, int z) {
        if (world.isClientSide) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(x, y, z);
        blockEntity.dropContents(world, x, y, z);
    }

    @Override
    protected BlockEntity getNewBlockEntity() {
        return new JukeboxBlockEntity();
    }
}

