/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.FarmlandBlock;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.FallingBlockEntity;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;

public class MudBlock
extends Block {
    private final boolean isHardened;

    public MudBlock(String key, String namespaceId, int id, Material material, boolean isHardened) {
        super(key, namespaceId, id, material);
        this.isHardened = isHardened;
    }

    @Override
    public int tickDelay() {
        return 5;
    }

    @Override
    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
        world.scheduleBlockUpdate(x, y, z, this.id, this.tickDelay());
    }

    private boolean isWaterNearby(World world, int x, int y, int z, int range) {
        for (int x1 = x - range; x1 <= x + range; ++x1) {
            for (int y1 = y - range; y1 <= y + range; ++y1) {
                for (int z1 = z - range; z1 <= z + range; ++z1) {
                    if (!Block.hasTag(world.getBlockId(x1, y1, z1), BlockTags.IS_WATER)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isLavaNearby(World world, int x, int y, int z) {
        for (int x1 = x - 1; x1 <= x + 1; ++x1) {
            for (int y1 = y - 1; y1 <= y + 1; ++y1) {
                for (int z1 = z - 1; z1 <= z + 1; ++z1) {
                    if (!Block.hasTag(world.getBlockId(x1, y1, z1), BlockTags.IS_LAVA)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean canBecomeWet(World world, int x, int y, int z) {
        if (this.isWaterNearby(world, x, y, z, 1)) {
            return true;
        }
        if (this.isWaterNearby(world, x, y, z, 3)) {
            for (int x1 = x - 1; x1 <= x + 1; ++x1) {
                for (int y1 = y - 1; y1 <= y + 1; ++y1) {
                    for (int z1 = z - 1; z1 <= z + 1; ++z1) {
                        int bID = world.getBlockId(x1, y1, z1);
                        if (bID != Blocks.MUD.id && (bID != Blocks.FARMLAND_DIRT.id || !FarmlandBlock.isWet(world.getBlockMetadata(x1, y1, z1)))) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        world.scheduleBlockUpdate(x, y, z, this.id, this.tickDelay());
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, BlockEntity blockEntity) {
        return new ItemStack[]{new ItemStack(this, 1, meta)};
    }

    private void tryToFall(World world, int x, int y, int z) {
        if (world.getBlockId(x, y, z) == Blocks.MUD_BAKED.id) {
            return;
        }
        int x1 = x;
        int y1 = y;
        int z1 = z;
        if (MudBlock.canFallBelow(world, x1, y1 - 1, z1) && y1 >= 0) {
            int byte0 = 32;
            if (!world.areBlocksLoaded(x - byte0, y - byte0, z - byte0, x + byte0, y + byte0, z + byte0)) {
                world.setBlockWithNotify(x, y, z, 0);
                while (MudBlock.canFallBelow(world, x, y - 1, z) && y > 0) {
                    --y;
                }
                if (y > 0) {
                    world.setBlockWithNotify(x, y, z, this.id);
                }
            } else {
                FallingBlockEntity fallingBlockEntity = new FallingBlockEntity(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, this.id, 0, null);
                world.entityJoinedWorld(fallingBlockEntity);
            }
        }
    }

    public static boolean canFallBelow(World world, int x, int y, int z) {
        int blockId = world.getBlockId(x, y, z);
        if (blockId == 0) {
            return true;
        }
        if (blockId == Blocks.FIRE.id) {
            return true;
        }
        if (Block.hasTag(blockId, BlockTags.IS_WATER)) {
            return true;
        }
        return Block.hasTag(blockId, BlockTags.IS_LAVA);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (this.isHardened && !this.isLavaNearby(world, x, y, z) && this.canBecomeWet(world, x, y, z)) {
            world.setBlock(x, y, z, Blocks.MUD.id);
            world.notifyBlockChange(x, y, z, Blocks.MUD.id);
            return;
        }
        if (!this.isHardened && (this.isLavaNearby(world, x, y, z) || world.dimension.id == Dimension.NETHER.id)) {
            world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.spawnParticle("largesmoke", (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0, 0);
            }
            world.setBlock(x, y, z, Blocks.MUD_BAKED.id);
            world.notifyBlockChange(x, y, z, Blocks.MUD_BAKED.id);
            return;
        }
        this.tryToFall(world, x, y, z);
    }
}

