/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.achievement.Achievements;
import net.minecraft.core.block.EntityBlock;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.entity.SignBlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class SignBlock
extends EntityBlock {
    private final boolean isFreeStanding;

    public SignBlock(String key, String namespaceId, int id, boolean isFreeStanding) {
        super(key, namespaceId, id, Material.wood);
        this.isFreeStanding = isFreeStanding;
        float f = 0.25f;
        float f1 = 1.0f;
        this.setBlockBounds(0.5f - f, 0.0, 0.5f - f, 0.5f + f, f1, 0.5f + f);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        return null;
    }

    @Override
    public AABB getSelectedBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        this.setBlockBoundsBasedOnState(world, x, y, z);
        return super.getSelectedBoundingBoxFromPool(world, x, y, z);
    }

    @Override
    public void setBlockBoundsBasedOnState(WorldSource world, int x, int y, int z) {
        if (this.isFreeStanding) {
            return;
        }
        int l = world.getBlockMetadata(x, y, z);
        float f = 0.28125f;
        float f1 = 0.78125f;
        float f2 = 0.0f;
        float f3 = 1.0f;
        float f4 = 0.125f;
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        if (l == 2) {
            this.setBlockBounds(f2, f, 1.0f - f4, f3, f1, 1.0);
        }
        if (l == 3) {
            this.setBlockBounds(f2, f, 0.0, f3, f1, f4);
        }
        if (l == 4) {
            this.setBlockBounds(1.0f - f4, f, f2, 1.0, f1, f3);
        }
        if (l == 5) {
            this.setBlockBounds(0.0, f, f2, f4, f1, f3);
        }
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    protected BlockEntity getNewBlockEntity() {
        return new SignBlockEntity();
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        boolean flag = false;
        if (this.isFreeStanding) {
            if (!world.getBlockMaterial(x, y - 1, z).isSolid()) {
                flag = true;
            }
        } else {
            int i1 = world.getBlockMetadata(x, y, z);
            flag = true;
            if (i1 == 2 && world.getBlockMaterial(x, y, z + 1).isSolid()) {
                flag = false;
            }
            if (i1 == 3 && world.getBlockMaterial(x, y, z - 1).isSolid()) {
                flag = false;
            }
            if (i1 == 4 && world.getBlockMaterial(x + 1, y, z).isSolid()) {
                flag = false;
            }
            if (i1 == 5 && world.getBlockMaterial(x - 1, y, z).isSolid()) {
                flag = false;
            }
        }
        if (flag) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null, null);
            world.setBlockWithNotify(x, y, z, 0);
        }
        super.onNeighborBlockChange(world, x, y, z, blockId);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, BlockEntity blockEntity) {
        return new ItemStack[]{new ItemStack(Items.SIGN)};
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        SignBlockEntity signEntity = (SignBlockEntity)world.getBlockEntity(x, y, z);
        if (signEntity != null && player != null) {
            if (player.getHeldItem() != null && player.getHeldItem().itemID == Items.DUST_GLOWSTONE.id && !signEntity.isGlowing()) {
                signEntity.setGlowing(true);
                if (player.getGamemode().consumeBlocks()) {
                    --player.getHeldItem().stackSize;
                }
                player.addStat(Achievements.LIGHT_SIGN, 1);
                return true;
            }
            if (player.getHeldItem() != null && player.getHeldItem().itemID == Items.DYE.id) {
                return false;
            }
            if (signEntity.isEditableBy(player)) {
                player.displaySignEditorScreen(signEntity);
                return true;
            }
        }
        return false;
    }
}

