/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.world.World;

public class SnowBlock
extends Block {
    public SnowBlock(String key, String namespaceId, int id) {
        super(key, namespaceId, id, Material.snow);
        this.setTicking(true);
    }

    public int quantityDropped(int meta, Random rand) {
        return 4;
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (world.getSavedLightValue(LightLayer.Block, x, y, z) > 11) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null, null);
            world.setBlockWithNotify(x, y, z, 0);
        }
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, BlockEntity blockEntity) {
        switch (dropCause) {
            case PICK_BLOCK: 
            case SILK_TOUCH: {
                return new ItemStack[]{new ItemStack(this)};
            }
        }
        return new ItemStack[]{new ItemStack(Items.AMMO_SNOWBALL, 4)};
    }
}

