/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.FlowerBlock;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;

public class StackedFlowerBlock
extends FlowerBlock {
    public static final int MASK_STACK_COUNT = 96;
    public static final int OFFSET_STACK_COUNT = 5;
    public static final int MAX_STACK_COUNT = 3;

    public StackedFlowerBlock(String key, String namespaceId, int id) {
        super(key, namespaceId, id);
    }

    @Override
    public int getPlacedBlockMetadata(@Nullable Player player, ItemStack stack, World world, int x, int y, int z, Side side, double xPlaced, double yPlaced) {
        int metadata = stack.getMetadata();
        return StackedFlowerBlock.setPermanent(metadata, true);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, BlockEntity blockEntity) {
        int stackCount = StackedFlowerBlock.getStackCount(meta) + 1;
        if (dropCause == EnumDropCause.PICK_BLOCK) {
            return new ItemStack[]{new ItemStack(this, 1, 0)};
        }
        if (dropCause == EnumDropCause.SILK_TOUCH) {
            return new ItemStack[]{new ItemStack(this, 1, meta & 0x60)};
        }
        return new ItemStack[]{new ItemStack(this, stackCount, 0)};
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xHit, double yHit) {
        int metadata = world.getBlockMetadata(x, y, z);
        int currentStackCount = StackedFlowerBlock.getStackCount(metadata);
        if (currentStackCount >= 3) {
            return false;
        }
        ItemStack heldItem = player.getHeldItem();
        if (heldItem == null || heldItem.stackSize < 1 || heldItem.getItem().id != this.id) {
            return false;
        }
        int newMetadata = StackedFlowerBlock.setPermanent(StackedFlowerBlock.setStackCount(metadata, currentStackCount + 1), true);
        world.setBlockMetadataWithNotify(x, y, z, newMetadata);
        world.playBlockSoundEffect(player, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, this, EnumBlockSoundEffectType.PLACE);
        heldItem.consumeItem(player);
        return true;
    }

    public static int getStackCount(int metadata) {
        return (metadata & 0x60) >> 5;
    }

    public static int setStackCount(int metadata, int stackCount) {
        return metadata & 0xFFFFFF9F | stackCount << 5 & 0x60;
    }
}

