/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.piston;

import java.util.ArrayList;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.piston.MovingPistonBlock;
import net.minecraft.core.block.piston.PistonBaseBlock;
import net.minecraft.core.block.piston.PistonHeadBlock;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.FallingBlockEntity;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.IVehicle;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class SteelPistonBaseBlock
extends PistonBaseBlock {
    public static final double HEAD_THICKNESS_STEEL = 0.375;
    private Entity flungBlock = null;

    public SteelPistonBaseBlock(String key, String namespaceId, int id, int maxPushedBlocks) {
        super(key, namespaceId, id, maxPushedBlocks);
    }

    @Override
    public void setBlockBoundsBasedOnState(WorldSource world, int x, int y, int z) {
        int data = world.getBlockMetadata(x, y, z);
        if (SteelPistonBaseBlock.isPowered(data)) {
            switch (SteelPistonBaseBlock.getDirection(data)) {
                case DOWN: {
                    this.setBlockBounds(0.0, 0.375, 0.0, 1.0, 1.0, 1.0);
                    break;
                }
                case UP: {
                    this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.625, 1.0);
                    break;
                }
                case NORTH: {
                    this.setBlockBounds(0.0, 0.0, 0.375, 1.0, 1.0, 1.0);
                    break;
                }
                case SOUTH: {
                    this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 0.625);
                    break;
                }
                case WEST: {
                    this.setBlockBounds(0.375, 0.0, 0.0, 1.0, 1.0, 1.0);
                    break;
                }
                case EAST: {
                    this.setBlockBounds(0.0, 0.0, 0.0, 0.625, 1.0, 1.0);
                }
            }
        } else {
            this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
    }

    @Override
    protected boolean canPushLine(World world, int x, int y, int z, Direction direction, int maxPushedBlocks) {
        int blocks;
        int xo = x + direction.getOffsetX();
        int yo = y + direction.getOffsetY();
        int zo = z + direction.getOffsetZ();
        boolean didCrush = false;
        for (blocks = 0; blocks < maxPushedBlocks + 1; ++blocks) {
            if (yo < 0 || yo >= world.getHeightBlocks()) {
                return false;
            }
            int id = world.getBlockId(xo, yo, zo);
            if (id == 0) break;
            if (!this.isPushable(id, world, xo, yo, zo, true)) {
                if (blocks == 1 && BlockTags.PISTON_CRUSHING.appliesTo(Block.getBlock(id)) && this.tryCrush(world, x, y, z, direction)) {
                    didCrush = true;
                    break;
                }
                return false;
            }
            if (Block.blocksList[id].getPistonPushReaction(world, xo, yo, zo) == 1) break;
            if (blocks == maxPushedBlocks) {
                return false;
            }
            xo += direction.getOffsetX();
            yo += direction.getOffsetY();
            zo += direction.getOffsetZ();
        }
        if (!didCrush && blocks == 1) {
            xo = x + direction.getOffsetX();
            Block block = world.getBlock(xo, yo = y + direction.getOffsetY(), zo = z + direction.getOffsetZ());
            if (block == null) {
                return true;
            }
            int blockMeta = world.getBlockMetadata(xo, yo, zo);
            BlockEntity blockEntity = world.getBlockEntity(xo, yo, zo);
            world.removeBlockTileEntity(xo, yo, zo);
            world.setBlockWithNotify(xo, yo, zo, 0);
            FallingBlockEntity fallingBlockEntity = new FallingBlockEntity(world, (double)xo + 0.5, (double)yo + 0.5, (double)zo + 0.5, block.id, blockMeta, blockEntity);
            fallingBlockEntity.hasRemovedBlock = true;
            if (blockEntity instanceof IVehicle) {
                Entity rider = ((IVehicle)((Object)blockEntity)).getPassenger();
                ((IVehicle)((Object)blockEntity)).ejectRider();
                if (rider != null) {
                    rider.startRiding(fallingBlockEntity);
                }
            }
            world.entityJoinedWorld(fallingBlockEntity);
            double speed = 2.0;
            fallingBlockEntity.fling((double)direction.getOffsetX() * 2.0, (double)direction.getOffsetY() * 2.0, (double)direction.getOffsetZ() * 2.0, 1.0f);
            this.flungBlock = fallingBlockEntity;
        }
        return true;
    }

    @Override
    public boolean tryCrush(World world, int x, int y, int z, Direction direction) {
        int z2;
        int y2;
        int x2 = x + direction.getOffsetX();
        Block block = world.getBlock(x2, y2 = y + direction.getOffsetY(), z2 = z + direction.getOffsetZ());
        if (block == null) {
            return true;
        }
        world.playBlockEvent(null, 2001, x2, y2, z2, world.getBlockId(x2, y2, z2));
        block.dropBlockWithCause(world, EnumDropCause.PISTON_CRUSH, x2, y2, z2, world.getBlockMetadata(x2, y2, z2), null, null);
        world.setBlockWithNotify(x2, y2, z2, 0);
        return true;
    }

    @Override
    public void extendEvent(World world, int x, int y, int z, int data, Direction direction) {
        ArrayList<Entity> entityList = new ArrayList<Entity>(world.getEntitiesWithinAABBExcludingEntity(null, AABB.getTemporaryBB((double)x + (double)direction.getOffsetX(), (double)y + (double)direction.getOffsetY(), (double)z + (double)direction.getOffsetZ(), (double)x + (double)direction.getOffsetX() + 1.0, (double)y + (double)direction.getOffsetY() + 1.0, (double)z + (double)direction.getOffsetZ() + 1.0)));
        for (Entity entity : entityList) {
            if (entity == null || entity.noPhysics || entity == this.flungBlock) continue;
            double speed = 2.0;
            entity.fling((double)direction.getOffsetX() * 2.0, (double)direction.getOffsetY() * 2.0, (double)direction.getOffsetZ() * 2.0, 1.0f);
        }
        this.flungBlock = null;
        super.extendEvent(world, x, y, z, data, direction);
    }

    @Override
    public void createPistonHeadAt(World world, int x, int y, int z, int data, Direction direction) {
        world.setBlockAndMetadata(x, y, z, Blocks.PISTON_MOVING.id, PistonHeadBlock.setPistonType(2, direction.getId()));
        world.replaceBlockTileEntity(x, y, z, MovingPistonBlock.createTileEntity(Blocks.PISTON_HEAD_STEEL.id, PistonHeadBlock.setPistonType(2, direction.getId()), null, direction, true, false));
    }
}

